/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.parser;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.parser.tsa.TSRParserBuilder;
import esecurity.validator.parser.utils.EventHandlerMultiSelector;
import esecurity.validator.parser.utils.EventHandlerSelector;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCContainerFactory;
import it.actalis.ellips.capi.asic.parser.util.ASiCContentData;
import it.actalis.ellips.capi.asic.utils.MetaInfDocInfo;
import it.actalis.ellips.capi.asic.utils.MetaInfSignatureInfo;
import it.actalis.ellips.capi.asic.utils.xml.ASiCXMLUtils;
import it.actalis.ellips.capi.cms.parser.CadesParserBuilder;
import it.actalis.ellips.capi.container.ContainerParser;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.ByteInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.utils.xml.ASiCManifestType;
import it.actalis.ellips.capi.utils.xml.DataObjectReferenceType;
import it.actalis.ellips.capi.utils.xml.ReferenceType;
import it.actalis.ellips.capi.utils.xml.SignatureType;
import it.actalis.ellips.capi.utils.xml.XAdESSignaturesType;
import it.actalis.ellips.capi.xml.parser.XadesParserBuilder;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.naming.OperationNotSupportedException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCInternalParser
extends ContainerParser<ASiCContainer> {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private ZipInputStream zis;
    private InputStream innerInputStream;
    private ZipEntry ze;
    private Map<String, ASiCContentData> contentsData;
    private Map<String, MetaInfSignatureInfo> signaturesData;
    private Map<String, List<String>> links;
    private final ASiCContainerFactory envFactory = new ASiCContainerFactory();
    private final NetworkConfig config;
    private final TimeZone timeZone;
    private ASiCSignatureType asicSignType = null;

    private boolean processMimeType() throws CapiException, IOException {
        if (!"mimetype".equals(this.ze.getName())) {
            if (this.envFactory.getFormat() == null) {
                throw new CapiException("ASiC format should be specified in mimetype or file extension.", 50023);
            }
            return false;
        }
        if (this.ze.getMethod() != 0) {
            throw new CapiException("MIME type file inside ASiC has incorrect format: ZIP method is not STORE.", 50023);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String mimeContent = null;
        try {
            int data;
            while ((data = this.zis.read()) >= 0) {
                bos.write((byte)data);
            }
            bos.flush();
            mimeContent = new String(bos.toByteArray());
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {
                logger.error("Unable to close byte array output stream.", (Throwable)ex);
            }
        }
        this.envFactory.setMimetypeContent(mimeContent);
        ASiCFormat asicMimeFormat = null;
        if ("application/vnd.etsi.asic-s+zip".equals(mimeContent)) {
            asicMimeFormat = ASiCFormat.SIMPLE;
        } else if ("application/vnd.etsi.asic-e+zip".equals(mimeContent)) {
            asicMimeFormat = ASiCFormat.EXTENDED;
        }
        if (this.envFactory.getFormat() == null) {
            if (asicMimeFormat == null) {
                throw new CapiException("MIME type inside file is not an ASiC one and MIME type could not be inferred from file extension.", 50023);
            }
            this.envFactory.setFormat(asicMimeFormat);
        } else if (asicMimeFormat != null && asicMimeFormat != this.envFactory.getFormat()) {
            throw new CapiException("MIME type inside file is not conformant with file extension.", 50023);
        }
        return true;
    }

    private void processDataEntry() throws CapiException, IOException {
        try (CacheOutputStream bos = new CacheOutputStream(8192);){
            int data;
            while ((data = this.zis.read()) >= 0) {
                bos.write((int)((byte)data));
            }
            bos.flush();
            ASiCContentData acd = new ASiCContentData();
            InputHandler ih = DataHandlerBuilder.get().setInputStream(bos.getCache(false)).setName(this.ze.getName()).buildInput();
            acd.setContentData(ih);
            this.contentsData.put(this.ze.getName(), acd);
            if (this.envFactory.getFormat() != null && this.envFactory.getFormat().equals((Object)ASiCFormat.SIMPLE) && !this.signaturesData.isEmpty()) {
                Map.Entry<String, MetaInfSignatureInfo> entry = this.signaturesData.entrySet().iterator().next();
                entry.getValue().setDataFilename(this.ze.getName());
            }
        }
    }

    private void processMetaInfEntry() throws CapiException, IOException {
        byte[] metaInfEntryContent;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int data;
            while ((data = this.zis.read()) >= 0) {
                bos.write((byte)data);
            }
            bos.flush();
            metaInfEntryContent = bos.toByteArray();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {
                logger.error("Unable to close byte output stream.", (Throwable)ex);
            }
        }
        if (this.ze.getName().matches("META-INF/ASiCManifest.*[.]xml")) {
            this.processCadesMetaInfManifest(this.ze.getName(), metaInfEntryContent);
        } else if (this.isValidSignatureFilename(this.ze.getName()) && !this.ze.getName().equals("META-INF/manifest.xml")) {
            if (this.signaturesData.containsKey(this.ze.getName())) {
                MetaInfSignatureInfo misi = this.signaturesData.get(this.ze.getName());
                misi.setSignedContent(metaInfEntryContent);
            } else {
                MetaInfSignatureInfo misi = new MetaInfSignatureInfo();
                if ((this.envFactory.getFormat() == null || !this.envFactory.getFormat().equals((Object)ASiCFormat.EXTENDED)) && this.envFactory.getFormat() != null && this.envFactory.getFormat().equals((Object)ASiCFormat.SIMPLE)) {
                    if (!this.contentsData.isEmpty()) {
                        misi.setDataFilename(this.contentsData.keySet().iterator().next());
                    }
                    misi.setSignatureFilename(this.ze.getName());
                    HashMap hashMap = new HashMap();
                }
                misi.setSignedContent(metaInfEntryContent);
                this.signaturesData.put(this.ze.getName(), misi);
            }
            if (this.envFactory.getFormat() == ASiCFormat.EXTENDED && this.ze.getName().matches("META-INF/.*signatures.*[.]xml")) {
                this.processXADESSignaturesFile(metaInfEntryContent);
            }
        }
    }

    private boolean isValidSignatureFilename(String signatureFilename) {
        boolean isSimpleOk = this.envFactory.getFormat() == ASiCFormat.SIMPLE && (signatureFilename.equals("META-INF/signature.p7s") || signatureFilename.equals("META-INF/signatures.xml") || signatureFilename.equals("META-INF/timestamp.tst"));
        boolean isExtendedOk = this.envFactory.getFormat() == ASiCFormat.EXTENDED && (signatureFilename.matches("META-INF/.*signature.*[.]p7s") || signatureFilename.matches("META-INF/.*signatures.*[.]xml") || signatureFilename.matches("META-INF/.*timestamp.*[.]tst"));
        return isSimpleOk || isExtendedOk;
    }

    private boolean isValidManifestFilename(String manifestFileName) {
        return manifestFileName.matches("META-INF/ASiCManifest.*[.]xml") || manifestFileName.equals("META-INF/manifest.xml");
    }

    private <T> T processCommonMetaInfManifest(byte[] metaInfContentEntry, Class<T> manifestType) throws CapiException {
        ByteArrayInputStream bais = new ByteArrayInputStream(metaInfContentEntry);
        if (!ASiCXMLUtils.isValidManifest(bais)) {
            throw new CapiException("XML file is not a valid ASiC manifest.", 3010);
        }
        bais.reset();
        Object manifest = null;
        try {
            JacksonXmlModule jacksonXmlModule = new JacksonXmlModule();
            jacksonXmlModule.setDefaultUseWrapper(false);
            WstxInputFactory inputFactory = new WstxInputFactory();
            WstxOutputFactory outputFactory = new WstxOutputFactory();
            XmlFactory xmlFactory = new XmlFactory((XMLInputFactory)inputFactory, (XMLOutputFactory)outputFactory);
            XmlMapper mapper = new XmlMapper(xmlFactory, jacksonXmlModule);
            mapper.registerModule((Module)new JaxbAnnotationModule());
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            manifest = mapper.readValue(metaInfContentEntry, manifestType);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
        if (manifest == null) {
            CapiException ex = new CapiException("Unable to parse ASiC manifest.", 3010);
            logger.error("Unable to parse ASiC manifest: ", (Throwable)ex);
            throw ex;
        }
        return (T)manifest;
    }

    private void processXadesMetaInfManifest(String manifestName, byte[] metaInfContentEntry) throws CapiException {
        XAdESSignaturesType manifest = this.processCommonMetaInfManifest(metaInfContentEntry, XAdESSignaturesType.class);
        MetaInfSignatureInfo misi = new MetaInfSignatureInfo();
        List<SignatureType> signatures = manifest.getSignature();
        misi.setDataFilename(manifestName);
        misi.setSignatureFilename(manifestName);
        misi.setManifestContent(metaInfContentEntry);
        HashMap docsMap = new HashMap();
    }

    private void processCadesMetaInfManifest(String manifestName, byte[] metaInfContentEntry) throws CapiException {
        MetaInfSignatureInfo misi;
        ASiCManifestType manifest = this.processCommonMetaInfManifest(metaInfContentEntry, ASiCManifestType.class);
        String sigReferenceURI = manifest.getSigReference().getURI();
        if (this.signaturesData.containsKey(sigReferenceURI)) {
            misi = this.signaturesData.get(sigReferenceURI);
        } else {
            misi = new MetaInfSignatureInfo();
            this.signaturesData.put(sigReferenceURI, misi);
        }
        misi.setDataFilename(manifestName);
        misi.setSignatureFilename(sigReferenceURI);
        misi.setManifestContent(metaInfContentEntry);
        HashMap<String, MetaInfDocInfo> docsMap = new HashMap<String, MetaInfDocInfo>();
        for (DataObjectReferenceType objRef : manifest.getDataObjectReference()) {
            String objReferenceURI = objRef.getURI();
            MetaInfDocInfo midi = new MetaInfDocInfo();
            midi.setDataFilename(objReferenceURI);
            midi.setManifestFilename(manifestName);
            midi.setDigestMethod(DigestAlgorithm.valueFromXadesId((String)objRef.getDigestMethod().getAlgorithm()));
            midi.setDigestValue(objRef.getDigestValue());
            docsMap.put(objReferenceURI, midi);
        }
        misi.setDocsInfo(docsMap);
    }

    private void processXADESSignaturesFile(byte[] metaInfContentEntry) throws CapiException {
        ByteArrayInputStream bais = new ByteArrayInputStream(metaInfContentEntry);
        if (!ASiCXMLUtils.isValidASiCXADESSignature(bais)) {
            throw new CapiException("XML file is not conformant to XADES-E ASiC specifications.", 3010);
        }
        bais.reset();
        if (!this.ze.getName().matches("META-INF/.*signatures.*[.]xml")) {
            return;
        }
        XAdESSignaturesType xades = new XAdESSignaturesType();
        try {
            JacksonXmlModule jacksonXmlModule = new JacksonXmlModule();
            jacksonXmlModule.setDefaultUseWrapper(false);
            WstxInputFactory inputFactory = new WstxInputFactory();
            WstxOutputFactory outputFactory = new WstxOutputFactory();
            XmlFactory xmlFactory = new XmlFactory((XMLInputFactory)inputFactory, (XMLOutputFactory)outputFactory);
            XmlMapper mapper = new XmlMapper(xmlFactory, jacksonXmlModule);
            mapper.registerModule((Module)new JaxbAnnotationModule());
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            xades = (XAdESSignaturesType)mapper.readValue(metaInfContentEntry, XAdESSignaturesType.class);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (xades == null) {
            CapiException ex = new CapiException("Unable to parse XADES ASiC-E signatures.", 3010);
            logger.error("Unable to parse XADES ASiC-E signatures: ", (Throwable)ex);
            throw ex;
        }
        for (SignatureType sign : xades.getSignature()) {
            MetaInfSignatureInfo misi;
            List<ReferenceType> references = sign.getSignedInfo().getReference();
            if (this.signaturesData.containsKey(this.ze.getName())) {
                misi = this.signaturesData.get(this.ze.getName());
            } else {
                misi = new MetaInfSignatureInfo();
                this.signaturesData.put(this.ze.getName(), misi);
            }
            byte[] signatureData = this.retrieveSignature(bais, sign.getId());
            misi.setSignedContent(signatureData);
            misi.setDataFilename(this.ze.getName());
            misi.setSignatureFilename(this.ze.getName());
            misi.setManifestContent(metaInfContentEntry);
            HashMap<String, MetaInfDocInfo> docsMap = new HashMap<String, MetaInfDocInfo>();
            for (ReferenceType reference : references) {
                String objReferenceURI;
                try {
                    objReferenceURI = URLDecoder.decode(reference.getURI(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    objReferenceURI = reference.getURI();
                }
                if (this.links.containsKey(this.ze.getName())) {
                    this.links.get(this.ze.getName()).add(objReferenceURI);
                } else {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add(objReferenceURI);
                    this.links.put(this.ze.getName(), tmp);
                }
                if (reference.getType() != null && !reference.getType().equals("")) continue;
                MetaInfDocInfo midi = new MetaInfDocInfo();
                midi.setDataFilename(objReferenceURI);
                midi.setManifestFilename(this.ze.getName());
                midi.setDigestMethod(DigestAlgorithm.valueFromXadesId((String)reference.getDigestMethod().getAlgorithm()));
                midi.setDigestValue(reference.getDigestValue());
                docsMap.put(objReferenceURI, midi);
                misi.setDocsInfo(docsMap);
            }
        }
    }

    private byte[] retrieveSignature(ByteArrayInputStream bais, String signatureId) {
        try {
            bais.reset();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document document = dbf.newDocumentBuilder().parse(bais);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            NodeList xadesSignatureNodes = document.getElementsByTagName("asic:XAdESSignatures");
            if (xadesSignatureNodes.getLength() == 0) {
                xadesSignatureNodes = document.getElementsByTagNameNS("http://uri.etsi.org/02918/v1.2.1#", "XAdESSignatures");
            }
            if (xadesSignatureNodes.getLength() == 0) {
                xadesSignatureNodes = document.getElementsByTagName("ns:document-signatures");
            }
            if (xadesSignatureNodes.getLength() == 0) {
                xadesSignatureNodes = document.getElementsByTagName("signatures");
            }
            Node xadesSignatureNode = xadesSignatureNodes.item(0);
            NodeList signatureNodes = document.getElementsByTagName("ds:Signature");
            if (signatureNodes.getLength() == 0) {
                signatureNodes = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
            Node signatureNode = null;
            boolean found = false;
            for (int item = 0; !found && item < signatureNodes.getLength(); ++item) {
                signatureNode = signatureNodes.item(item);
                found = signatureNode.getAttributes().getNamedItem("Id").getNodeValue().equals(signatureId);
            }
            ArrayList<Node> xadesSignaturesNameSpace = this.retrieveNameSpace(xadesSignatureNode);
            ArrayList<Node> signatureNameSpace = this.retrieveNameSpace(signatureNode);
            xadesSignaturesNameSpace.removeAll(signatureNameSpace);
            for (Node nameSpace : xadesSignaturesNameSpace) {
                ((Element)signatureNode).setAttribute(nameSpace.getNodeName(), nameSpace.getNodeValue());
            }
            DOMSource dOMSource = new DOMSource(signatureNode);
            TransformerFactory.newInstance().newTransformer().transform(dOMSource, result);
            return out.toByteArray();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private ArrayList<Node> retrieveNameSpace(Node list) {
        NamedNodeMap attributes = list.getAttributes();
        ArrayList<Node> nameSpace = new ArrayList<Node>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!node.getNodeName().startsWith("xmlns")) continue;
            nameSpace.add(node);
        }
        return nameSpace;
    }

    private void linkSignatures() throws CapiException {
        if (this.signaturesData.isEmpty()) {
            throw new CapiException("META-INF has no signature file.", 50023);
        }
        if (this.contentsData.isEmpty()) {
            throw new CapiException("No data in the container.", 50023);
        }
        boolean foundDataRoot = false;
        for (String key : this.contentsData.keySet()) {
            if (key.contains("/")) continue;
            foundDataRoot = true;
            break;
        }
        if (!foundDataRoot) {
            throw new CapiException("No data in the container root.", 50023);
        }
        if (this.envFactory.getFormat() == ASiCFormat.SIMPLE) {
            if (this.signaturesData.size() > 1) {
                throw new CapiException("ASiC-S with more than one signature file.", 50023);
            }
            if (this.contentsData.size() > 1) {
                throw new CapiException("ASiC-S with more than one content file.", 50023);
            }
            String contentFilename = this.contentsData.keySet().iterator().next();
            if (contentFilename.startsWith("META-INF")) {
                throw new CapiException("ASiC-S with content not placed in container root.", 50023);
            }
        }
        ArrayList<String> contentFilenames = new ArrayList<String>(this.contentsData.keySet());
        int iSig = 0;
        for (String signatureFilename : this.signaturesData.keySet()) {
            MetaInfSignatureInfo misi = this.signaturesData.get(signatureFilename);
            if (misi == null) {
                throw new CapiException("Signature file '" + signatureFilename + "' is present in ASiC manifest but not" + " in META-INF folder.", 50023);
            }
            if (misi.getSignedContent() == null || misi.getManifestContent() != null && (misi.getDocsInfo() == null || misi.getDocsInfo().isEmpty())) {
                throw new CapiException("Signature " + signatureFilename + " not present or not associated with content.", 50023);
            }
            ArrayList<String> contents = new ArrayList<String>();
            if (misi.getManifestContent() != null) {
                contents.addAll(misi.getDocsInfo().keySet());
            } else {
                contents.add(misi.getDataFilename());
            }
            byte[] signData = misi.getSignedContent();
            if ("META-INF/signature.p7s".equals(signatureFilename) || signatureFilename.matches("META-INF/.*signature.*[.]p7s")) {
                this.asicSignType = ASiCSignatureType.CADES;
            } else if ("META-INF/signatures.xml".equals(signatureFilename) || signatureFilename.matches("META-INF/.*signatures.*[.]xml")) {
                this.asicSignType = ASiCSignatureType.XADES;
            } else if ("META-INF/timestamp.tst".equals(signatureFilename) || signatureFilename.matches("META-INF/.*timestamp.*[.]tst")) {
                this.asicSignType = ASiCSignatureType.TIMESTAMP;
            } else {
                throw new CapiException("META-INF has no valid signature file.", 50023);
            }
            if (this.envFactory.getSignatureType() == null) {
                this.envFactory.setSignatureType(this.asicSignType);
            } else if (this.envFactory.getSignatureType() != this.asicSignType) {
                throw new CapiException("Signatures of different types inside the same ASiC container.", 50023);
            }
            ParsedTransientDocument parsedTransientDocument = null;
            try {
                switch (this.asicSignType) {
                    case CADES: 
                    case TIMESTAMP: {
                        parsedTransientDocument = this.generateTransientDocument(signData, misi, this.getSignatureDetachedEntry(misi));
                        if (this.envFactory.getFormat() != ASiCFormat.EXTENDED) break;
                        ((SignatureInformation)parsedTransientDocument.getSignerInfo().get(iSig)).getRefDocs().clear();
                        parsedTransientDocument.getRefsDocs().clear();
                    }
                }
            }
            catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            ArrayList<InputHandler> handlers = new ArrayList<InputHandler>();
            for (String contentFilename : contents) {
                ASiCContentData contentData = this.contentsData.get(contentFilename);
                if (contentData == null) continue;
                handlers.add(contentData.getContentDataHandler());
            }
            for (String contentFilename : contents) {
                if (contentFilename == null) continue;
                int index = contentFilenames.indexOf(contentFilename);
                if (index >= 0) {
                    contentFilenames.remove(index);
                }
                if (signatureFilename.matches("META-INF/.*signatures.*[.]xml") && contentFilename.startsWith("#")) continue;
                ASiCContentData contentData = this.contentsData.get(contentFilename);
                this.verifyContentDataDigest(misi, contentData, contentFilename);
                try {
                    switch (this.asicSignType) {
                        case CADES: 
                        case TIMESTAMP: {
                            if (this.envFactory.getFormat() != ASiCFormat.EXTENDED) break;
                            ParsedTransientDocument t = new ParsedTransientDocument(DataHandlerBuilder.get().setInputStream(this.contentsData.get(contentFilename).getContentData()).setName(contentFilename).buildInput());
                            ((SignatureInformation)parsedTransientDocument.getSignerInfo().get(iSig)).addRefDoc(new ReferenceDoc(t.getId(), this.contentsData.get(contentFilename).isHashValid()));
                            break;
                        }
                        case XADES: {
                            ParsedTransientDocument xadesPTD = this.generateTransientDocument(signData, misi, handlers);
                            this.envFactory.addXadesTransientDocument(contentFilename, xadesPTD);
                        }
                    }
                }
                catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                this.envFactory.addObjectData(contentFilename, contentData);
                this.envFactory.addSignedFile(contentFilename, contentData);
            }
            switch (this.asicSignType) {
                case CADES: {
                    this.envFactory.addCadesTransientDocument(misi.getDataFilename().substring(misi.getDataFilename().lastIndexOf("/") + 1), parsedTransientDocument);
                    break;
                }
                case TIMESTAMP: {
                    this.envFactory.addTimestampTransientDocument(misi.getDataFilename().substring(misi.getDataFilename().lastIndexOf("/") + 1), parsedTransientDocument);
                }
            }
            ++iSig;
        }
        if (!contentFilenames.isEmpty()) {
            for (String contentFilename : contentFilenames) {
                ASiCContentData contentData = this.contentsData.get(contentFilename);
                this.envFactory.addUnsignedFile(contentFilename, contentData);
            }
        }
    }

    private InputHandler getSignatureDetachedEntry(MetaInfSignatureInfo misi) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, URISyntaxException, UnrecoverableKeyException {
        InputStream stream = null;
        String signedFileName = misi.getDataFilename().substring(misi.getDataFilename().lastIndexOf("/") + 1);
        if (this.envFactory.getFormat() == ASiCFormat.SIMPLE) {
            stream = this.contentsData.get(misi.getDataFilename()).getContentData();
        } else if (this.envFactory.getFormat() == ASiCFormat.EXTENDED) {
            stream = new ByteArrayInputStream(misi.getManifestContent());
        }
        return DataHandlerBuilder.get().setInputStream(stream).setName(signedFileName).buildInput();
    }

    private ParsedTransientDocument generateTransientDocument(byte[] signData, MetaInfSignatureInfo misi, InputHandler detachedEntry) throws ParsingException {
        ByteInputHandler bih = new ByteInputHandler(signData, misi.getSignatureFilename().substring(misi.getSignatureFilename().lastIndexOf("/") + 1));
        switch (this.asicSignType) {
            case CADES: {
                return new CadesParserBuilder().build((InputHandler)bih).parse((InputHandler)bih, (EventHandlerSelector)new EventHandlerSelectorImpl(detachedEntry), this.config, this.timeZone);
            }
            case TIMESTAMP: {
                return new TSRParserBuilder().build((InputHandler)bih).parse((InputHandler)bih, (EventHandlerSelector)new EventHandlerSelectorImpl(detachedEntry), this.config, this.timeZone);
            }
            case XADES: {
                return new XadesParserBuilder().build((InputHandler)bih).parse((InputHandler)bih, (EventHandlerSelector)new EventHandlerSelectorImpl(detachedEntry), this.config, this.timeZone);
            }
        }
        return null;
    }

    private ParsedTransientDocument generateTransientDocument(byte[] signData, MetaInfSignatureInfo misi, List<InputHandler> detachedEntries) throws ParsingException {
        ByteInputHandler bih = new ByteInputHandler(signData, misi.getSignatureFilename().substring(misi.getSignatureFilename().lastIndexOf("/") + 1));
        switch (this.asicSignType) {
            case XADES: {
                return new XadesParserBuilder().build((InputHandler)bih).parse((InputHandler)bih, (EventHandlerSelector)new EventHandlerMultiSelectorImpl(detachedEntries), this.config, this.timeZone);
            }
        }
        return null;
    }

    private void verifyContentDataDigest(MetaInfSignatureInfo misi, ASiCContentData contentData, String contentFilename) throws CapiException {
        if (contentData == null) {
            throw new CapiException("Manifest contains file that are not present.", 50023);
        }
        InputStream contentDataStream = contentData.getContentData();
        if (this.envFactory.getFormat() == ASiCFormat.EXTENDED) {
            MetaInfDocInfo midi = misi.getDocsInfo().get(contentFilename);
            MessageDigest md = DigestUtils.getDigest((String)midi.getDigestMethod().toString());
            try {
                byte[] calculdatedHash = DigestUtils.updateDigest((MessageDigest)md, (InputStream)contentDataStream).digest();
                if (Arrays.equals(calculdatedHash, midi.getDigestValue())) {
                    this.contentsData.get(contentFilename).setHashValid(true);
                }
            }
            catch (IOException e) {
                throw new CapiException("Error when process ASiC-E File", 1003, (Throwable)e);
            }
        }
    }

    private void reset() {
        this.zis = null;
        this.ze = null;
        this.contentsData = new HashMap<String, ASiCContentData>();
        this.signaturesData = new HashMap<String, MetaInfSignatureInfo>();
        this.links = new HashMap<String, List<String>>();
        this.envFactory.reset();
    }

    public ASiCInternalParser(NetworkConfig config, TimeZone timeZone) {
        this.config = config;
        this.timeZone = timeZone;
    }

    public ASiCContainer parse(InputHandler in) throws CapiException {
        this.reset();
        String fileExt = in.getName();
        int lastDotIndex = fileExt.lastIndexOf(".");
        String string = fileExt = lastDotIndex >= 0 ? fileExt.substring(lastDotIndex) : "";
        if (fileExt.equalsIgnoreCase(".scs") || fileExt.equalsIgnoreCase(".asics")) {
            this.envFactory.setFormat(ASiCFormat.SIMPLE);
        } else if (fileExt.equalsIgnoreCase(".sce") || fileExt.equalsIgnoreCase(".asice")) {
            this.envFactory.setFormat(ASiCFormat.EXTENDED);
        }
        InputStream loadedInputStream = null;
        try {
            loadedInputStream = in.getInputAsNewStream();
        }
        catch (IOException ex) {
            throw new CapiException("IOException occurred: " + ex.getMessage(), 1003);
        }
        if (loadedInputStream instanceof ZipInputStream) {
            throw new CapiException("The input stream to read should be passed as a simple input stream, not already as a ZipInputStream (e.g. FileInputStream is ok).", 1002);
        }
        this.innerInputStream = new BufferedInputStream(loadedInputStream);
        this.zis = new ZipInputStream(this.innerInputStream);
        try {
            if (this.envFactory.getFormat() == null) {
                this.envFactory.setFormat(this.getFormatFromMime(new ZipInputStream(new BufferedInputStream(in.getInputAsNewStream()))));
            }
            this.ze = this.zis.getNextEntry();
            if (this.ze == null) {
                throw new CapiException("Container is empty.", 50023);
            }
            if (this.processMimeType()) {
                this.ze = this.zis.getNextEntry();
            }
            while (this.ze != null) {
                if (!this.ze.isDirectory()) {
                    boolean startWithMetaInf = this.ze.getName().startsWith("META-INF/");
                    boolean isASiCManifest = this.isValidManifestFilename(this.ze.getName());
                    boolean isValidSignName = this.isValidSignatureFilename(this.ze.getName());
                    if ("mimetype".equals(this.ze.getName())) {
                        this.processMimeType();
                    } else if (startWithMetaInf && (isASiCManifest || isValidSignName)) {
                        this.processMetaInfEntry();
                    } else {
                        this.processDataEntry();
                    }
                }
                this.ze = this.zis.getNextEntry();
            }
            this.linkSignatures();
        }
        catch (CapiException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new CapiException("IOException occurred: " + ex.getMessage(), 1003);
        }
        finally {
            try {
                this.zis.close();
            }
            catch (IOException ex) {
                logger.error("Unable to close input ZIP stream.", (Throwable)ex);
            }
        }
        try {
            return this.envFactory.buildASiCContainer();
        }
        catch (OperationNotSupportedException ex) {
            throw new CapiException("Error during ASiC container build, see inner exception.", 1003, (Throwable)ex);
        }
    }

    private ASiCFormat getFormatFromMime(ZipInputStream zis) throws IOException, CapiException {
        try {
            ASiCFormat aSiCFormat;
            ZipEntry entry;
            String mimeContent = "";
            boolean found = false;
            while ((entry = zis.getNextEntry()) != null && !found) {
                if (!entry.getName().equals("mimetype")) continue;
                found = true;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                try {
                    int data;
                    while ((data = zis.read(buffer, 0, 8192)) >= 0) {
                        bos.write(buffer, 0, data);
                    }
                    bos.flush();
                    mimeContent = new String(bos.toByteArray());
                }
                catch (IOException ex) {
                    throw ex;
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {
                        logger.error("Unable to close byte array output stream.", (Throwable)ex);
                    }
                }
            }
            if ("application/vnd.etsi.asic-s+zip".equals(mimeContent)) {
                aSiCFormat = ASiCFormat.SIMPLE;
                return aSiCFormat;
            }
            if ("application/vnd.etsi.asic-e+zip".equals(mimeContent)) {
                aSiCFormat = ASiCFormat.EXTENDED;
                return aSiCFormat;
            }
        }
        catch (Throwable ex) {
            logger.error("ASIC/Zip decoding error", ex);
            throw new CapiException("ASiC format should be specified in mimetype or file extension.", 50023);
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException ex) {
                logger.error("Unable to close input ZIP stream.", (Throwable)ex);
            }
        }
        throw new CapiException("ASiC format should be specified in mimetype or file extension.", 50023);
    }

    private static class EventHandlerMultiSelectorImpl
    implements EventHandlerMultiSelector {
        private final HashMap<String, InputHandler> handlersMap = new HashMap();
        private final InputHandler firstHandler;

        public EventHandlerMultiSelectorImpl(List<InputHandler> inputHandlers) {
            this.firstHandler = inputHandlers.get(0);
            for (InputHandler handler : inputHandlers) {
                this.handlersMap.put(handler.getName(), handler);
            }
        }

        public InputHandler selectHandler(String resourceName) {
            return this.handlersMap.get(resourceName);
        }

        public List<InputHandler> selectAllHandler() {
            return new ArrayList<InputHandler>(this.handlersMap.values());
        }

        public InputHandler selectHandler() {
            return this.firstHandler;
        }
    }

    private static class EventHandlerSelectorImpl
    implements EventHandlerSelector {
        private final InputHandler entry;

        public EventHandlerSelectorImpl(InputHandler entry) {
            this.entry = entry;
        }

        public InputHandler selectHandler() {
            return this.entry;
        }
    }
}

