/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.generator;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.asic.ASiCConst;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.asic.utils.ASiCCommonUtils;
import it.actalis.ellips.capi.asic.utils.MetaInfSignatureInfo;
import it.actalis.ellips.capi.asic.utils.xml.ASiCXMLUtils;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.container.ContainerGenerator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.util.ClonerInputStream;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class ASiCGenerator
extends ContainerGenerator<ASiCGeneratorOptions, SignatureOptions> {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private List<IterInputFileInfo> iterInputFileList;
    private boolean iterIsDir;
    private java.io.File iterBaseDir;
    private Map<byte[], MetaInfSignatureInfo> metaInfSignatures;
    private ZipOutputStream zos;
    private ASiCGeneratorOptions options;

    private String getSimpleSignatureFilename() {
        switch (this.options.getAsicOpts().getSignatureType()) {
            case CADES: {
                return "META-INF/signature.p7s";
            }
            case XADES: {
                return "META-INF/signatures.xml";
            }
            case TIMESTAMP: {
                return "META-INF/timestamp.tst";
            }
        }
        return null;
    }

    private String getExtendedSignatureFilename(int index) {
        switch (this.options.getAsicOpts().getSignatureType()) {
            case CADES: {
                return MessageFormat.format("META-INF/signature{0,number,#}.p7s", index);
            }
            case XADES: {
                return MessageFormat.format("META-INF/signatures{0,number,#}.xml", index);
            }
            case TIMESTAMP: {
                return MessageFormat.format("META-INF/timestamp{0,number,#}.tst", index);
            }
        }
        return null;
    }

    private void prepareCurrentIteration(SignatureOptions signEntry, boolean isEntryPoint) throws IOException {
        java.io.File inputFile = null;
        if (signEntry.getInput().getName() == null) {
            File tmp = TmpFileUtils.createTempFile((String)"asic_", (String)"");
            inputFile = new java.io.File(tmp.getName());
            tmp.delete();
        } else {
            inputFile = new java.io.File(signEntry.getInput().getName());
        }
        if (isEntryPoint) {
            this.iterInputFileList = new ArrayList<IterInputFileInfo>();
            this.iterIsDir = false;
            this.iterBaseDir = null;
        }
        this.iterInputFileList.add(new IterInputFileInfo(inputFile, signEntry.getInput().getInputAsNewStream()));
    }

    private void prepareCurrentIteration(SignatureOptions signEntry) throws IOException {
        this.prepareCurrentIteration(signEntry, true);
    }

    private void cleanupAfterIteration() {
        if (this.options.getAsicOpts().getFormat() == ASiCFormat.SIMPLE && this.iterIsDir) {
            for (IterInputFileInfo iifi : this.iterInputFileList) {
                iifi.outFile.delete();
            }
        }
    }

    private String getZipEntryName(java.io.File currentFile) {
        String zipFilename = null;
        if (!this.iterIsDir) {
            zipFilename = currentFile.getName();
        } else {
            switch (this.options.getAsicOpts().getFormat()) {
                case SIMPLE: {
                    zipFilename = ASiCConst.ASIC_S_ZIPPED_DIR_FILENAME.endsWith(".zip") ? ASiCConst.ASIC_S_ZIPPED_DIR_FILENAME : ASiCConst.ASIC_S_ZIPPED_DIR_FILENAME + ".zip";
                    break;
                }
                case EXTENDED: {
                    String baseAbsolutePath = this.iterBaseDir.getAbsolutePath();
                    String currentFilePath = currentFile.getAbsolutePath();
                    String zipPath = Util.getRelativePath((String)currentFilePath, (String)baseAbsolutePath, (String)java.io.File.pathSeparator);
                    zipFilename = zipPath.toString().replace(java.io.File.separator, "/");
                }
            }
        }
        return zipFilename;
    }

    private void createASiCManifestforCurrentIteration(MetaInfSignatureInfo info) throws IOException, XMLStreamException {
        if (this.options.getAsicOpts().getSignatureType() == ASiCSignatureType.XADES) {
            return;
        }
        String manifestFilename = MessageFormat.format("META-INF/ASiCManifest{0,number,#}.xml", info.getIndex());
        ZipEntry ze = new ZipEntry(manifestFilename);
        this.zos.putNextEntry(ze);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter xsw = xof.createXMLStreamWriter(this.zos, "UTF-8");
        ASiCXMLUtils.startManifest(xsw);
        ASiCXMLUtils.completeSigRef(xsw, info.getSignatureFilename(), this.options.getAsicOpts().getSignatureType());
        ASiCXMLUtils.completeDataObjRef(xsw, info.getDataFilename(), info.getDigestMethod(), Base64.toBase64String((byte[])info.getDigestValue()));
        ASiCXMLUtils.endManifest(xsw);
        xsw.flush();
        xsw.close();
    }

    protected void specificValidateOptions(ASiCGeneratorOptions opts) throws CapiException {
        if (opts.getAsicOpts().getFormat() == null) {
            throw new CapiException("ASiC options: desired ASiC format is null.", 1001);
        }
        if (opts.getAsicOpts().getSignatureType() == null) {
            throw new CapiException("ASiC options: desired signature type is null.", 1001);
        }
        if (opts.getAsicOpts().getFormat() == ASiCFormat.SIMPLE && opts.getSignEntriesOptions().size() != 1) {
            throw new CapiException("ASiC options: ASiC-S format detected, but more than one signing entry is specified.", 1002);
        }
        this.options = opts;
    }

    protected void specificValidateEntryOptions(SignatureOptions entryOpts) throws CapiException {
        if (entryOpts.getSignatureMode() == null) {
            entryOpts.setSignatureMode(SignatureMode.DETACHED);
        }
        if (entryOpts.getSignatureMode() != SignatureMode.DETACHED) {
            throw new CapiException("ASiC options: signing entry signature mode is not detached! In ASiC, only detached is supported. If you want you can pass null as signature mode and the container generator will handle the rest for you.", 1002);
        }
        if (this.options.getAsicOpts().getSignatureType() != ASiCSignatureType.TIMESTAMP) {
            if (entryOpts.getAlias() == null) {
                throw new CapiException("ASiC options: signing entry alias is null.", 1001);
            }
            if (entryOpts.getSignatureMode() == null) {
                entryOpts.setSignatureMode(SignatureMode.DETACHED);
            }
        }
        if (this.options.getAsicOpts().getSignatureType() == ASiCSignatureType.TIMESTAMP) {
            if (entryOpts.getTimeStampOptions() == null) {
                throw new CapiException("ASiC options: signature type is timestamp, but no timestamp options are specified.", 1002);
            }
            if (entryOpts.getTimeStampOptions().getTSAClient() == null) {
                throw new CapiException("ASiC options: signature type is timestamp, but no timestamp client is specified.", 1002);
            }
        }
    }

    protected void specificPreProcessEntries(ASiCGeneratorOptions opts) throws CapiException {
        try {
            OutputHandler outDoc = this.options.getOutDoc();
            this.zos = new ZipOutputStream(outDoc.getAsOutputStream());
            this.zos.setComment("mimetype=" + (this.options.getAsicOpts().getFormat() == ASiCFormat.SIMPLE ? "application/vnd.etsi.asic-s+zip" : "application/vnd.etsi.asic-e+zip"));
            byte[] mimeBytes = ASiCCommonUtils.getMimeTypeForFormat(opts.getAsicOpts().getFormat()).getBytes();
            CRC32 crc32 = new CRC32();
            crc32.update(mimeBytes);
            this.zos.setMethod(0);
            ZipEntry ze = new ZipEntry("mimetype");
            ze.setSize(mimeBytes.length);
            ze.setCompressedSize(mimeBytes.length);
            ze.setCrc(crc32.getValue());
            this.zos.putNextEntry(ze);
            this.zos.write(mimeBytes);
            this.zos.setMethod(8);
            this.metaInfSignatures = new HashMap<byte[], MetaInfSignatureInfo>();
        }
        catch (IOException ex) {
            try {
                this.zos.close();
            }
            catch (IOException e) {
                logger.error("Unable to close ZIP output stream.", (Throwable)e);
            }
            throw new CapiException("IOException occurred: ", 1003, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void specificPackEntry(SignatureOptions entryOpts) throws CapiException {
        try {
            this.prepareCurrentIteration(entryOpts);
            for (IterInputFileInfo iifi : this.iterInputFileList) {
                java.io.File currentFile = iifi.outFile;
                String zipFilename = this.getZipEntryName(currentFile);
                ZipEntry ze = new ZipEntry(zipFilename);
                this.zos.putNextEntry(ze);
                ByteArrayOutputStream metaInfOutputStream = new ByteArrayOutputStream();
                ClonerInputStream inputStream = new ClonerInputStream((InputStream)new BufferedInputStream(iifi.inStream), (OutputStream)this.zos);
                byte[] messageDigest = null;
                try {
                    block75: {
                        InputHandler doc;
                        block74: {
                            if (!this.options.getAsicOpts().getFormat().equals((Object)ASiCFormat.SIMPLE)) break block74;
                            switch (this.options.getAsicOpts().getSignatureType()) {
                                case CADES: {
                                    doc = DataHandlerBuilder.get().setInputStream((InputStream)inputStream).buildInput();
                                    CadesSignatureGenerator cades_gen = new CadesSignatureGenerator();
                                    CadesSignatureOptions cades_options = new CadesSignatureOptions();
                                    cades_options.setKeyStore(entryOpts.getKeyStore());
                                    cades_options.setKeyStorePassword(entryOpts.getKeyStorePassword());
                                    cades_options.setAlias(entryOpts.getAlias());
                                    cades_options.setSignatureMode(SignatureMode.DETACHED);
                                    cades_options.setSignatureLevel(entryOpts.getSignatureLevel());
                                    if (entryOpts.getSignatureLevel() != SignatureLevel.BES) {
                                        cades_options.setTimeStampOptions(entryOpts.getTimeStampOptions());
                                        cades_options.setCertdb(entryOpts.getCertdb());
                                    }
                                    cades_options.setInput(doc);
                                    cades_options.setOutput(DataHandlerBuilder.get().setOutputStream((OutputStream)metaInfOutputStream).buildOutput());
                                    cades_options.setDerEncoded(true);
                                    cades_options.setDigestAlgorithm(entryOpts.getDigestAlgorithm());
                                    cades_gen.sign((SignatureOptions)cades_options);
                                    break block75;
                                }
                                case TIMESTAMP: {
                                    byte[] ts = entryOpts.getTimeStampOptions().getTSAClient().stamp((InputStream)inputStream, entryOpts.getTimeStampOptions());
                                    TimeStampToken tsk = new TimeStampToken(ts);
                                    metaInfOutputStream.write(tsk.toByteArray(false, true));
                                    messageDigest = tsk.getHashedMessage();
                                    break block75;
                                }
                                case XADES: {
                                    doc = DataHandlerBuilder.get().setInputStream((InputStream)inputStream).buildInput();
                                    XadesSignatureGenerator xades_gen = new XadesSignatureGenerator();
                                    XadesSignatureOptions xades_options = new XadesSignatureOptions();
                                    xades_options.setKeyStore(entryOpts.getKeyStore());
                                    xades_options.setKeyStorePassword(entryOpts.getKeyStorePassword());
                                    xades_options.setAlias(entryOpts.getAlias());
                                    xades_options.setSignatureMode(SignatureMode.DETACHED);
                                    xades_options.setSignatureLevel(entryOpts.getSignatureLevel());
                                    if (entryOpts.getSignatureLevel() != SignatureLevel.BES) {
                                        xades_options.setTimeStampOptions(entryOpts.getTimeStampOptions());
                                        xades_options.setCertdb(entryOpts.getCertdb());
                                    }
                                    xades_options.setInput(doc);
                                    xades_options.setOutput(DataHandlerBuilder.get().setOutputStream((OutputStream)metaInfOutputStream).buildOutput());
                                    xades_options.setDigestAlgorithm(entryOpts.getDigestAlgorithm());
                                    xades_gen.sign((SignatureOptions)xades_options);
                                    metaInfOutputStream = ASiCXMLUtils.augmentXadesSignature(metaInfOutputStream);
                                    break block75;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Invalid signature type has been specified.");
                                }
                            }
                        }
                        if (this.options.getAsicOpts().getFormat().equals((Object)ASiCFormat.EXTENDED)) {
                            switch (this.options.getAsicOpts().getSignatureType()) {
                                case CADES: {
                                    doc = DataHandlerBuilder.get().setInputStream((InputStream)inputStream).buildInput();
                                    MessageDigest md = DigestUtils.getDigest((String)entryOpts.getDigestAlgorithm().toString());
                                    messageDigest = DigestUtils.updateDigest((MessageDigest)md, (InputStream)doc.getInputAsNewStream()).digest();
                                    break;
                                }
                                case TIMESTAMP: {
                                    doc = DataHandlerBuilder.get().setInputStream((InputStream)inputStream).buildInput();
                                    messageDigest = DigestUtils.sha256((InputStream)doc.getInputAsNewStream());
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Invalid signature type has been specified.");
                                }
                            }
                        }
                    }
                    metaInfOutputStream.flush();
                }
                catch (CapiException ex) {
                    throw ex;
                }
                catch (XMLStreamException ex) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)ex);
                }
                catch (SAXException ex) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)ex);
                }
                catch (TransformerException ex) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)ex);
                }
                catch (FileNotFoundException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (MalformedURLException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (KeyStoreException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (UnrecoverableKeyException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (KeyManagementException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (URISyntaxException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        logger.error("Unable to close input cloner stream.", (Throwable)ex);
                    }
                    try {
                        metaInfOutputStream.close();
                    }
                    catch (IOException ex) {
                        logger.error("Unable to close META-INF output stream.", (Throwable)ex);
                    }
                }
                MetaInfSignatureInfo info = new MetaInfSignatureInfo();
                info.setDataFilename(zipFilename);
                info.setDigestValue(messageDigest);
                info.setDigestMethod(entryOpts.getDigestAlgorithm());
                this.metaInfSignatures.put(metaInfOutputStream.toByteArray(), info);
                this.cleanupAfterIteration();
            }
        }
        catch (IOException ex) {
            throw new CapiException("IOException occurred.", 1003, (Throwable)ex);
        }
    }

    protected void specificPostProcessEntries(ASiCGeneratorOptions opts) throws CapiException {
        block44: {
            try {
                int i = 0;
                if (this.options.getAsicOpts().getFormat().equals((Object)ASiCFormat.SIMPLE)) {
                    for (Map.Entry<byte[], MetaInfSignatureInfo> metaInfEntry : this.metaInfSignatures.entrySet()) {
                        ++i;
                        byte[] signBlock = metaInfEntry.getKey();
                        MetaInfSignatureInfo info = metaInfEntry.getValue();
                        String signatureFilename = this.getSimpleSignatureFilename();
                        ZipEntry ze = new ZipEntry(signatureFilename);
                        this.zos.putNextEntry(ze);
                        ByteArrayInputStream metaInfInputStream = new ByteArrayInputStream(signBlock);
                        try {
                            int data;
                            while ((data = ((InputStream)metaInfInputStream).read()) >= 0) {
                                this.zos.write((byte)data);
                            }
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        finally {
                            try {
                                ((InputStream)metaInfInputStream).close();
                            }
                            catch (IOException ex) {
                                logger.error("Unable to close META-INF input stream.", (Throwable)ex);
                            }
                        }
                        if (opts.getAsicOpts().getFormat() == ASiCFormat.SIMPLE) continue;
                        info.setSignatureFilename(signatureFilename);
                        info.setIndex(i);
                    }
                    break block44;
                }
                if (!this.options.getAsicOpts().getFormat().equals((Object)ASiCFormat.EXTENDED)) break block44;
                ByteArrayOutputStream metaInfOutputStream = new ByteArrayOutputStream();
                String signatureFilename = this.getSimpleSignatureFilename();
                String manifestFilename = MessageFormat.format("META-INF/ASiCManifest{0,number,#}.xml", 1);
                ZipEntry ze = new ZipEntry(manifestFilename);
                this.zos.putNextEntry(ze);
                CacheOutputStream cos = new CacheOutputStream();
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter xsw = xof.createXMLStreamWriter((OutputStream)cos, "UTF-8");
                ASiCXMLUtils.startManifest(xsw);
                ASiCXMLUtils.completeSigRef(xsw, signatureFilename, this.options.getAsicOpts().getSignatureType());
                for (Map.Entry<byte[], MetaInfSignatureInfo> metaInfEntry : this.metaInfSignatures.entrySet()) {
                    ++i;
                    MetaInfSignatureInfo info = metaInfEntry.getValue();
                    ASiCXMLUtils.completeDataObjRef(xsw, info.getDataFilename(), info.getDigestMethod(), Base64.toBase64String((byte[])info.getDigestValue()));
                }
                ASiCXMLUtils.endManifest(xsw);
                xsw.flush();
                xsw.close();
                ClonerInputStream inputStream = new ClonerInputStream((InputStream)new BufferedInputStream(cos.getCache()), (OutputStream)this.zos);
                SignatureOptions entryOpts = (SignatureOptions)this.options.getSignEntriesOptions().get(0);
                switch (this.options.getAsicOpts().getSignatureType()) {
                    case CADES: {
                        InputHandler doc = DataHandlerBuilder.get().setInputStream((InputStream)inputStream).buildInput();
                        CadesSignatureGenerator cades_gen = new CadesSignatureGenerator();
                        CadesSignatureOptions cades_options = new CadesSignatureOptions();
                        cades_options.setKeyStore(entryOpts.getKeyStore());
                        cades_options.setKeyStorePassword(entryOpts.getKeyStorePassword());
                        cades_options.setAlias(entryOpts.getAlias());
                        cades_options.setSignatureMode(SignatureMode.DETACHED);
                        cades_options.setSignatureLevel(entryOpts.getSignatureLevel());
                        if (entryOpts.getSignatureLevel() != SignatureLevel.BES) {
                            cades_options.setTimeStampOptions(entryOpts.getTimeStampOptions());
                            cades_options.setCertdb(entryOpts.getCertdb());
                        }
                        cades_options.setInput(doc);
                        cades_options.setOutput(DataHandlerBuilder.get().setOutputStream((OutputStream)metaInfOutputStream).buildOutput());
                        cades_options.setDerEncoded(true);
                        cades_options.setDigestAlgorithm(entryOpts.getDigestAlgorithm());
                        cades_gen.sign((SignatureOptions)cades_options);
                        break;
                    }
                    case TIMESTAMP: {
                        byte[] ts = entryOpts.getTimeStampOptions().getTSAClient().stamp((InputStream)inputStream, entryOpts.getTimeStampOptions());
                        TimeStampToken tsk = new TimeStampToken(ts);
                        metaInfOutputStream.write(tsk.toByteArray(false, true));
                    }
                }
                ze = new ZipEntry(signatureFilename);
                this.zos.putNextEntry(ze);
                metaInfOutputStream.flush();
                ByteArrayInputStream metaInfInputStream = new ByteArrayInputStream(metaInfOutputStream.toByteArray());
                try {
                    int data;
                    while ((data = ((InputStream)metaInfInputStream).read()) >= 0) {
                        this.zos.write((byte)data);
                    }
                }
                catch (IOException ex) {
                    throw ex;
                }
                finally {
                    try {
                        ((InputStream)metaInfInputStream).close();
                    }
                    catch (IOException ex) {
                        logger.error("Unable to close META-INF input stream.", (Throwable)ex);
                    }
                }
                inputStream.close();
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("IOException occurred.", 1003, (Throwable)ex);
            }
            catch (XMLStreamException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("XMLStreamException occurred: ", 1003, (Throwable)ex);
            }
            catch (KeyStoreException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("KeyStoreException occurred: ", 1003, (Throwable)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("NoSuchAlgorithmException occurred: ", 1003, (Throwable)ex);
            }
            catch (UnrecoverableKeyException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("UnrecoverableKeyException occurred: ", 1003, (Throwable)ex);
            }
            catch (KeyManagementException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("KeyManagementException occurred: ", 1003, (Throwable)ex);
            }
            catch (URISyntaxException ex) {
                java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, ex);
                throw new CapiException("URISyntaxException occurred: ", 1003, (Throwable)ex);
            }
            finally {
                try {
                    this.zos.close();
                }
                catch (IOException ex) {
                    logger.error("Unable to close ZIP output stream.", (Throwable)ex);
                }
            }
        }
    }

    private class IterInputFileInfo {
        private final java.io.File outFile;
        private final InputStream inStream;

        private IterInputFileInfo(java.io.File f, InputStream st) {
            this.outFile = f;
            this.inStream = st;
        }
    }
}

