static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright (C) 2017 Ell                                                     \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_spiral_type)                                                 \n"
"  enum_value (GEGL_SPIRAL_TYPE_LINEAR,      \"linear\",      N_(\"Linear\"))  \n"
"  enum_value (GEGL_SPIRAL_TYPE_LOGARITHMIC, \"logarithmic\", N_(\"Logarithmic\"))\n"
"enum_end (GeglSpiralType)                                                     \n"
"                                                                              \n"
"property_enum (type, _(\"Type\"),                                             \n"
"               GeglSpiralType, gegl_spiral_type,                              \n"
"               GEGL_SPIRAL_TYPE_LINEAR)                                       \n"
"  description (_(\"Spiral type\"))                                            \n"
"                                                                              \n"
"property_double (x, _(\"X\"), 0.5)                                            \n"
"  description (_(\"Spiral origin X coordinate\"))                             \n"
"  ui_range    (0.0, 1.0)                                                      \n"
"  ui_meta     (\"unit\", \"relative-coordinate\")                             \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_double (y, _(\"Y\"), 0.5)                                            \n"
"  description (_(\"Spiral origin Y coordinate\"))                             \n"
"  ui_range    (0.0, 1.0)                                                      \n"
"  ui_meta     (\"unit\", \"relative-coordinate\")                             \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_double (radius, _(\"Radius\"), 100.0)                                \n"
"  description (_(\"Spiral radius\"))                                          \n"
"  value_range (1.0, G_MAXDOUBLE)                                              \n"
"  ui_range    (1.0, 400.0)                                                    \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"                                                                              \n"
"property_double (base, _(\"Base\"), 2.0)                                      \n"
"  description (_(\"Logarithmic spiral base\"))                                \n"
"  value_range (1.0, G_MAXDOUBLE)                                              \n"
"  ui_range    (1.0, 20.0)                                                     \n"
"  ui_gamma    (2.0)                                                           \n"
"  ui_meta     (\"visible\", \"type {logarithmic}\")                           \n"
"                                                                              \n"
"property_double (balance, _(\"Balance\"), 0.0)                                \n"
"  description (_(\"Area balance between the two colors\"))                    \n"
"  value_range (-1.0, 1.0)                                                     \n"
"                                                                              \n"
"property_double (rotation, _(\"Rotation\"), 0.0)                              \n"
"  description (_(\"Spiral rotation\"))                                        \n"
"  value_range (0.0, 360.0)                                                    \n"
"  ui_meta     (\"unit\", \"degree\")                                          \n"
"                                                                              \n"
"enum_start (gegl_spiral_direction)                                            \n"
"  enum_value (GEGL_SPIRAL_DIRECTION_CLOCKWISE,        \"cw\",  N_(\"Clockwise\"))\n"
"  enum_value (GEGL_SPIRAL_DIRECTION_COUNTERCLOCKWISE, \"ccw\", N_(\"Counter-clockwise\"))\n"
"enum_end (GeglSpiralDirection)                                                \n"
"                                                                              \n"
"property_enum (direction, _(\"Direction\"),                                   \n"
"               GeglSpiralDirection, gegl_spiral_direction,                    \n"
"               GEGL_SPIRAL_DIRECTION_CLOCKWISE)                               \n"
"  description (_(\"Spiral swirl direction\"))                                 \n"
"                                                                              \n"
"property_color  (color1, _(\"Color 1\"), \"black\")                           \n"
"  ui_meta     (\"role\", \"color-primary\")                                   \n"
"                                                                              \n"
"property_color  (color2, _(\"Color 2\"), \"white\")                           \n"
"  ui_meta     (\"role\", \"color-secondary\")                                 \n"
"                                                                              \n"
"property_int    (width, _(\"Width\"), 1024)                                   \n"
"  description (_(\"Width of the generated buffer\"))                          \n"
"  value_range (0, G_MAXINT)                                                   \n"
"  ui_range    (0, 4096)                                                       \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"  ui_meta     (\"role\", \"output-extent\")                                   \n"
"                                                                              \n"
"property_int    (height, _(\"Height\"), 768)                                  \n"
"  description (_(\"Height of the generated buffer\"))                         \n"
"  value_range (0, G_MAXINT)                                                   \n"
"  ui_range    (0, 4096)                                                       \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"  ui_meta     (\"role\", \"output-extent\")                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     spiral                                               \n"
"#define GEGL_OP_C_SOURCE spiral.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define RAD_TO_REV ((gfloat) (1.0 / (2.0 * G_PI)))                            \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"blend (const gfloat *color1,                                                  \n"
"       const gfloat *color2,                                                  \n"
"       gfloat        a,                                                       \n"
"       gfloat       *result)                                                  \n"
"{                                                                             \n"
"  if (a == 0.0f)                                                              \n"
"    {                                                                         \n"
"      memcpy (result, color1, 4 * sizeof (gfloat));                           \n"
"    }                                                                         \n"
"  else if (a == 1.0f)                                                         \n"
"    {                                                                         \n"
"      memcpy (result, color2, 4 * sizeof (gfloat));                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gfloat alpha = color1[3] + a * (color2[3] - color1[3]);                 \n"
"      gint   c;                                                               \n"
"                                                                              \n"
"      if (alpha)                                                              \n"
"        {                                                                     \n"
"          gfloat ratio = a * color2[3] / alpha;                               \n"
"                                                                              \n"
"          for (c = 0; c < 3; c++)                                             \n"
"            result[c] = color1[c] + ratio * (color2[c] - color1[c]);          \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          memcpy (result, color1, 3 * sizeof (gfloat));                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      result[3] = alpha;                                                      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_linear (gfloat       *out,                                            \n"
"                gint          width,                                          \n"
"                gint          height,                                         \n"
"                gfloat        x0,                                             \n"
"                gfloat        y0,                                             \n"
"                gfloat        radius,                                         \n"
"                gfloat        thickness,                                      \n"
"                gfloat        angle,                                          \n"
"                gboolean      clockwise,                                      \n"
"                const gfloat *color1,                                         \n"
"                const gfloat *color2)                                         \n"
"{                                                                             \n"
"  gfloat lim;                                                                 \n"
"  gfloat x;                                                                   \n"
"  gfloat y;                                                                   \n"
"  gint   i;                                                                   \n"
"  gint   j;                                                                   \n"
"                                                                              \n"
"  if (thickness > 0.5)                                                        \n"
"    {                                                                         \n"
"      const gfloat *temp;                                                     \n"
"                                                                              \n"
"      thickness = 1.0 - thickness;                                            \n"
"      angle     = fmod (angle + thickness, 1.0);                              \n"
"                                                                              \n"
"      temp   = color1;                                                        \n"
"      color1 = color2;                                                        \n"
"      color2 = temp;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (thickness == 0.0 || radius == 1.0)                                      \n"
"    {                                                                         \n"
"      gfloat color[4];                                                        \n"
"                                                                              \n"
"      blend (color2, color1, thickness, color);                               \n"
"                                                                              \n"
"      gegl_memset_pattern (out, color, sizeof (color), width * height);       \n"
"                                                                              \n"
"      return;                                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  lim = thickness * radius;                                                   \n"
"                                                                              \n"
"  y = y0;                                                                     \n"
"                                                                              \n"
"  for (j = height; j; j--, y++)                                               \n"
"    {                                                                         \n"
"      x = x0;                                                                 \n"
"                                                                              \n"
"      for (i = width; i; i--, x++)                                            \n"
"        {                                                                     \n"
"          gfloat r;                                                           \n"
"          gfloat t;                                                           \n"
"          gfloat s;                                                           \n"
"          gfloat a;                                                           \n"
"                                                                              \n"
"          r = sqrtf (x * x + y * y);                                          \n"
"          t = RAD_TO_REV * atan2f (clockwise ? y : -y, x) - angle;            \n"
"                                                                              \n"
"          t += t < 0.0f;                                                      \n"
"                                                                              \n"
"          s = t * radius;                                                     \n"
"                                                                              \n"
"          if (r >= s)                                                         \n"
"            {                                                                 \n"
"              r = fmodf (r - s, radius);                                      \n"
"                                                                              \n"
"              if (r < 0.5f)                                                   \n"
"                {                                                             \n"
"                  a = MIN (lim, r + 0.5f);                                    \n"
"                }                                                             \n"
"              else if (r > radius - 0.5f)                                     \n"
"                {                                                             \n"
"                  a = MAX (lim - (r - 0.5f), 0.0f) +                          \n"
"                      MIN (lim, (r + 0.5f) - radius);                         \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  a = CLAMP (lim - (r - 0.5f), 0.0f, 1.0f);                   \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              gfloat l = lim - (radius - s);                                  \n"
"                                                                              \n"
"              a = CLAMP ((r + 0.5f) - s, 0.0f, lim);                          \n"
"                                                                              \n"
"              if (t <= 0.5f)                                                  \n"
"                {                                                             \n"
"                  if (r < 0.5f)                                               \n"
"                    {                                                         \n"
"                      a += CLAMP (l + radius / 2.0f, 0.0f, 0.5f - r);         \n"
"                    }                                                         \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  if (r < 0.5f)                                               \n"
"                    {                                                         \n"
"                      a += CLAMP (l, 0.0f, r + 0.5f) +                        \n"
"                           CLAMP ((0.5f - r) - (s - radius / 2.0f), 0.0f, lim);\n"
"                    }                                                         \n"
"                  else                                                        \n"
"                    {                                                         \n"
"                      a += CLAMP (l - (r - 0.5f), 0.0f, 1.0f);                \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          blend (color2, color1, a, out);                                     \n"
"                                                                              \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_logarithmic (gfloat       *out,                                       \n"
"                     gint          width,                                     \n"
"                     gint          height,                                    \n"
"                     gfloat        x0,                                        \n"
"                     gfloat        y0,                                        \n"
"                     gfloat        radius,                                    \n"
"                     gfloat        base,                                      \n"
"                     gfloat        thickness,                                 \n"
"                     gfloat        angle,                                     \n"
"                     gboolean      clockwise,                                 \n"
"                     const gfloat *color1,                                    \n"
"                     const gfloat *color2)                                    \n"
"{                                                                             \n"
"  gfloat log_radius;                                                          \n"
"  gfloat base_inv;                                                            \n"
"  gfloat log_base;                                                            \n"
"  gfloat log_base_inv;                                                        \n"
"  gfloat lim;                                                                 \n"
"  gfloat x;                                                                   \n"
"  gfloat y;                                                                   \n"
"  gint   i;                                                                   \n"
"  gint   j;                                                                   \n"
"                                                                              \n"
"  if (thickness == 0.0 || thickness == 1.0 || base == 1.0)                    \n"
"    {                                                                         \n"
"      gfloat color[4];                                                        \n"
"                                                                              \n"
"      blend (color2, color1, thickness, color);                               \n"
"                                                                              \n"
"      gegl_memset_pattern (out, color, sizeof (color), width * height);       \n"
"                                                                              \n"
"      return;                                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  log_radius   = log (radius);                                                \n"
"  base_inv     = 1.0 / base;                                                  \n"
"  log_base     = log (base);                                                  \n"
"  log_base_inv = 1.0 / log_base;                                              \n"
"  lim          = exp (log_base * thickness);                                  \n"
"                                                                              \n"
"  y = y0;                                                                     \n"
"                                                                              \n"
"  for (j = height; j; j--, y++)                                               \n"
"    {                                                                         \n"
"      x = x0;                                                                 \n"
"                                                                              \n"
"      for (i = width; i; i--, x++)                                            \n"
"        {                                                                     \n"
"          gfloat r;                                                           \n"
"          gfloat t;                                                           \n"
"          gfloat a;                                                           \n"
"          gfloat s;                                                           \n"
"          gfloat l;                                                           \n"
"          gfloat S;                                                           \n"
"                                                                              \n"
"          r = sqrtf (x * x + y * y);                                          \n"
"          t = RAD_TO_REV * atan2f (clockwise ? y : -y, x) - angle;            \n"
"                                                                              \n"
"          t += t < 0.0f;                                                      \n"
"                                                                              \n"
"          s = log_base_inv * (logf (r) - log_radius);                         \n"
"          s = expf (log_base * (floorf (s - t) + t) + log_radius);            \n"
"                                                                              \n"
"          l = s * lim;                                                        \n"
"          S = s * base;                                                       \n"
"                                                                              \n"
"          if (r >= s + 0.5f)                                                  \n"
"            {                                                                 \n"
"              a = CLAMP (l - (r - 0.5f), 0.0f, 1.0f);                         \n"
"                                                                              \n"
"              if (r > S - 0.5f)                                               \n"
"                a += MIN (l * base - S, r + 0.5f - S);                        \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              if (s - s * base_inv >= 0.5f)                                   \n"
"                {                                                             \n"
"                  a  = MIN (l - s, r + 0.5f - s);                             \n"
"                  a += MAX (l * base_inv - (r - 0.5f), 0.0f);                 \n"
"                                                                              \n"
"                  if (r > S - 0.5f)                                           \n"
"                    a += MIN (l * base - S, r + 0.5f - S);                    \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  a = thickness;                                              \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          blend (color2, color1, a, out);                                     \n"
"                                                                              \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out,                                            \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o         = GEGL_PROPERTIES (operation);                    \n"
"  const Babl     *format    = babl_format (\"R'G'B'A float\");                \n"
"  gfloat          scale     = 1.0 / (1 << level);                             \n"
"  gfloat          x0;                                                         \n"
"  gfloat          y0;                                                         \n"
"  gfloat          radius    = scale * o->radius;                              \n"
"  gfloat          thickness = (1.0 + o->balance) / 2.0;                       \n"
"  gfloat          angle     = o->rotation / 360.0;                            \n"
"  gboolean        clockwise = o->direction == GEGL_SPIRAL_DIRECTION_CLOCKWISE;\n"
"  gfloat          color1[4];                                                  \n"
"  gfloat          color2[4];                                                  \n"
"                                                                              \n"
"  x0 = roi->x -                                                               \n"
"       scale * gegl_coordinate_relative_to_pixel (o->x, o->width)  + 0.5;     \n"
"  y0 = roi->y -                                                               \n"
"       scale * gegl_coordinate_relative_to_pixel (o->y, o->height) + 0.5;     \n"
"                                                                              \n"
"  if (clockwise)                                                              \n"
"    angle = 1.0 - angle;                                                      \n"
"                                                                              \n"
"  angle = fmod (angle + thickness / 2.0, 1.0);                                \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color1, format, color1);                           \n"
"  gegl_color_get_pixel (o->color2, format, color2);                           \n"
"                                                                              \n"
"  switch (o->type)                                                            \n"
"    {                                                                         \n"
"    case GEGL_SPIRAL_TYPE_LINEAR:                                             \n"
"      process_linear (out, roi->width, roi->height,                           \n"
"                      x0, y0, radius, thickness, angle, clockwise,            \n"
"                      color1, color2);                                        \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_SPIRAL_TYPE_LOGARITHMIC:                                        \n"
"      process_logarithmic (out, roi->width, roi->height,                      \n"
"                           x0, y0, radius, o->base, thickness, angle, clockwise,\n"
"                           color1, color2);                                   \n"
"      break;                                                                  \n"
"                                                                              \n"
"    default:                                                                  \n"
"      g_return_val_if_reached (FALSE);                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"                                                                              \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:spiral\",                                  \n"
"    \"title\",              _(\"Spiral\"),                                    \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\",        _(\"Spiral renderer\"),                           \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
