static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (string, _(\"pipeline\"), \"gaussian-blur std-dev-x=0.3rel std-dev-y=0.3rel\")\n"
"    description(_(\"[op [property=value] [property=value]] [[op] [property=value]\"))\n"
"    ui_meta (\"multiline\", \"true\")                                         \n"
"                                                                              \n"
"property_string (error, _(\"Eeeeeek\"), \"\")                                 \n"
"    description (_(\"There is a problem in the syntax or in the application of parsed property values. Things might mostly work nevertheless.\"))\n"
"    ui_meta (\"error\", \"true\")                                             \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     gegl                                                 \n"
"#define GEGL_OP_C_SOURCE gegl.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <unistd.h>                                                           \n"
"                                                                              \n"
"/* XXX: leaking o->user_data */                                               \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode *gegl, *input, *output;                                            \n"
"                                                                              \n"
"  gegl = operation->node;                                                     \n"
"                                                                              \n"
"  input    = gegl_node_get_input_proxy (gegl, \"input\");                     \n"
"  output   = gegl_node_get_output_proxy (gegl, \"output\");                   \n"
"                                                                              \n"
"  gegl_node_link_many (input, output, NULL);                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglNode *gegl, *input, *output;                                            \n"
"  GError *error = NULL;                                                       \n"
"                                                                              \n"
"  gegl = operation->node;                                                     \n"
"                                                                              \n"
"  if (!o->user_data || !g_str_equal (o->user_data, o->string))                \n"
"  {                                                                           \n"
"    if (o->user_data)                                                         \n"
"      g_free (o->user_data);                                                  \n"
"    o->user_data = g_strdup (o->string);                                      \n"
"                                                                              \n"
"  input  = gegl_node_get_input_proxy (gegl,  \"input\");                      \n"
"  output = gegl_node_get_output_proxy (gegl, \"output\");                     \n"
"                                                                              \n"
"  gegl_node_link_many (input, output, NULL);                                  \n"
"  {                                                                           \n"
"     gchar cwd[81920]; // XXX: should do better                               \n"
"     getcwd (cwd, sizeof(cwd));                                               \n"
"  gegl_create_chain (o->string, input, output, 0.0,                           \n"
"                     gegl_node_get_bounding_box (input).height, cwd,          \n"
"                     &error);                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (error)                                                                  \n"
"  {                                                                           \n"
"    gegl_node_set (gegl, \"error\", error->message, NULL);                    \n"
"    g_error_free (error);                                                     \n"
"    error = NULL;                                                             \n"
"  }                                                                           \n"
"  else                                                                        \n"
"    g_object_set (operation, \"error\", \"\", NULL);                          \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:gegl\",                                           \n"
"    \"title\",       _(\"GEGL graph\"),                                       \n"
"    \"categories\",  \"generic\",                                             \n"
"    \"reference-hash\", \"feea1919710ead4759e30767c20c86f1\",                 \n"
"    \"description\", _(\"Do a chain of operations, with key=value pairs after each operation name to set properties. And aux=[ source filter ] for specifying a chain with a source as something connected to an aux pad.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
