Summary: EFI Boot Manager
Name: efibootmgr
Version: 14
Release: 1%{?dist}
Group: System Environment/Base
License: GPLv2+
URL: http://github.com/rhinstaller/%{name}/
BuildRequires: git, popt-devel
BuildRequires: efivar-libs >= 30-1, efivar-devel >= 30-1
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXXXX)
# EFI/UEFI don't exist on PPC
ExclusiveArch: %{ix86} x86_64 aarch64 arm

# for RHEL / Fedora when efibootmgr was part of the elilo package
Conflicts: elilo <= 3.6-6
Obsoletes: elilo <= 3.6-6

Source0: https://github.com/rhinstaller/%{name}/releases/download/%{name}-%{version}/%{name}-%{version}.tar.bz2

%description
%{name} displays and allows the user to edit the Intel Extensible
Firmware Interface (EFI) Boot Manager variables.  Additional
information about EFI can be found at
http://developer.intel.com/technology/efi/efi.htm and http://uefi.org/.

%prep
%setup -q
git init
git config user.email "example@example.com"
git config user.name "RHEL Ninjas"
git add .
git commit -a -q -m "%{version} baseline."
git am %{patches} </dev/null
git config --unset user.email
git config --unset user.name

%build
make %{?_smp_mflags} EXTRA_CFLAGS='%{optflags}'

%install
rm -rf %{buildroot}
%makeinstall

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{!?_licensedir:%global license %%doc}
%license COPYING
%{_sbindir}/*
%{_mandir}/*/*.?.gz
%doc README
    
%changelog
* Tue Sep 27 2016 Peter Jones <pjones@redhat.com> - 14-1
- Update to efibootmgr 14
- Remove "(hex)" from description of --delete-bootnum
- Fix a typo in the popt options
- Add README.md
- make efibootdump install by default
- Man page fixes
- Better compiler detection
- Don't use --default-symver in efibootmgr
- Make -flto part of the overrideable CFLAGS

* Wed Aug 17 2016 Peter Jones <pjones@redhat.com> - 13-1
- Update to efibootmgr 13
- Add support for --sysprep and --driver to support UEFI System Prep
  Applications and UEFI Drivers.
- use efivar's error reporting facility, and show error traces when
  "-v -v" is used.
- Still yet better error codes returned on failures.
- Add -m and -M to support Memory Address Range Mirroring.
- Add efibootdump, to examine Boot* variables found in tarballs in bug
  reports and similar.
- miscellaneous bugfixes.

* Thu May 28 2015 Peter Jones <pjones@redhat.com> - 0.12-1
- Update to 0.12
- use libefiboot and libefivar to make device paths and load options
- don't depend on -lz or -lpci any more

* Tue Oct 21 2014 Peter Jones <pjones@redhat.com> - 0.11.0-1
- Fix "-n" and friends not being assigned/checked right sometimes from 0.10.0-1
- Generate more archives to avoid people using github's, because they're just
  bad.

* Mon Oct 20 2014 Peter Jones <pjones@redhat.com> - 0.10.0-1
- Make -o parameter validation work better and be more informative
- Better exit values
- Fix a segfault with appending ascii arguments.

* Tue Sep 09 2014 Peter Jones <pjones@redhat.com> - 0.8.0-1
- Release 0.8.0

* Mon Jan 13 2014 Peter Jones <pjones@redhat.com> - 0.6.1-1
- Release 0.6.1

* Mon Jan 13 2014 Jared Dominguez <Jared_Dominguez@dell.com>
- new home https://github.com/vathpela/efibootmgr

* Thu Jan  3 2008 Matt Domsch <Matt_Domsch@dell.com> 0.5.4-1
- split efibootmgr into its own RPM for Fedora/RHEL.

* Tue Aug 24 2004 Matt Domsch <Matt_Domsch@dell.com>
- new home linux.dell.com

* Fri May 18 2001 Matt Domsch <Matt_Domsch@dell.com>
- See doc/ChangeLog
