/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DiagTypesDoc/CDiagCollectInstancesDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/DiagTypesXml/DiagCollectInstancesXml.h"

using namespace Caf;

void DiagCollectInstancesXml::add(
	const SmartPtrCDiagCollectInstancesDoc diagCollectInstancesDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DiagCollectInstancesXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(diagCollectInstancesDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string jobIdVal =
			BasePlatform::UuidToString(diagCollectInstancesDoc->getJobId());
		CAF_CM_VALIDATE_STRING(jobIdVal);
		thisXml->addAttribute("jobId", jobIdVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCDiagCollectInstancesDoc DiagCollectInstancesXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DiagCollectInstancesXml", "parse");

	SmartPtrCDiagCollectInstancesDoc diagCollectInstancesDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string jobIdStrVal =
			thisXml->findRequiredAttribute("jobId");
		UUID jobIdVal = CAFCOMMON_GUID_NULL;
		if (! jobIdStrVal.empty()) {
			BasePlatform::UuidFromString(jobIdStrVal.c_str(), jobIdVal);
		}

		diagCollectInstancesDoc.CreateInstance();
		diagCollectInstancesDoc->initialize(
			jobIdVal);
	}
	CAF_CM_EXIT;

	return diagCollectInstancesDoc;
}

