//------------------------------------------------------------------------------
// <copyright file="AutoGeneratedField.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>                                                                
//------------------------------------------------------------------------------

namespace System.Web.UI.WebControls {

    using System;
    using System.Collections;    
    using System.Collections.Specialized;    
    using System.ComponentModel;

    /// <devdoc>
    /// <para>Creates a field bounded to a data field in a <see cref='System.Web.UI.WebControls.DataBoundControl'/>.</para>
    /// </devdoc>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public sealed class AutoGeneratedField : BoundField {
        
        private bool _suppressPropertyThrows = false;
        private bool _useCheckBox;
        private bool _useCheckBoxValid;
        

        /// <devdoc>
        /// <para>Initializes a new instance of a <see cref='System.Web.UI.WebControls.BoundField'/> class.</para>
        /// </devdoc>
        public AutoGeneratedField(string dataField) {
            DataField = dataField;
        }


        /// <devdoc>
        /// <para>Gets or sets the display format of data in this
        /// field.</para>
        /// </devdoc>
        public override string DataFormatString {
            get {
                return base.DataFormatString;
            }
            set {
                if (!_suppressPropertyThrows) {
                    throw new NotSupportedException();
                }
            }
        }


        /// <devdoc>
        /// <para>Gets or sets the type of data being displayed by the field.</para>
        /// </devdoc>
        public Type DataType {
            get {
                object o = ViewState["DataType"];
                if (o != null) {
                    return (Type)o;
                }
                return typeof(string);
            }
            set {
                ViewState["DataType"] = value;
            }
        }


        /// <devdoc>
        /// <para>Gets or sets whether the field is visible in Insert mode.  Turn off for auto-gen'd db fields</para>
        /// </devdoc>
        public override bool InsertVisible {
            get {
                return base.InsertVisible;
            }
            set {
                if (!_suppressPropertyThrows) {
                    throw new NotSupportedException();
                }
            }
        }
    
        

        /// <devdoc>
        /// <para>Gets or sets the property that determines whether the BoundField treats empty string as
        /// null when the field values are extracted.</para>
        /// </devdoc>
        public override bool ConvertEmptyStringToNull {
            get {
                return base.ConvertEmptyStringToNull;
            }
            set {
                if (!_suppressPropertyThrows) {
                    throw new NotSupportedException();
                }
            }
        }

        /// <devdoc>
        ///    <para>Determines whether the field should display a text box.</para>
        /// </devdoc>
        private bool UseCheckBox {
            get {
                if (!_useCheckBoxValid) {
                    _useCheckBox = (DataType == typeof(bool) || DataType == typeof(bool?));
                    _useCheckBoxValid = true;
                }
                return _useCheckBox;
            }
        }

        protected override void CopyProperties(DataControlField newField) {
            ((AutoGeneratedField)newField).DataType = DataType;
            _suppressPropertyThrows = true;
            ((AutoGeneratedField)newField)._suppressPropertyThrows = true;
            base.CopyProperties(newField);
            _suppressPropertyThrows = false;
            ((AutoGeneratedField)newField)._suppressPropertyThrows = false;
        }

        protected override DataControlField CreateField() {
            return new AutoGeneratedField(DataField);
        }


        /// <devdoc>
        /// Returns a value to be used for design-time rendering
        /// </devdoc>
        protected override object GetDesignTimeValue() {
            if (UseCheckBox) {
                return true;
            }
            return base.GetDesignTimeValue();
        }
        

        /// <devdoc>
        /// Extracts the value of the databound cell and inserts the value into the given dictionary
        /// </devdoc>
        public override void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly) {
            if (UseCheckBox) {
                Control childControl = null;
                string dataField = DataField;
                object value = null;
    
                if (cell.Controls.Count > 0) {
                    childControl = cell.Controls[0];
    
                    CheckBox checkBox = childControl as CheckBox;
                    if (checkBox != null) {
                        if (includeReadOnly || checkBox.Enabled) {
                            value = checkBox.Checked;
                        }
                    }
                }
    
                if (value != null) {
                    if (dictionary.Contains(dataField)) {
                        dictionary[dataField] = value;
                    }
                    else {
                        dictionary.Add(dataField, value);
                    }
                }
            }
            else {
                base.ExtractValuesFromCell(dictionary, cell, rowState, includeReadOnly);
            }
            

        }


        protected override void InitializeDataCell(DataControlFieldCell cell, DataControlRowState rowState) {
            if (UseCheckBox) {
                CheckBox childControl = null;
                CheckBox boundControl = null;
                
                if (((rowState & DataControlRowState.Edit) != 0 && ReadOnly == false) || (rowState & DataControlRowState.Insert) != 0) {
                    CheckBox editor = new CheckBox();
                    childControl = editor;
    
                    if (DataField.Length != 0 && (rowState & DataControlRowState.Edit) != 0) {
                        boundControl = editor;
                    }
                }
                else if (DataField.Length != 0) {
                    CheckBox editor = new CheckBox();
                    editor.Enabled = false;
                    childControl = editor;
                    boundControl = editor;
                }
                
                if (childControl != null) {
                    childControl.ToolTip = HeaderText;
                    cell.Controls.Add(childControl);
                }
                
                if (boundControl != null) {
                    boundControl.DataBinding += new EventHandler(this.OnDataBindField);
                }
            }
            else {
                base.InitializeDataCell(cell, rowState);
            }
        }


        /// <devdoc>
        /// </devdoc>
        protected override void OnDataBindField(object sender, EventArgs e) {
            if (UseCheckBox) {
                Control boundControl = (Control)sender;
                Control controlContainer = boundControl.NamingContainer;
    
    
                object data = GetValue(controlContainer);
     
                if (!(boundControl is CheckBox)) {
                    throw new HttpException(SR.GetString(SR.CheckBoxField_WrongControlType, DataField));
                }
                if (DataBinder.IsNull(data)) {
                    ((CheckBox)boundControl).Checked = false;
                }
                else {
                    if (data is Boolean) {
                        ((CheckBox)boundControl).Checked = (Boolean)data;
                    }
                    else {
                        try {
                            ((CheckBox)boundControl).Checked = Boolean.Parse(data.ToString());
                        }
                        catch (FormatException fe) {
                            throw new HttpException(SR.GetString(SR.CheckBoxField_CouldntParseAsBoolean, DataField), fe);
                        }
                    }                
                }
            }
            else {
                base.OnDataBindField(sender, e);
            }
        }

        /// <devdoc>
        /// <para>Override with an empty body if the field's controls all support callback.
        ///  Otherwise, override and throw a useful error message about why the field can't support callbacks.</para>
        /// </devdoc>
        public override void ValidateSupportsCallback() {
        }
    }
}

