/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfontselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpfontselect
 * @title: gimpfontselect
 * @short_description: Functions providing a font selection dialog.
 *
 * Functions providing a font selection dialog.
 **/


/**
 * gimp_fonts_popup:
 * @font_callback: The callback PDB proc to call when font selection is made.
 * @popup_title: Title of the font selection dialog.
 * @initial_font: The name of the font to set as the first selected.
 *
 * Invokes the Gimp font selection.
 *
 * This procedure opens the font selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_popup (const gchar *font_callback,
                  const gchar *popup_title,
                  const gchar *initial_font)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, font_callback,
                                          G_TYPE_STRING, popup_title,
                                          G_TYPE_STRING, initial_font,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-fonts-popup",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_fonts_close_popup:
 * @font_callback: The name of the callback registered for this pop-up.
 *
 * Close the font selection dialog.
 *
 * This procedure closes an opened font selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_close_popup (const gchar *font_callback)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, font_callback,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-fonts-close-popup",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_fonts_set_popup:
 * @font_callback: The name of the callback registered for this pop-up.
 * @font_name: The name of the font to set as selected.
 *
 * Sets the current font in a font selection dialog.
 *
 * Sets the current font in a font selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_set_popup (const gchar *font_callback,
                      const gchar *font_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, font_callback,
                                          G_TYPE_STRING, font_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-fonts-set-popup",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
