.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetPointerMapping __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetPointerMapping, XGetPointerMapping \- manipulate pointer settings
.SH SYNTAX
.HP
int XSetPointerMapping\^(\^Display *\fIdisplay\fP\^, unsigned char
\fImap\fP\^[]\^, int \fInmap\fP\^);
.HP
int XGetPointerMapping\^(\^Display *\fIdisplay\fP\^, unsigned char
\fImap_return\fP\^[]\^, int \fInmap\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fImap\fP 1i
Specifies the mapping list.
.IP \fImap_return\fP 1i
Returns the mapping list.
.IP \fInmap\fP 1i
Specifies the number of items in the mapping list.
.SH DESCRIPTION
The
.B XSetPointerMapping
function sets the mapping of the pointer.
If it succeeds, the X server generates a
.B MappingNotify
event, and
.B XSetPointerMapping
returns
.BR MappingSuccess .
Element map[i] defines the logical button number for the physical button
i+1.
The length of the list must be the same as
.B XGetPointerMapping
would return,
or a
.B BadValue
error results.
A zero element disables a button, and elements are not restricted in
value by the number of physical buttons.
However, no two elements can have the same nonzero value,
or a
.B BadValue
error results.
If any of the buttons to be altered are logically in the down state,
.B XSetPointerMapping
returns
.BR MappingBusy ,
and the mapping is not changed.
.LP
.B XSetPointerMapping
can generate a
.B BadValue
error.
.LP
The
.B XGetPointerMapping
function returns the current mapping of the pointer.
Pointer buttons are numbered starting from one.
.B XGetPointerMapping
returns the number of physical buttons actually on the pointer.
The nominal mapping for a pointer is map[i]=i+1.
The nmap argument specifies the length of the array where the pointer
mapping is returned, and only the first nmap elements are returned
in map_return.
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XChangeKeyboardControl(__libmansuffix__),
XChangeKeyboardMapping(__libmansuffix__)
.br
\fI\*(xL\fP
