.TH lspci 8 "@TODAY@" "@VERSION@" "Linux PCI Utilities"
.IX lspci
.SH NAME
lspci \- list all PCI devices
.SH SYNOPSIS
.B lspci
.RB [ options ]
.SH DESCRIPTION
.B lspci
is a utility for displaying information about all PCI buses in the system and
all devices connected to them.

To make use of all the features of this program, you need to have Linux kernel
2.1.82 or newer which supports the /proc/bus/pci interface. With older kernels,
the PCI utilities have to use direct hardware access which is available
only to root and it suffers from numerous race conditions and other problems.

If you are going to report bugs in PCI device drivers or in
.I lspci
itself, please include output of "lspci -vvx".

.SH OPTIONS
.TP
.B -v
Tells
.I lspci
to be verbose and display detailed information about all devices.
.TP
.B -vv
Tells
.I lspci
to be very verbose and display even more information (actually everything the
PCI device is able to tell). The exact meaning of these data is not explained
in this manual page, if you want to know more, consult
.B /usr/include/linux/pci.h
or the PCI specs.
.TP
.B -n
Show PCI vendor and device codes as numbers instead of looking them up in the
PCI ID database.
.TP
.B -x
Show hexadecimal dump of first 64 bytes of the PCI configuration space (the standard
header). Useful for debugging of drivers and
.I lspci
itself.
.TP
.B -xxx
Show hexadecimal dump of whole PCI configuration space. Available only for root
as several PCI devices
.B crash
when you try to read undefined portions of the config space (this behaviour probably
doesn't violate the PCI standard, but it's at least very stupid).
.TP
.B -b
Bus-centric view. Show all IRQ numbers and addresses as seen by the cards on the
PCI bus instead of as seen by the kernel.
.TP
.B -t
Show a tree-like diagram containing all buses, bridges, devices and connections
between them.
.TP
.B -s [[<bus>]:][<slot>][.[<func>]]
Show only devices in specified bus, slot and function. Each component of the device
address can be omitted or set as "*" meaning "any value". All numbers are
hexadecimal.  E.g., "0:" means all devices on bus 0, "0" means all functions of device 0
on any bus, "0.3" selects third function of device 0 on all buses and ".4" shows only
fourth function of each device.
.TP
.B -d [<vendor>]:[<device>]
Show only devices with specified vendor and device ID. Both ID's are given in
hexadecimal and may be omitted or given as "*" meaning "any value".
.TP
.B -i <file>
Use
.B
<file>
as PCI ID database instead of /usr/share/pci.ids.
.TP
.B -p <dir>
Use
.B <dir>
as directory containing PCI bus information instead of /proc/bus/pci.
.TP
.B -m
Dump PCI device data in machine readable form (both normal and verbose format supported)
for easy parsing by scripts.
.TP
.B -M
Invoke bus mapping mode which scans the bus extensively to find all devices including
those behind misconfigured bridges etc. Please note that this is intended only for
debugging and as it can crash the machine (only in case of buggy devices, but
unfortunately these happen to exist), it's available only to root. Also using
-M on PCI access methods which don't directly touch the hardware has no
sense since the results are (modulo bugs in lspci) identical to normal listing
modes.

.SH PCILIB OPTIONS
The PCI utilities use PCILIB (a portable library providing platform-independent
functions for PCI configuration space access) to talk to the PCI cards. The following
options control parameters of the library, especially what access method it uses.
By default, PCILIB uses the first available access method and displays no debugging
messages. Each switch is accompanied by a list of hardware/software configurations
it's supported in.

.TP
.B -P <dir>
Use Linux 2.1 style configuration access to directory
.B <dir>
instead of /proc/bus/pci. (Linux 2.1 or newer only)
.TP
.B -H1
Use direct hardware access via Intel configuration mechanism 1. (i386 and compatible only)
.TP
.B -H2
Use direct hardware access via Intel configuration mechanism 2. Warning: This method
is able to address only first 16 devices on any bus and it seems to be very
unrealiable in many cases. (i386 and compatible only)
.TP
.B -S
Use PCI access syscalls. (Linux on Alpha and UltraSparc only)
.TP
.B -F <file>
Extract all information from given file containing output of lspci -x. This is very
useful for analysis of user-supplied bug reports, because you can display the
hardware configuration in any way you want without disturbing the user with
requests for more dumps. (All systems)
.TP
.B -G
Increase debug level of the library. (All systems)

.SH FILES
.TP
.B /usr/share/pci.ids
A list of all known PCI ID's (vendors, devices, classes and subclasses).
.TP
.B /proc/bus/pci
An interface to PCI bus configuration space provided by the post-2.1.82 Linux
kernels. Contains per-bus subdirectories with per-card config space files and a
.I devices
file containing a list of all PCI devices.

.SH SEE ALSO
.BR setpci (8)

.SH AUTHOR
The Linux PCI Utilities are maintained by Martin Mares <mj@atrey.karlin.mff.cuni.cz>.
