/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -a -L ANSI-C -E -C -c -o -t -k '*' -NfindEntity -Hhash_Entity -Wwordlist_Entity -D -s 2 kentities.gperf  */
/*   This file is part of the KDE libraries
  
     Copyright (C) 1999 Lars Knoll (knoll@mpi-hd.mpg.de)
  
     This library is free software; you can redistribute it and/or
     modify it under the terms of the GNU Library General Public
     License as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later version.
  
     This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Library General Public License for more details.
  
     You should have received a copy of the GNU Library General Public License
     along with this library; see the file COPYING.LIB.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
  ----------------------------------------------------------------------------
  
    kentities.gperf: input file to generate a hash table for entities
    kentities.c: DO NOT EDIT! generated by the command
    "gperf -a -L "ANSI-C" -C -G -c -o -t -k '*' -NfindEntity -D -s 2 khtmlentities.gperf > entities.c"   
    from kentities.gperf 

    $Id: kentities.c,v 1.9.2.1 2003/05/30 14:28:40 mueller Exp $     
*/  
struct entity {
    const char *name;
    int code;
};
/* maximum key range = 1883, duplicates = 1 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash_Entity (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,    5,
        15,   10,    0, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887,  115,    0,   40,   50,   90,
      1887,    0,    0,   45, 1887,    5,   25,    0,   20,  225,
        10,    0,   30,   60,   10,   20, 1887, 1887,   20,   30,
        55, 1887, 1887, 1887, 1887, 1887, 1887,    0,  285,    5,
        75,   25,   55,  390,  335,   10,    5,    0,   30,  120,
       205,   40,  430,  110,    0,  580,  320,    5,  100,    0,
         5,   75,   15, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
      1887, 1887, 1887, 1887, 1887, 1887
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 8:
        hval += asso_values[(unsigned char)str[7]];
      case 7:
        hval += asso_values[(unsigned char)str[6]];
      case 6:
        hval += asso_values[(unsigned char)str[5]];
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval;
}

#ifdef __GNUC__
__inline
#endif
const struct entity *
findEntity (register const char *str, register unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 276,
      MIN_WORD_LENGTH = 2,
      MAX_WORD_LENGTH = 8,
      MIN_HASH_VALUE = 4,
      MAX_HASH_VALUE = 1886
    };

  static const struct entity wordlist_Entity[] =
    {
      {"rarr", 0x2192},
      {"Mu", 0x039c},
      {"uarr", 0x2191},
      {"crarr", 0x21b5},
      {"GT", 62},
      {"xi", 0x03be},
      {"Tau", 0x03a4},
      {"Pi", 0x03a0},
      {"zwj", 0x200d},
      {"circ", 0x02c6},
      {"acirc", 0x00e2},
      {"Nu", 0x039d},
      {"ucirc", 0x00fb},
      {"Xi", 0x039e},
      {"larr", 0x2190},
      {"icirc", 0x00ee},
      {"LT", 60},
      {"or", 0x22a6},
      {"Ucirc", 0x00db},
      {"ecirc", 0x00ea},
      {"le", 0x2264},
      {"real", 0x211c},
      {"ocirc", 0x00f4},
      {"Icirc", 0x00ce},
      {"frac14", 0x00bc},
      {"euro", 0x20ac},
      {"rceil", 0x2309},
      {"frac34", 0x00be},
      {"darr", 0x2193},
      {"iexcl", 0x00a1},
      {"frac12", 0x00bd},
      {"loz", 0x25ca},
      {"radic", 0x221a},
      {"ETH", 0x00d0},
      {"lceil", 0x2308},
      {"Ecirc", 0x00ca},
      {"rArr", 0x21d2},
      {"uArr", 0x21d1},
      {"mu", 0x03bc},
      {"AMP", 38},
      {"macr", 0x00af},
      {"Acirc", 0x00c2},
      {"lArr", 0x21d0},
      {"cedil", 0x00b8},
      {"lrm", 0x200e},
      {"rlm", 0x200f},
      {"ccedil", 0x00e7},
      {"uml", 0x00a8},
      {"auml", 0x00e4},
      {"raquo", 0x00bb},
      {"forall", 0x2200},
      {"uuml", 0x00fc},
      {"iuml", 0x00ef},
      {"Prime", 0x2033},
      {"rfloor", 0x230b},
      {"ordf", 0x00aa},
      {"Uuml", 0x00dc},
      {"micro", 0x00b5},
      {"euml", 0x00eb},
      {"Yuml", 0x0178},
      {"laquo", 0x00ab},
      {"Ccedil", 0x00c7},
      {"dArr", 0x21d3},
      {"ouml", 0x00f6},
      {"lfloor", 0x230a},
      {"Iuml", 0x00cf},
      {"nu", 0x03bd},
      {"ni", 0x220b},
      {"zwnj", 0x200c},
      {"ne", 0x2260},
      {"yuml", 0x00ff},
      {"rdquo", 0x201d},
      {"ordm", 0x00ba},
      {"Gamma", 0x0393},
      {"curren", 0x00a4},
      {"Euml", 0x00cb},
      {"Ocirc", 0x00d4},
      {"equiv", 0x2261},
      {"rcaron", 0x0159},
      {"QUOT", 34},
      {"ccaron", 0x010d},
      {"ldquo", 0x201c},
      {"Tcaron", 0x0164},
      {"zcaron", 0x017e},
      {"Auml", 0x00c4},
      {"Ncaron", 0x0147},
      {"ecaron", 0x011b},
      {"and", 0x22a5},
      {"Rcaron", 0x0158},
      {"THORN", 0x00de},
      {"Ccaron", 0x010c},
      {"divide", 0x00f7},
      {"Dcaron", 0x010e},
      {"yen", 0x00a5},
      {"Zcaron", 0x017d},
      {"oline", 0x203e},
      {"Scaron", 0x0160},
      {"tau", 0x03c4},
      {"dcaron", 0x10f},
      {"harr", 0x2194},
      {"Ecaron", 0x011a},
      {"eta", 0x03b7},
      {"Beta", 0x0392},
      {"lt", 60},
      {"chi", 0x03c7},
      {"bull", 0x2022},
      {"Phi", 0x03a6},
      {"fnof", 0x0192},
      {"acute", 0x00b4},
      {"aacute", 0x00e1},
      {"zeta", 0x03b6},
      {"uacute", 0x00fa},
      {"iacute", 0x00ed},
      {"iota", 0x03b9},
      {"rho", 0x03c1},
      {"Uacute", 0x00da},
      {"Ouml", 0x00d6},
      {"eacute", 0x00e9},
      {"Chi", 0x03a7},
      {"Yacute", 0x00dd},
      {"oacute", 0x00f3},
      {"Zeta", 0x0396},
      {"Iacute", 0x00cd},
      {"Rho", 0x03a1},
      {"Iota", 0x0399},
      {"Eta", 0x0397},
      {"ge", 0x2265},
      {"reg", 0x00ae},
      {"trade", 0x2122},
      {"omicron", 0x03bf},
      {"Delta", 0x0394},
      {"para", 0x00b6},
      {"yacute", 0x00fd},
      {"cap", 0x2229},
      {"pi", 0x03c0},
      {"cup", 0x222a},
      {"Eacute", 0x00c9},
      {"hArr", 0x21d4},
      {"delta", 0x03b4},
      {"aelig", 0x00e6},
      {"ncaron", 0x0148},
      {"tilde", 0x02dc},
      {"atilde", 0x00e3},
      {"Aacute", 0x00c1},
      {"quot", 34},
      {"Ntilde", 0x00d1},
      {"infin", 0x221e},
      {"deg", 0x00b0},
      {"weierp", 0x2118},
      {"oelig", 0x0153},
      {"otilde", 0x00f5},
      {"Lambda", 0x039b},
      {"lambda", 0x03bb},
      {"bdquo", 0x201e},
      {"agrave", 0x00e0},
      {"nabla", 0x2207},
      {"ugrave", 0x00f9},
      {"igrave", 0x00ec},
      {"int", 0x222b},
      {"Ugrave", 0x00d9},
      {"piv", 0x03d6},
      {"egrave", 0x00e8},
      {"prod", 0x220f},
      {"image", 0x2111},
      {"amp", 38},
      {"copy", 0x00a9},
      {"cent", 0x00a2},
      {"ograve", 0x00f2},
      {"Igrave", 0x00cc},
      {"not", 0x00ac},
      {"tcaron", 0x0165},
      {"omega", 0x03c9},
      {"Atilde", 0x00c3},
      {"Sigma", 0x03a3},
      {"Oacute", 0x00d3},
      {"prime", 0x2032},
      {"ang", 0x2220},
      {"rang", 0x232a},
      {"Psi", 0x03a8},
      {"aring", 0x00e5},
      {"Egrave", 0x00c8},
      {"Omicron", 0x039f},
      {"uring", 0x016f},
      {"permil", 0x2030},
      {"lang", 0x2329},
      {"Uring", 0x016e},
      {"beta", 0x03b2},
      {"gamma", 0x03b3},
      {"Agrave", 0x00c0},
      {"AElig", 0x00c6},
      {"cong", 0x2245},
      {"middot", 0x00b7},
      {"frasl", 0x2044},
      {"ntilde", 0x00f1},
      {"brvbar", 0x00a6},
      {"eth", 0x00f0},
      {"Otilde", 0x00d5},
      {"Theta", 0x0398},
      {"sum", 0x2211},
      {"there4", 0x2234},
      {"gt", 62},
      {"sim", 0x223c},
      {"Aring", 0x00c5},
      {"rsquo", 0x2019},
      {"rsaquo", 0x203a},
      {"Ograve", 0x00d2},
      {"OElig", 0x0152},
      {"part", 0x2202},
      {"pound", 0x00a3},
      {"Omega", 0x03a9},
      {"lsquo", 0x2018},
      {"lsaquo", 0x2039},
      {"phi", 0x03c6},
      {"notin", 0x2209},
      {"diams", 0x2666},
      {"alpha", 0x03b1},
      {"isin", 0x2208},
      {"scaron", 0x0161},
      {"Dagger", 0x2021},
      {"kappa", 0x03ba},
      {"hellip", 0x2026},
      {"Kappa", 0x039a},
      {"sub", 0x2282},
      {"dagger", 0x2020},
      {"perp", 0x22a5},
      {"alefsym", 0x2135},
      {"sube", 0x2286},
      {"prop", 0x221d},
      {"thorn", 0x00fe},
      {"clubs", 0x2663},
      {"Alpha", 0x0391},
      {"minus", 0x2212},
      {"sect", 0x00a7},
      {"exist", 0x2203},
      {"empty", 0x2205},
      {"lowast", 0x2217},
      {"percnt", 0x0025},
      {"shy", 0x00ad},
      {"theta", 0x03b8},
      {"sup", 0x2283},
      {"sdot", 0x22c5},
      {"psi", 0x03c8},
      {"sup1", 0x00b9},
      {"sbquo", 0x201a},
      {"sup3", 0x00b3},
      {"szlig", 0x00df},
      {"sup2", 0x00b2},
      {"supe", 0x2287},
      {"apos", 0x0027},
      {"iquest", 0x00bf},
      {"times", 0x00d7},
      {"nsub", 0x2284},
      {"oplus", 0x2295},
      {"otimes", 0x2297},
      {"sigma", 0x03c3},
      {"mdash", 0x2014},
      {"emdash", 0x2014},
      {"emsp", 0x2003},
      {"sigmaf", 0x03c2},
      {"ndash", 0x2013},
      {"asymp", 0x2248},
      {"endash", 0x2013},
      {"ensp", 0x2002},
      {"hearts", 0x2665},
      {"upsilon", 0x03c5},
      {"Upsilon", 0x03a5},
      {"epsilon", 0x03b5},
      {"upsih", 0x03d2},
      {"plusmn", 0x00b1},
      {"Epsilon", 0x0395},
      {"nbsp", 0x00a0},
      {"oslash", 0x00f8},
      {"spades", 0x2660},
      {"Oslash", 0x00d8},
      {"thetasym", 0x03d1},
      {"thinsp", 0x2009}
    };

  static const short lookup[] =
    {
        -1,   -1,   -1,   -1,    0,   -1,   -1,    1,
        -1,    2,    3,   -1,    4,   -1,   -1,   -1,
        -1,    5,    6,   -1,   -1,   -1,    7,    8,
         9,   10,   -1,   11,   -1,   -1,   12,   -1,
        13,   -1,   14,   15,   -1,   16,   -1,   -1,
        -1,   -1,   17,   -1,   -1,   18,   -1,   -1,
        -1,   -1,   19,   -1,   -1,   -1,   -1,   -1,
        -1,   20,   -1,   21,   -1,   -1,   -1,   -1,
        -1,   22,   -1,   -1,   -1,   -1,   23,   24,
        -1,   -1,   25,   26,   27,   -1,   -1,   28,
        29,   -1,   -1,   -1,   -1,   -1,   30,   -1,
        31,   -1,   -1,   -1,   -1,   -1,   -1,   32,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,
        -1,   34,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   35,   -1,   -1,   -1,   36,
        -1,   -1,   -1,   -1,   37,   -1,   -1,   38,
        39,   40,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   41,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   42,   43,   -1,
        -1, -431, -232,   -2,   46,   -1,   47,   48,
        49,   50,   -1,   -1,   51,   -1,   -1,   -1,
        -1,   52,   53,   54,   -1,   -1,   55,   -1,
        -1,   -1,   -1,   56,   57,   -1,   -1,   -1,
        58,   -1,   -1,   -1,   -1,   59,   60,   61,
        -1,   -1,   62,   -1,   -1,   -1,   -1,   63,
        -1,   64,   -1,   -1,   65,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   66,   -1,   -1,   -1,
        -1,   67,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   68,   -1,   -1,
        69,   -1,   70,   71,   -1,   -1,   -1,   72,
        -1,   -1,   -1,   -1,   -1,   73,   74,   -1,
        -1,   75,   76,   -1,   -1,   -1,   -1,   77,
        78,   -1,   -1,   79,   -1,   80,   -1,   -1,
        -1,   81,   82,   -1,   -1,   -1,   -1,   83,
        -1,   -1,   84,   -1,   85,   -1,   -1,   -1,
        -1,   86,   -1,   87,   -1,   -1,   88,   -1,
        -1,   -1,   89,   -1,   -1,   -1,   -1,   -1,
        90,   -1,   -1,   -1,   -1,   91,   -1,   -1,
        -1,   -1,   92,   -1,   93,   -1,   -1,   94,
        -1,   -1,   -1,   95,   96,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        97,   -1,   -1,   98,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   99,   -1,   -1,   -1,   -1,
        -1,   -1,  100,   -1,  101,  102,   -1,   -1,
       103,  104,  105,   -1,   -1,   -1,  106,  107,
       108,  109,   -1,   -1,  110,   -1,  111,   -1,
        -1,   -1,   -1,  112,   -1,   -1,  113,   -1,
        -1,   -1,  114,   -1,   -1,  115,   -1,   -1,
       116,   -1,  117,   -1,  118,   -1,   -1,  119,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  120,   -1,   -1,  121,   -1,  122,   -1,
       123,  124,   -1,   -1,   -1,  125,   -1,   -1,
        -1,  126,  127,   -1,   -1,   -1,   -1,   -1,
        -1,  128,   -1,  129,   -1,   -1,  130,   -1,
        -1,   -1,  131,   -1,  132,   -1,  133,   -1,
        -1,   -1,  134,  135,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  136,   -1,   -1,  137,  138,
        -1,   -1,   -1,   -1,  139,  140,   -1,   -1,
        -1,  141,  142,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  143,   -1,   -1,  144,
        -1,   -1,   -1,   -1,   -1,   -1,  145,   -1,
        -1,   -1,  146,   -1,   -1,  147,   -1,   -1,
       148,   -1,   -1,   -1,  149,   -1,   -1,   -1,
        -1,   -1,  150,   -1,   -1,   -1,   -1,  151,
        -1,   -1,   -1,   -1,  152,   -1,   -1,   -1,
       153,  154,   -1,   -1,   -1,  155,  156,   -1,
        -1,   -1,   -1,  157,   -1,   -1,   -1,   -1,
        -1,   -1,  158,   -1,   -1,  159,   -1,  160,
        -1,   -1,  161,   -1,   -1,  162,  163,   -1,
        -1,  164,  165,   -1,   -1,   -1,   -1,  166,
        -1,  167,   -1,   -1,   -1,   -1,  168,   -1,
       169,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       170,   -1,   -1,   -1,  171,  172,   -1,   -1,
        -1,  173,  174,   -1,   -1,   -1,  175,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  176,  177,
        -1,   -1,   -1,  178,   -1,   -1,   -1,   -1,
        -1,   -1,  179,  180,  181,   -1,   -1,  182,
        -1,   -1,   -1,   -1,   -1,  183,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  184,  185,   -1,
        -1,   -1,  186,  187,  188,   -1,   -1,   -1,
       189,   -1,   -1,   -1,  190,   -1,  191,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  192,  193,
        -1,   -1,   -1,   -1,  194,   -1,   -1,   -1,
        -1,   -1,   -1,  195,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  196,   -1,   -1,   -1,  197,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  198,   -1,   -1,  199,
       200,  201,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  202,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  203,  204,   -1,   -1,
        -1,   -1,  205,   -1,   -1,   -1,  206,   -1,
        -1,   -1,  207,   -1,   -1,   -1,   -1,   -1,
       208,   -1,   -1,   -1,   -1,  209,   -1,   -1,
        -1,   -1,  210,  211,   -1,   -1,   -1,   -1,
        -1,   -1,  212,   -1,   -1,   -1,   -1,   -1,
        -1,  213,   -1,   -1,   -1,   -1,  214,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       215,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  216,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  217,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  218,   -1,   -1,
        -1,  219,  220,   -1,   -1,   -1,  221,   -1,
        -1,  222,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  223,   -1,
        -1,  224,   -1,   -1,  225,   -1,   -1,   -1,
        -1,   -1,   -1,  226,   -1,   -1,   -1,   -1,
       227,  228,   -1,   -1,   -1,   -1,  229,   -1,
        -1,   -1,   -1,  230,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  231,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  232,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  233,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  234,
       235,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  236,
        -1,  237,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  238,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  239,  240,   -1,   -1,   -1,  241,
       242,  243,   -1,   -1,   -1,  244,  245,   -1,
        -1,   -1,  246,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  247,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  248,   -1,
       249,   -1,   -1,   -1,  250,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  251,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  252,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  253,   -1,   -1,
        -1,  254,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  255,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
        -1,  258,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       259,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  260,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  261,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  263,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  264,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  265,   -1,   -1,   -1,   -1,  266,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  267,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       268,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       269,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       270,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       272,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  273,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  274,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  275
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash_Entity (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist_Entity[index].name;

              if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
                return &wordlist_Entity[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct entity *wordptr = &wordlist_Entity[TOTAL_KEYWORDS + lookup[offset]];
              register const struct entity *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}

