/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.IteratorIteration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderIterator
extends DelayedIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final Comparator<BindingSet> comparator;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator) {
        this.iter = iter;
        this.comparator = comparator;
    }

    @Override
    protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        List list = Iterations.addAll(this.iter, new ArrayList(1024));
        if (!this.isClosed()) {
            Collections.sort(list, this.comparator);
            return new IteratorIteration<BindingSet, QueryEvaluationException>(list.iterator());
        }
        return new EmptyIteration<BindingSet, QueryEvaluationException>();
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.iter.close();
    }
}

