#!/usr/bin/env python

"""**************************************************************************
** $Id: fonts.py 322023 2004-06-19 20:33:37Z sedwards $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

class Viewer( QWidget ):
    def __init__( self ):
        QWidget.__init__( self )

        self.setFontSubstitutions()

        #greeting_heb = QString.fromUtf8( "\327\251\327\234\327\225\327\235" )
        greeting_heb = unicode( '\327\251\327\234\327\225\327\235','utf8' )
        #greeting_ru  = QString.fromUtf8( "\320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265" )
        greeting_ru  = unicode('\320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265','utf8' )
        greeting_en  = "Hello"

        self.greetings = QTextView( self, "textview" )

        self.greetings.setText( greeting_en + "\n" +
                                greeting_ru + "\n" +
                                greeting_heb )

        self.fontInfo = QTextView( self, "fontinfo" )
        
        self.setDefault()

        self.defaultButton = QPushButton( "Default", self, "pushbutton1" )
        self.defaultButton.setFont( QFont( "times" ) )
        self.connect( self.defaultButton, SIGNAL("clicked()"), self.setDefault )

        self.sansSerifButton = QPushButton( "Sans Serif", self, "pushbutton2" )
        self.sansSerifButton.setFont( QFont( "Helvetica", 12 ) )
        self.connect( self.sansSerifButton, SIGNAL("clicked()"), self.setSansSerif )

        self.italicsButton = QPushButton( "Italics", self, "pushbutton3" )
        self.italicsButton.setFont( QFont( "lucida", 12, QFont.Bold, True ) )
        self.connect( self.italicsButton, SIGNAL("clicked()"), self.setItalics )

        self.layout()

    def setDefault( self ):
        font = QFont( "Bavaria" )
        font.setPointSize( 24 )
        font.setWeight( QFont.Bold )
        font.setUnderline( True )
        
        self.greetings.setFont( font )
        
        self.showFontInfo( font )

    def setSansSerif( self ):
        font = QFont( "Newyork", 18 )
        font.setStyleHint( QFont.SansSerif )
        
        self.greetings.setFont( font )

        self.showFontInfo( font )

    def setItalics( self ):
        font = QFont( "Tokyo" )
        font.setPointSize( 32 )
        font.setWeight( QFont.Bold )
        font.setItalic( True )

        self.greetings.setFont( font )

        self.showFontInfo( font )

    def showFontInfo( self, font ):
        info = QFontInfo( font )

        messageText = "Font requested: \"" + str(font.family()) + "\" " \
                      + str(QString.number( font.pointSize() )) + "pt<BR>" \
                      + "Font used: \"" + str(info.family()) + "\" " \
                      + str(QString.number( info.pointSize() )) + "pt<P>"

        if not self.substitutes.isEmpty() :
            messageText += "The following substitutions exist for " + \
                           str(font.family()) + ":<UL>"
            for i in self.substitutes :
                messageText += "<LI>\"" + str(i) + "\""
            messageText += "</UL>";
        else :
            messageText += "No substitutions exist for " + \
                           str(font.family()) + "."

        self.fontInfo.setText( messageText )

    def setFontSubstitutions( self ):
        self.substitutes = QStringList()
        self.substitutes.append( "Times" )
        self.substitutes.append( "Mincho" )
        self.substitutes.append( "Arabic Newspaper" )
        self.substitutes.append( "crox" )
        #QFont.insertSubstitutions( "Bavaria", self.substitutes )
        QFont.insertSubstitution( "Bavaria", "Times" )
        QFont.insertSubstitution( "Tokyo", "Lucida" )
           
    # For those who prefer to use Qt Designer for creating GUIs        
    # the following function might not be of particular interest:
    # all it does is creating the widget layout.
    def layout( self ):
        textViewContainer = QHBoxLayout()
        textViewContainer.addWidget( self.greetings )
        textViewContainer.addWidget( self.fontInfo )

        buttonContainer = QHBoxLayout()
        buttonContainer.addWidget( self.defaultButton )
        buttonContainer.addWidget( self.sansSerifButton )
        buttonContainer.addWidget( self.italicsButton )

        maxButtonHeight = self.defaultButton.height()

        if self.sansSerifButton.height() > maxButtonHeight :
            maxButtonHeight = self.sansSerifButton.height()
        if self.italicsButton.height() > maxButtonHeight :
            maxButtonHeight = self.italicsButton.height()

        self.defaultButton.setFixedHeight( maxButtonHeight )
        self.sansSerifButton.setFixedHeight( maxButtonHeight )
        self.italicsButton.setFixedHeight( maxButtonHeight )

        container = QVBoxLayout( self )
        container.addLayout( textViewContainer )
        container.addLayout( buttonContainer )

        self.resize( 700, 250 )
    
def main( args ):
    app = QApplication(sys.argv)          # application object
    
    textViewer = Viewer()
    textViewer.setCaption( "Qt Example - Simple QFont Demo" )
    app.setMainWidget( textViewer )
    textViewer.show()
    
    app.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
