/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.text.ClipboardManager;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MotionEvent;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.qtproject.qt5.android.QtActivityDelegate;

public class QtNative {
    private static Activity m_activity = null;
    private static QtActivityDelegate m_activityDelegate = null;
    public static Object m_mainActivityMutex = new Object();
    public static final String QtTAG = "Qt JAVA";
    private static ArrayList<Runnable> m_lostActions = new ArrayList();
    private static boolean m_started = false;
    private static int m_displayMetricsScreenWidthPixels = 0;
    private static int m_displayMetricsScreenHeightPixels = 0;
    private static int m_displayMetricsDesktopWidthPixels = 0;
    private static int m_displayMetricsDesktopHeightPixels = 0;
    private static double m_displayMetricsXDpi = 0.0;
    private static double m_displayMetricsYDpi = 0.0;
    private static double m_displayMetricsScaledDensity = 1.0;
    private static int m_oldx;
    private static int m_oldy;
    private static final int m_moveThreshold = 0;
    private static ClipboardManager m_clipboardManager;
    private static ClassLoader m_classLoader;

    public static ClassLoader classLoader() {
        return m_classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        m_classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Activity activity() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QtActivityDelegate activityDelegate() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activityDelegate;
        }
    }

    public static void openURL(String string) {
        try {
            Uri uri = Uri.parse((String)string);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            QtNative.activity().startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadQtLibraries(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (String string : arrayList) {
            try {
                File file = new File(string);
                if (!file.exists()) continue;
                System.load(string);
            }
            catch (SecurityException securityException) {
                Log.i((String)QtTAG, (String)("Can't load '" + string + "'"), (Throwable)securityException);
            }
            catch (Exception exception) {
                Log.i((String)QtTAG, (String)("Can't load '" + string + "'"), (Throwable)exception);
            }
        }
    }

    public static void loadBundledLibraries(ArrayList<String> arrayList, String string) {
        if (arrayList == null) {
            return;
        }
        for (String string2 : arrayList) {
            try {
                File file = new File(string + "lib" + string2 + ".so");
                if (file.exists()) {
                    System.load(file.getAbsolutePath());
                    continue;
                }
                Log.i((String)QtTAG, (String)("Can't find '" + file.getAbsolutePath()));
            }
            catch (Exception exception) {
                Log.i((String)QtTAG, (String)("Can't load '" + string2 + "'"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActivity(Activity activity, QtActivityDelegate qtActivityDelegate) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_activity = activity;
            m_activityDelegate = qtActivityDelegate;
        }
    }

    public static ArrayList<Runnable> getLostActions() {
        return m_lostActions;
    }

    public static void clearLostActions() {
        m_lostActions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runAction(Runnable runnable) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_activity == null) {
                m_lostActions.add(runnable);
            } else {
                m_activity.runOnUiThread(runnable);
            }
            return m_activity != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startApplication(String string, String string2, String string3, String string4) throws Exception {
        File file = new File(string4 + "lib" + string3 + ".so");
        if (!file.exists()) {
            throw new Exception("Can't find main library '" + string3 + "'");
        }
        if (string == null) {
            string = "-platform\tandroid";
        }
        boolean bl = false;
        Object object = m_mainActivityMutex;
        synchronized (object) {
            bl = QtNative.startQtAndroidPlugin();
            QtNative.setDisplayMetrics(m_displayMetricsScreenWidthPixels, m_displayMetricsScreenHeightPixels, m_displayMetricsDesktopWidthPixels, m_displayMetricsDesktopHeightPixels, m_displayMetricsXDpi, m_displayMetricsYDpi, m_displayMetricsScaledDensity);
            if (string.length() > 0 && !string.startsWith("\t")) {
                string = "\t" + string;
            }
            QtNative.startQtApplication(file.getAbsolutePath() + string, string2);
            m_started = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationDisplayMetrics(int n, int n2, int n3, int n4, double d, double d2, double d3) {
        if (d < 120.0) {
            d = 120.0;
        }
        if (d2 < 120.0) {
            d2 = 120.0;
        }
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_started) {
                QtNative.setDisplayMetrics(n, n2, n3, n4, d, d2, d3);
            } else {
                m_displayMetricsScreenWidthPixels = n;
                m_displayMetricsScreenHeightPixels = n2;
                m_displayMetricsDesktopWidthPixels = n3;
                m_displayMetricsDesktopHeightPixels = n4;
                m_displayMetricsXDpi = d;
                m_displayMetricsYDpi = d2;
                m_displayMetricsScaledDensity = d3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseApplication() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_started) {
                QtNative.pauseQtApp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeApplication() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_started) {
                QtNative.resumeQtApp();
                QtNative.updateWindow();
            }
        }
    }

    public static native void startQtApplication(String var0, String var1);

    public static native void startQtApp(String var0, String var1);

    public static native void pauseQtApp();

    public static native void resumeQtApp();

    public static native boolean startQtAndroidPlugin();

    public static native void quitQtAndroidPlugin();

    public static native void terminateQt();

    private static void quitApp() {
        m_activity.finish();
    }

    private static void redrawSurface(final int n, final int n2, final int n3, final int n4) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.redrawWindow(n, n2, n3, n4);
            }
        });
    }

    private static int getAction(int n, MotionEvent motionEvent) {
        int n2 = motionEvent.getActionMasked();
        if (n2 == 2) {
            int n3 = motionEvent.getHistorySize();
            if (n3 > 0) {
                if (motionEvent.getX(n) != motionEvent.getHistoricalX(n, n3 - 1) || motionEvent.getY(n) != motionEvent.getHistoricalY(n, n3 - 1)) {
                    return 1;
                }
                return 2;
            }
            return 1;
        }
        if (n2 == 0 || n2 == 5 && n == motionEvent.getActionIndex()) {
            return 0;
        }
        if (n2 == 1 || n2 == 6 && n == motionEvent.getActionIndex()) {
            return 3;
        }
        return 2;
    }

    public static void sendTouchEvent(MotionEvent motionEvent, int n) {
        QtNative.touchBegin(n);
        for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
            QtNative.touchAdd(n, motionEvent.getPointerId(i), QtNative.getAction(i, motionEvent), i == 0, (int)motionEvent.getX(i), (int)motionEvent.getY(i), motionEvent.getSize(i), motionEvent.getPressure(i));
        }
        switch (motionEvent.getAction()) {
            case 0: {
                QtNative.touchEnd(n, 0);
                break;
            }
            case 1: {
                QtNative.touchEnd(n, 2);
                break;
            }
            default: {
                QtNative.touchEnd(n, 1);
            }
        }
    }

    public static void sendTrackballEvent(MotionEvent motionEvent, int n) {
        switch (motionEvent.getAction()) {
            case 1: {
                QtNative.mouseUp(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                break;
            }
            case 0: {
                QtNative.mouseDown(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                m_oldx = (int)motionEvent.getX();
                m_oldy = (int)motionEvent.getY();
                break;
            }
            case 2: {
                int n2 = (int)(motionEvent.getX() - (float)m_oldx);
                int n3 = (int)(motionEvent.getY() - (float)m_oldy);
                if (Math.abs(n2) <= 5 && Math.abs(n3) <= 5) break;
                QtNative.mouseMove(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                m_oldx = (int)motionEvent.getX();
                m_oldy = (int)motionEvent.getY();
            }
        }
    }

    private static void updateSelection(final int n, final int n2, final int n3, final int n4) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.updateSelection(n, n2, n3, n4);
            }
        });
    }

    private static void showSoftwareKeyboard(final int n, final int n2, final int n3, final int n4, final int n5) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.showSoftwareKeyboard(n, n2, n3, n4, n5);
            }
        });
    }

    private static void resetSoftwareKeyboard() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.resetSoftwareKeyboard();
            }
        });
    }

    private static void hideSoftwareKeyboard() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.hideSoftwareKeyboard();
            }
        });
    }

    private static boolean isSoftwareKeyboardVisible() {
        final Semaphore semaphore = new Semaphore(0);
        final Boolean[] booleanArray = new Boolean[]{false};
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                booleanArray[0] = m_activityDelegate.isSoftwareKeyboardVisible();
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return booleanArray[0];
    }

    private static void setFullScreen(final boolean bl) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.setFullScreen(bl);
                QtNative.updateWindow();
            }
        });
    }

    private static void registerClipboardManager() {
        final Semaphore semaphore = new Semaphore(0);
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_clipboardManager = (ClipboardManager)m_activity.getSystemService("clipboard");
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void setClipboardText(String string) {
        m_clipboardManager.setText((CharSequence)string);
    }

    private static boolean hasClipboardText() {
        return m_clipboardManager.hasText();
    }

    private static String getClipboardText() {
        return ((Object)m_clipboardManager.getText()).toString();
    }

    private static void openContextMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.openContextMenu();
            }
        });
    }

    private static void closeContextMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.closeContextMenu();
            }
        });
    }

    private static void resetOptionsMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.resetOptionsMenu();
            }
        });
    }

    private static byte[][] getSSLCertificates() {
        Object object;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init((KeyStore)null);
            for (TrustManager trustManager : ((TrustManagerFactory)object).getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                    byte[] byArray = x509Certificate.getEncoded();
                    arrayList.add(byArray);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get certificates", (Throwable)exception);
        }
        object = new byte[arrayList.size()][];
        object = (byte[][])arrayList.toArray((T[])object);
        return object;
    }

    public static native void setDisplayMetrics(int var0, int var1, int var2, int var3, double var4, double var6, double var8);

    public static native void handleOrientationChanged(int var0, int var1);

    public static native void mouseDown(int var0, int var1, int var2);

    public static native void mouseUp(int var0, int var1, int var2);

    public static native void mouseMove(int var0, int var1, int var2);

    public static native void touchBegin(int var0);

    public static native void touchAdd(int var0, int var1, int var2, boolean var3, int var4, int var5, float var6, float var7);

    public static native void touchEnd(int var0, int var1);

    public static native void longPress(int var0, int var1, int var2);

    public static native void keyDown(int var0, int var1, int var2);

    public static native void keyUp(int var0, int var1, int var2);

    public static native void keyboardVisibilityChanged(boolean var0);

    public static native void destroySurface();

    public static native void setSurface(Object var0);

    public static native void lockSurface();

    public static native void unlockSurface();

    public static native void updateWindow();

    public static native void updateApplicationState(int var0);

    public static native boolean onPrepareOptionsMenu(Menu var0);

    public static native boolean onOptionsItemSelected(int var0, boolean var1);

    public static native void onOptionsMenuClosed(Menu var0);

    public static native void onCreateContextMenu(ContextMenu var0);

    public static native boolean onContextItemSelected(int var0, boolean var1);

    public static native void onContextMenuClosed(Menu var0);

    static {
        m_clipboardManager = null;
        m_classLoader = null;
    }
}

