.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "PREPARE TRANSACTION" "" "2008-03-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
PREPARE TRANSACTION \- prepare the current transaction for two-phase commit

.SH SYNOPSIS
.sp
.nf
PREPARE TRANSACTION \fItransaction_id\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBPREPARE TRANSACTION\fR prepares the current transaction
for two-phase commit. After this command, the transaction is no longer 
associated with the current session; instead, its state is fully stored on
disk, and there is a very high probability that it can be committed
successfully, even if a database crash occurs before the commit is
requested.
.PP
Once prepared, a transaction can later be committed or rolled back
with COMMIT PREPARED [\fBcommit_prepared\fR(l)]
or ROLLBACK PREPARED [\fBrollback_prepared\fR(l)],
respectively. Those commands can be issued from any session, not
only the one that executed the original transaction.
.PP
From the point of view of the issuing session, \fBPREPARE
TRANSACTION\fR is not unlike a \fBROLLBACK\fR command:
after executing it, there is no active current transaction, and the
effects of the prepared transaction are no longer visible. (The effects
will become visible again if the transaction is committed.)
.PP
If the \fBPREPARE TRANSACTION\fR command fails for any
reason, it becomes a \fBROLLBACK\fR: the current transaction
is canceled.
.SH "PARAMETERS"
.TP
\fB\fItransaction_id\fB\fR
An arbitrary identifier that later identifies this transaction for
\fBCOMMIT PREPARED\fR or \fBROLLBACK PREPARED\fR.
The identifier must be written as a string literal, and must be
less than 200 bytes long. It must not be the same as the identifier
used for any currently prepared transaction.
.SH "NOTES"
.PP
This command must be used inside a transaction block. Use BEGIN [\fBbegin\fR(l)] to start one.
.PP
It is not currently allowed to \fBPREPARE\fR a transaction that
has executed any operations involving temporary tables,
created any cursors WITH HOLD, or executed
\fBLISTEN\fR or \fBUNLISTEN\fR.
Those features are too tightly
tied to the current session to be useful in a transaction to be prepared.
.PP
If the transaction modified any run-time parameters with \fBSET\fR,
those effects persist after \fBPREPARE TRANSACTION\fR, and will not
be affected by any later \fBCOMMIT PREPARED\fR or 
\fBROLLBACK PREPARED\fR. Thus, in this one respect
\fBPREPARE TRANSACTION\fR acts more like \fBCOMMIT\fR than
\fBROLLBACK\fR.
.PP
All currently available prepared transactions are listed in the
\fBpg_prepared_xacts\fR
system view.
.PP
From a performance standpoint, it is unwise to leave transactions in
the prepared state for a long time: this will for instance interfere with
the ability of \fBVACUUM\fR to reclaim storage. Keep in mind also
that the transaction continues to hold whatever locks it held.
The intended
usage of the feature is that a prepared transaction will normally be
committed or rolled back as soon as an external transaction manager
has verified that other databases are also prepared to commit.
.PP
If you make any serious use of prepared transactions, you will probably
want to increase the value of max_prepared_transactions, as the default setting is
quite small (to avoid wasting resources for those who don't use it).
It is recommendable to make it at least equal to
max_connections, so that every session can have
a prepared transaction pending.
.SH "EXAMPLES"
.PP
Prepare the current transaction for two-phase commit, using
foobar as the transaction identifier:
.sp
.nf
PREPARE TRANSACTION 'foobar';
.sp
.fi
.SH "SEE ALSO"
COMMIT PREPARED [\fBcommit_prepared\fR(l)], ROLLBACK PREPARED [\fBrollback_prepared\fR(l)]
