/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLPolygonMode.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLPolygonModePrototypeFunction_polygonModeWEBGL);

class JSWebGLPolygonModePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLPolygonModePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLPolygonModePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLPolygonModePrototype>(vm)) JSWebGLPolygonModePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLPolygonModePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLPolygonModePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLPolygonModePrototype, JSWebGLPolygonModePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLPolygonModePrototypeTableValues[] =
{
    { "polygonModeWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLPolygonModePrototypeFunction_polygonModeWEBGL, 2 } },
    { "POLYGON_MODE_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B40 } },
    { "POLYGON_OFFSET_LINE_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2A02 } },
    { "LINE_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1B01 } },
    { "FILL_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1B02 } },
};

const ClassInfo JSWebGLPolygonModePrototype::s_info = { "WebGLPolygonMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLPolygonModePrototype) };

void JSWebGLPolygonModePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLPolygonMode::info(), JSWebGLPolygonModePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLPolygonMode::s_info = { "WebGLPolygonMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLPolygonMode) };

JSWebGLPolygonMode::JSWebGLPolygonMode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLPolygonMode>&& impl)
    : JSDOMWrapper<WebGLPolygonMode>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLPolygonMode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLPolygonMode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLPolygonModePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLPolygonModePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLPolygonMode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLPolygonMode>(vm, globalObject);
}

void JSWebGLPolygonMode::destroy(JSC::JSCell* cell)
{
    JSWebGLPolygonMode* thisObject = static_cast<JSWebGLPolygonMode*>(cell);
    thisObject->JSWebGLPolygonMode::~JSWebGLPolygonMode();
}

static inline JSC::EncodedJSValue jsWebGLPolygonModePrototypeFunction_polygonModeWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLPolygonMode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto faceConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(faceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto modeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(modeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.polygonModeWEBGL(faceConversionResult.releaseReturnValue(), modeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLPolygonModePrototypeFunction_polygonModeWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLPolygonMode>::call<jsWebGLPolygonModePrototypeFunction_polygonModeWEBGLBody>(*lexicalGlobalObject, *callFrame, "polygonModeWEBGL");
}

JSC::GCClient::IsoSubspace* JSWebGLPolygonMode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLPolygonMode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLPolygonMode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLPolygonMode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLPolygonMode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLPolygonMode = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLPolygonMode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLPolygonMode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLPolygonModeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLPolygonMode = jsCast<JSWebGLPolygonMode*>(handle.slot()->asCell());
    auto& owner = jsWebGLPolygonMode->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLPolygonMode"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLPolygonModeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLPolygonMode = static_cast<JSWebGLPolygonMode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLPolygonMode->protectedWrapped().ptr(), jsWebGLPolygonMode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLPolygonMode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLPolygonModeE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLPolygonMode>, void>> static inline void verifyVTable(WebGLPolygonMode* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLPolygonMode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16WebGLPolygonModeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLPolygonMode has subclasses. If WebGLPolygonMode has subclasses that get passed
        // to toJS() we currently require WebGLPolygonMode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLPolygonMode>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLPolygonMode>(impl.ptr());
#endif
    return createWrapper<WebGLPolygonMode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLPolygonMode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLPolygonMode* JSWebGLPolygonMode::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLPolygonMode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
