/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTTextureFilterAnisotropic.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSEXTTextureFilterAnisotropicPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTTextureFilterAnisotropicPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTTextureFilterAnisotropicPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTTextureFilterAnisotropicPrototype>(vm)) JSEXTTextureFilterAnisotropicPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureFilterAnisotropicPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTTextureFilterAnisotropicPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureFilterAnisotropicPrototype, JSEXTTextureFilterAnisotropicPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTTextureFilterAnisotropicPrototypeTableValues[] =
{
    { "TEXTURE_MAX_ANISOTROPY_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84FE } },
    { "MAX_TEXTURE_MAX_ANISOTROPY_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84FF } },
};

const ClassInfo JSEXTTextureFilterAnisotropicPrototype::s_info = { "EXTTextureFilterAnisotropic"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureFilterAnisotropicPrototype) };

void JSEXTTextureFilterAnisotropicPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTTextureFilterAnisotropic::info(), JSEXTTextureFilterAnisotropicPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTTextureFilterAnisotropic::s_info = { "EXTTextureFilterAnisotropic"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureFilterAnisotropic) };

JSEXTTextureFilterAnisotropic::JSEXTTextureFilterAnisotropic(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTTextureFilterAnisotropic>&& impl)
    : JSDOMWrapper<EXTTextureFilterAnisotropic>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTTextureFilterAnisotropic>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTTextureFilterAnisotropic::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTTextureFilterAnisotropicPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTTextureFilterAnisotropicPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTTextureFilterAnisotropic::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTTextureFilterAnisotropic>(vm, globalObject);
}

void JSEXTTextureFilterAnisotropic::destroy(JSC::JSCell* cell)
{
    JSEXTTextureFilterAnisotropic* thisObject = static_cast<JSEXTTextureFilterAnisotropic*>(cell);
    thisObject->JSEXTTextureFilterAnisotropic::~JSEXTTextureFilterAnisotropic();
}

JSC::GCClient::IsoSubspace* JSEXTTextureFilterAnisotropic::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTTextureFilterAnisotropic, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTTextureFilterAnisotropic.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTTextureFilterAnisotropic = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTTextureFilterAnisotropic.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTTextureFilterAnisotropic = std::forward<decltype(space)>(space); }
    );
}

void JSEXTTextureFilterAnisotropic::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTTextureFilterAnisotropic*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTTextureFilterAnisotropicOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTTextureFilterAnisotropic = jsCast<JSEXTTextureFilterAnisotropic*>(handle.slot()->asCell());
    auto& owner = jsEXTTextureFilterAnisotropic->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTTextureFilterAnisotropic"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTTextureFilterAnisotropicOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTTextureFilterAnisotropic = static_cast<JSEXTTextureFilterAnisotropic*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTTextureFilterAnisotropic->protectedWrapped().ptr(), jsEXTTextureFilterAnisotropic);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTTextureFilterAnisotropic@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27EXTTextureFilterAnisotropicE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, EXTTextureFilterAnisotropic>, void>> static inline void verifyVTable(EXTTextureFilterAnisotropic* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTTextureFilterAnisotropic@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27EXTTextureFilterAnisotropicE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTTextureFilterAnisotropic has subclasses. If EXTTextureFilterAnisotropic has subclasses that get passed
        // to toJS() we currently require EXTTextureFilterAnisotropic you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTTextureFilterAnisotropic>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTTextureFilterAnisotropic>(impl.ptr());
#endif
    return createWrapper<EXTTextureFilterAnisotropic>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTTextureFilterAnisotropic& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTTextureFilterAnisotropic* JSEXTTextureFilterAnisotropic::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTTextureFilterAnisotropic*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
