/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMImplementation.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentType.h"
#include "JSHTMLDocument.h"
#include "JSXMLDocument.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_createDocumentType);
static JSC_DECLARE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_createDocument);
static JSC_DECLARE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_createHTMLDocument);
static JSC_DECLARE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_hasFeature);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMImplementationConstructor);

class JSDOMImplementationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMImplementationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMImplementationPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMImplementationPrototype>(vm)) JSDOMImplementationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMImplementationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMImplementationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMImplementationPrototype, JSDOMImplementationPrototype::Base);

using JSDOMImplementationDOMConstructor = JSDOMConstructorNotConstructable<JSDOMImplementation>;

template<> const ClassInfo JSDOMImplementationDOMConstructor::s_info = { "DOMImplementation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMImplementationDOMConstructor) };

template<> JSValue JSDOMImplementationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMImplementationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMImplementation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMImplementation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDOMImplementationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMImplementationConstructor, 0 } },
    { "createDocumentType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMImplementationPrototypeFunction_createDocumentType, 3 } },
    { "createDocument"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMImplementationPrototypeFunction_createDocument, 2 } },
    { "createHTMLDocument"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMImplementationPrototypeFunction_createHTMLDocument, 0 } },
    { "hasFeature"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMImplementationPrototypeFunction_hasFeature, 0 } },
};

const ClassInfo JSDOMImplementationPrototype::s_info = { "DOMImplementation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMImplementationPrototype) };

void JSDOMImplementationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMImplementation::info(), JSDOMImplementationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMImplementation::s_info = { "DOMImplementation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMImplementation) };

JSDOMImplementation::JSDOMImplementation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMImplementation>&& impl)
    : JSDOMWrapper<DOMImplementation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMImplementation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMImplementation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMImplementationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMImplementationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMImplementation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMImplementation>(vm, globalObject);
}

JSValue JSDOMImplementation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMImplementationDOMConstructor, DOMConstructorID::DOMImplementation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMImplementation::destroy(JSC::JSCell* cell)
{
    JSDOMImplementation* thisObject = static_cast<JSDOMImplementation*>(cell);
    thisObject->JSDOMImplementation::~JSDOMImplementation();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMImplementationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMImplementationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMImplementation::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunction_createDocumentTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto qualifiedNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(qualifiedNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto publicIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(publicIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto systemIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(systemIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DocumentType>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDocumentType(qualifiedNameConversionResult.releaseReturnValue(), publicIdConversionResult.releaseReturnValue(), systemIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_createDocumentType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunction_createDocumentTypeBody>(*lexicalGlobalObject, *callFrame, "createDocumentType");
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunction_createDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURIConversionResult = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(namespaceURIConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto qualifiedNameConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(qualifiedNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto doctypeConversionResult = convert<IDLNullable<IDLInterface<DocumentType>>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "doctype"_s, "DOMImplementation"_s, "createDocument"_s, "DocumentType"_s); });
    if (UNLIKELY(doctypeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<XMLDocument>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDocument(namespaceURIConversionResult.releaseReturnValue(), qualifiedNameConversionResult.releaseReturnValue(), doctypeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_createDocument, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunction_createDocumentBody>(*lexicalGlobalObject, *callFrame, "createDocument");
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunction_createHTMLDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto titleConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (UNLIKELY(titleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<HTMLDocument>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createHTMLDocument(titleConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_createHTMLDocument, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunction_createHTMLDocumentBody>(*lexicalGlobalObject, *callFrame, "createHTMLDocument");
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunction_hasFeatureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasFeature())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMImplementationPrototypeFunction_hasFeature, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunction_hasFeatureBody>(*lexicalGlobalObject, *callFrame, "hasFeature");
}

JSC::GCClient::IsoSubspace* JSDOMImplementation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMImplementation, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMImplementation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMImplementation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMImplementation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMImplementation = std::forward<decltype(space)>(space); }
    );
}

void JSDOMImplementation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMImplementation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMImplementationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsDOMImplementation = jsCast<JSDOMImplementation*>(handle.slot()->asCell());
    Document* owner = WTF::getPtr(jsDOMImplementation->wrapped().document());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Document"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSDOMImplementationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMImplementation = static_cast<JSDOMImplementation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMImplementation->protectedWrapped().ptr(), jsDOMImplementation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMImplementation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17DOMImplementationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, DOMImplementation>, void>> static inline void verifyVTable(DOMImplementation* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMImplementation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17DOMImplementationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMImplementation has subclasses. If DOMImplementation has subclasses that get passed
        // to toJS() we currently require DOMImplementation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMImplementation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMImplementation>(impl.ptr());
#endif
    return createWrapper<DOMImplementation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMImplementation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMImplementation* JSDOMImplementation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMImplementation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
