/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchRegistration.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBackgroundFetchFailureReason.h"
#include "JSBackgroundFetchRecord.h"
#include "JSBackgroundFetchResult.h"
#include "JSCacheQueryOptions.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSFetchRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchRegistrationPrototypeFunction_abort);
static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchRegistrationPrototypeFunction_match);
static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchRegistrationPrototypeFunction_matchAll);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistrationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_id);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_uploadTotal);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_uploaded);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_downloadTotal);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_downloaded);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_result);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_failureReason);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_recordsAvailable);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRegistration_onprogress);
static JSC_DECLARE_CUSTOM_SETTER(setJSBackgroundFetchRegistration_onprogress);

class JSBackgroundFetchRegistrationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBackgroundFetchRegistrationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBackgroundFetchRegistrationPrototype* ptr = new (NotNull, JSC::allocateCell<JSBackgroundFetchRegistrationPrototype>(vm)) JSBackgroundFetchRegistrationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchRegistrationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBackgroundFetchRegistrationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchRegistrationPrototype, JSBackgroundFetchRegistrationPrototype::Base);

using JSBackgroundFetchRegistrationDOMConstructor = JSDOMConstructorNotConstructable<JSBackgroundFetchRegistration>;

template<> const ClassInfo JSBackgroundFetchRegistrationDOMConstructor::s_info = { "BackgroundFetchRegistration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchRegistrationDOMConstructor) };

template<> JSValue JSBackgroundFetchRegistrationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSBackgroundFetchRegistrationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BackgroundFetchRegistration"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBackgroundFetchRegistration::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSBackgroundFetchRegistrationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistrationConstructor, 0 } },
    { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_id, 0 } },
    { "uploadTotal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_uploadTotal, 0 } },
    { "uploaded"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_uploaded, 0 } },
    { "downloadTotal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_downloadTotal, 0 } },
    { "downloaded"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_downloaded, 0 } },
    { "result"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_result, 0 } },
    { "failureReason"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_failureReason, 0 } },
    { "recordsAvailable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_recordsAvailable, 0 } },
    { "onprogress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRegistration_onprogress, setJSBackgroundFetchRegistration_onprogress } },
    { "abort"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchRegistrationPrototypeFunction_abort, 0 } },
    { "match"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchRegistrationPrototypeFunction_match, 1 } },
    { "matchAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchRegistrationPrototypeFunction_matchAll, 0 } },
};

const ClassInfo JSBackgroundFetchRegistrationPrototype::s_info = { "BackgroundFetchRegistration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchRegistrationPrototype) };

void JSBackgroundFetchRegistrationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBackgroundFetchRegistration::info(), JSBackgroundFetchRegistrationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBackgroundFetchRegistration::s_info = { "BackgroundFetchRegistration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchRegistration) };

JSBackgroundFetchRegistration::JSBackgroundFetchRegistration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BackgroundFetchRegistration>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<BackgroundFetchRegistration> JSBackgroundFetchRegistration::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, BackgroundFetchRegistration>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSBackgroundFetchRegistration::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBackgroundFetchRegistrationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSBackgroundFetchRegistrationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBackgroundFetchRegistration::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBackgroundFetchRegistration>(vm, globalObject);
}

JSValue JSBackgroundFetchRegistration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBackgroundFetchRegistrationDOMConstructor, DOMConstructorID::BackgroundFetchRegistration>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistrationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBackgroundFetchRegistrationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBackgroundFetchRegistration::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsBackgroundFetchRegistration_idGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_uploadTotalGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.uploadTotal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_uploadTotal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_uploadTotalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_uploadedGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.uploaded())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_uploaded, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_uploadedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_downloadTotalGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.downloadTotal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_downloadTotal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_downloadTotalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_downloadedGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.downloaded())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_downloaded, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_downloadedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_resultGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<BackgroundFetchResult>>(lexicalGlobalObject, throwScope, impl.result())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_result, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_resultGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_failureReasonGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<BackgroundFetchFailureReason>>(lexicalGlobalObject, throwScope, impl.failureReason())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_failureReason, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_failureReasonGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_recordsAvailableGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.recordsAvailable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_recordsAvailable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_recordsAvailableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRegistration_onprogressGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRegistration_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::get<jsBackgroundFetchRegistration_onprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSBackgroundFetchRegistration_onprogressSetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRegistration& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().progressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSBackgroundFetchRegistration_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRegistration>::set<setJSBackgroundFetchRegistration_onprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsBackgroundFetchRegistrationPrototypeFunction_abortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.abort(*context, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchRegistrationPrototypeFunction_abort, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchRegistration>::call<jsBackgroundFetchRegistrationPrototypeFunction_abortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

static inline JSC::EncodedJSValue jsBackgroundFetchRegistrationPrototypeFunction_matchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto requestConversionResult = convert<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(requestConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<CacheQueryOptions>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<BackgroundFetchRecord>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.match(*context, requestConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchRegistrationPrototypeFunction_match, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchRegistration>::call<jsBackgroundFetchRegistrationPrototypeFunction_matchBody>(*lexicalGlobalObject, *callFrame, "match");
}

static inline JSC::EncodedJSValue jsBackgroundFetchRegistrationPrototypeFunction_matchAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto requestConversionResult = convert<IDLOptional<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(requestConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<CacheQueryOptions>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLInterface<BackgroundFetchRecord>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.matchAll(*context, requestConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchRegistrationPrototypeFunction_matchAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchRegistration>::call<jsBackgroundFetchRegistrationPrototypeFunction_matchAllBody>(*lexicalGlobalObject, *callFrame, "matchAll");
}

JSC::GCClient::IsoSubspace* JSBackgroundFetchRegistration::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBackgroundFetchRegistration, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBackgroundFetchRegistration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBackgroundFetchRegistration = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBackgroundFetchRegistration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBackgroundFetchRegistration = std::forward<decltype(space)>(space); }
    );
}

void JSBackgroundFetchRegistration::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBackgroundFetchRegistration*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSBackgroundFetchRegistrationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsBackgroundFetchRegistration = jsCast<JSBackgroundFetchRegistration*>(handle.slot()->asCell());
    auto& wrapped = jsBackgroundFetchRegistration->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSBackgroundFetchRegistrationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBackgroundFetchRegistration = static_cast<JSBackgroundFetchRegistration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsBackgroundFetchRegistration->protectedWrapped().ptr(), jsBackgroundFetchRegistration);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BackgroundFetchRegistration@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27BackgroundFetchRegistrationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, BackgroundFetchRegistration>, void>> static inline void verifyVTable(BackgroundFetchRegistration* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BackgroundFetchRegistration@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27BackgroundFetchRegistrationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BackgroundFetchRegistration has subclasses. If BackgroundFetchRegistration has subclasses that get passed
        // to toJS() we currently require BackgroundFetchRegistration you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BackgroundFetchRegistration>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<BackgroundFetchRegistration>(impl.ptr());
#endif
    return createWrapper<BackgroundFetchRegistration>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BackgroundFetchRegistration& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

BackgroundFetchRegistration* JSBackgroundFetchRegistration::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBackgroundFetchRegistration*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
