/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerGlobalScope.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSBarcodeDetector.h"
#include "JSBlob.h"
#include "JSBroadcastChannel.h"
#include "JSCSSColor.h"
#include "JSCSSColorValue.h"
#include "JSCSSHSL.h"
#include "JSCSSHWB.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSLCH.h"
#include "JSCSSLab.h"
#include "JSCSSMathClamp.h"
#include "JSCSSMathInvert.h"
#include "JSCSSMathMax.h"
#include "JSCSSMathMin.h"
#include "JSCSSMathNegate.h"
#include "JSCSSMathProduct.h"
#include "JSCSSMathSum.h"
#include "JSCSSMathValue.h"
#include "JSCSSMatrixComponent.h"
#include "JSCSSNumericArray.h"
#include "JSCSSNumericValue.h"
#include "JSCSSOKLCH.h"
#include "JSCSSOKLab.h"
#include "JSCSSOMVariableReferenceValue.h"
#include "JSCSSPerspective.h"
#include "JSCSSRGB.h"
#include "JSCSSRotate.h"
#include "JSCSSScale.h"
#include "JSCSSSkew.h"
#include "JSCSSSkewX.h"
#include "JSCSSSkewY.h"
#include "JSCSSStyleImageValue.h"
#include "JSCSSStyleValue.h"
#include "JSCSSTransformComponent.h"
#include "JSCSSTransformValue.h"
#include "JSCSSTranslate.h"
#include "JSCSSUnitValue.h"
#include "JSCSSUnparsedValue.h"
#include "JSCanvasGradient.h"
#include "JSCanvasPattern.h"
#include "JSCloseEvent.h"
#include "JSCrypto.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMCache.h"
#include "JSDOMCacheStorage.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertScheduledAction.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMException.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixReadOnly.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMPoint.h"
#include "JSDOMPointReadOnly.h"
#include "JSDOMQuad.h"
#include "JSDOMRect.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMStringList.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecationReportBody.h"
#include "JSErrorHandler.h"
#include "JSEventListener.h"
#include "JSEventSource.h"
#include "JSFaceDetector.h"
#include "JSFetchHeaders.h"
#include "JSFetchRequest.h"
#include "JSFetchRequestInit.h"
#include "JSFetchResponse.h"
#include "JSFile.h"
#include "JSFileList.h"
#include "JSFileReader.h"
#include "JSFileSystemDirectoryHandle.h"
#include "JSFileSystemFileHandle.h"
#include "JSFileSystemHandle.h"
#include "JSFontFace.h"
#include "JSFontFaceSet.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSIDBCursor.h"
#include "JSIDBCursorWithValue.h"
#include "JSIDBDatabase.h"
#include "JSIDBFactory.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBOpenDBRequest.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "JSIDBVersionChangeEvent.h"
#include "JSImageBitmap.h"
#include "JSImageBitmapOptions.h"
#include "JSImageBitmapRenderingContext.h"
#include "JSImageData.h"
#include "JSMessageEvent.h"
#include "JSMessagePort.h"
#include "JSPath2D.h"
#include "JSPerformance.h"
#include "JSPermissions.h"
#include "JSProgressEvent.h"
#include "JSReport.h"
#include "JSReportBody.h"
#include "JSReportingObserver.h"
#include "JSSecurityPolicyViolationEvent.h"
#include "JSStorageManager.h"
#include "JSStructuredSerializeOptions.h"
#include "JSStylePropertyMapReadOnly.h"
#include "JSTextDecoderStreamDecoder.h"
#include "JSTextDetector.h"
#include "JSTextEncoderStreamEncoder.h"
#include "JSTextMetrics.h"
#include "JSWebLock.h"
#include "JSWebLockManager.h"
#include "JSWebSocket.h"
#include "JSWorkerGlobalScope.h"
#include "JSWorkerLocation.h"
#include "JSWorkerNavigator.h"
#include "JSXMLHttpRequestEventTarget.h"
#include "JSXMLHttpRequestUpload.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WindowOrWorkerGlobalScopeCaches.h"
#include "WindowOrWorkerGlobalScopeFetch.h"
#include "WindowOrWorkerGlobalScopeIndexedDatabase.h"
#include "WorkerGlobalScope.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(CHANNEL_MESSAGING)
#include "JSMessageChannel.h"
#endif

#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
#include "JSOffscreenCanvas.h"
#include "JSOffscreenCanvasRenderingContext2D.h"
#endif

#if ENABLE(SERVICE_WORKER)
#include "JSBackgroundFetchManager.h"
#include "JSBackgroundFetchRecord.h"
#include "JSBackgroundFetchRegistration.h"
#include "JSBackgroundFetchUpdateUIEvent.h"
#include "JSNavigationPreloadManager.h"
#include "JSPushManager.h"
#include "JSPushSubscription.h"
#include "JSPushSubscriptionOptions.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerContainer.h"
#include "JSServiceWorkerRegistration.h"
#endif

#if ENABLE(VIDEO)
#include "JSAudioTrackConfiguration.h"
#include "JSVideoColorSpace.h"
#include "JSVideoTrackConfiguration.h"
#endif

#if ENABLE(WEBGL)
#include "JSWebGL2RenderingContext.h"
#include "JSWebGLActiveInfo.h"
#include "JSWebGLBuffer.h"
#include "JSWebGLContextEvent.h"
#include "JSWebGLFramebuffer.h"
#include "JSWebGLProgram.h"
#include "JSWebGLQuery.h"
#include "JSWebGLRenderbuffer.h"
#include "JSWebGLRenderingContext.h"
#include "JSWebGLSampler.h"
#include "JSWebGLShader.h"
#include "JSWebGLShaderPrecisionFormat.h"
#include "JSWebGLSync.h"
#include "JSWebGLTexture.h"
#include "JSWebGLTransformFeedback.h"
#include "JSWebGLUniformLocation.h"
#include "JSWebGLVertexArrayObject.h"
#endif

#if ENABLE(WEB_CRYPTO)
#include "JSCryptoKey.h"
#include "JSSubtleCrypto.h"
#endif

#if ENABLE(WEB_RTC)
#include "JSRTCDataChannel.h"
#include "JSRTCTransformEvent.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_importScripts);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_reportError);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_atob);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_btoa);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_setTimeout);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_clearTimeout);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_setInterval);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_clearInterval);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_queueMicrotask);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_createImageBitmap);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_structuredClone);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_fetch);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_self);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_location);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_navigator);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_onoffline);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_onoffline);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ononline);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_ononline);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_onrejectionhandled);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_onrejectionhandled);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_onunhandledrejection);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_onunhandledrejection);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BarcodeDetectorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FaceDetectorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_TextDetectorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CacheConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CacheStorageConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_HeadersConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_RequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ResponseConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FileSystemDirectoryHandleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FileSystemFileHandleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FileSystemHandleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBCursorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBCursorWithValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBDatabaseConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBFactoryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBIndexConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBKeyRangeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBObjectStoreConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBOpenDBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBTransactionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBVersionChangeEventConstructor);
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_RTCDataChannelConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_RTCTransformEventConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_PermissionsConstructor);
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_PushManagerConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_PushSubscriptionConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_PushSubscriptionOptionsConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DeprecationReportBodyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ReportConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ReportBodyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ReportingObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_StorageManagerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_LockConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_LockManagerConstructor);
#if ENABLE(VIDEO)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_VideoColorSpaceConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CloseEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebSocketConstructor);
#if ENABLE(WEB_CRYPTO)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CryptoKeyConstructor);
#endif
#if ENABLE(WEB_CRYPTO)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_SubtleCryptoConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMMatrixConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMMatrixReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FontFaceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FontFaceSetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSKeywordValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSNumericValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSVariableReferenceValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSImageValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSStyleValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSUnitValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSUnparsedValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_StylePropertyMapReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSColorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSColorValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSHSLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSHWBConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSLCHConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSLabConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSOKLCHConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSOKLabConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSRGBConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathClampConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathInvertConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathMaxConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathMinConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathNegateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathProductConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathSumConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSNumericArrayConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMatrixComponentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSPerspectiveConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSRotateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSScaleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSSkewConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSSkewXConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSSkewYConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSTransformComponentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSTransformValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSTranslateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BroadcastChannelConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMExceptionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMPointConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMPointReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMQuadConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMRectConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMRectReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMStringListConstructor);
#if ENABLE(CHANNEL_MESSAGING)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_MessageChannelConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_MessageEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_MessagePortConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ProgressEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_SecurityPolicyViolationEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_TextDecoderStreamDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_TextEncoderStreamEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BlobConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FileConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FileListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FileReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_FormDataConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ImageBitmapConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ImageDataConstructor);
#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_OffscreenCanvasConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_TextMetricsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CanvasGradientConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CanvasPatternConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ImageBitmapRenderingContextConstructor);
#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_OffscreenCanvasRenderingContext2DConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_Path2DConstructor);
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGL2RenderingContextConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLActiveInfoConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLBufferConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLContextEventConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLFramebufferConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLProgramConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLQueryConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLRenderbufferConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLRenderingContextConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLSamplerConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLShaderConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLShaderPrecisionFormatConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLSyncConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLTextureConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLTransformFeedbackConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLUniformLocationConstructor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLVertexArrayObjectConstructor);
#endif
#if ENABLE(VIDEO)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_AudioTrackConfigurationConstructor);
#endif
#if ENABLE(VIDEO)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_VideoTrackConfigurationConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_CryptoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_EventSourceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WorkerNavigatorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_WorkerLocationConstructor);
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_NavigationPreloadManagerConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ServiceWorkerConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ServiceWorkerContainerConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_ServiceWorkerRegistrationConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchManagerConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchRecordConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchRegistrationConstructor);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchUpdateUIEventConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_XMLHttpRequestEventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_XMLHttpRequestUploadConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_fonts);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_origin);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_origin);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_isSecureContext);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_crossOriginIsolated);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_caches);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_indexedDB);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_crypto);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerGlobalScope_performance);
static JSC_DECLARE_CUSTOM_SETTER(setJSWorkerGlobalScope_performance);

using JSWorkerGlobalScopeDOMConstructor = JSDOMConstructorNotConstructable<JSWorkerGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSWorkerGlobalScopeTableIndex[131] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 8, -1 },
    { 2, -1 },
    { -1, -1 },
    { 29, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 17, -1 },
    { -1, -1 },
    { 18, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 32, -1 },
    { 30, -1 },
    { 16, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 20, -1 },
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { 34, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 26, -1 },
    { 13, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 5, -1 },
    { -1, -1 },
    { 27, -1 },
    { 1, -1 },
    { 6, -1 },
    { 23, -1 },
    { -1, -1 },
    { 28, -1 },
    { 24, -1 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 14, 130 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 31, -1 },
    { 38, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 36, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, 129 },
    { -1, -1 },
    { -1, -1 },
    { 22, 128 },
    { 7, -1 },
    { 10, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 25, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 33, -1 },
    { 35, -1 },
    { 37, -1 },
};


static const HashTableValue JSWorkerGlobalScopeTableValues[] =
{
    { "Headers"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_HeadersConstructor, 0 } },
#if ENABLE(VIDEO)
    { "VideoColorSpace"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_VideoColorSpaceConstructor, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "CloseEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_CloseEventConstructor, 0 } },
    { "DOMMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMMatrixConstructor, 0 } },
    { "DOMMatrixReadOnly"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMMatrixReadOnlyConstructor, 0 } },
    { "FontFace"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_FontFaceConstructor, 0 } },
    { "FontFaceSet"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_FontFaceSetConstructor, 0 } },
    { "DOMException"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMExceptionConstructor, 0 } },
    { "DOMPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMPointConstructor, 0 } },
    { "DOMPointReadOnly"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMPointReadOnlyConstructor, 0 } },
    { "DOMQuad"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMQuadConstructor, 0 } },
    { "DOMRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMRectConstructor, 0 } },
    { "DOMRectReadOnly"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMRectReadOnlyConstructor, 0 } },
    { "DOMStringList"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_DOMStringListConstructor, 0 } },
#if ENABLE(CHANNEL_MESSAGING)
    { "MessageChannel"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_MessageChannelConstructor, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "MessageEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_MessageEventConstructor, 0 } },
    { "MessagePort"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_MessagePortConstructor, 0 } },
    { "ProgressEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_ProgressEventConstructor, 0 } },
    { "SecurityPolicyViolationEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_SecurityPolicyViolationEventConstructor, 0 } },
    { "Blob"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_BlobConstructor, 0 } },
    { "File"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_FileConstructor, 0 } },
    { "FileList"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_FileListConstructor, 0 } },
    { "FormData"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_FormDataConstructor, 0 } },
    { "ImageBitmap"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_ImageBitmapConstructor, 0 } },
    { "ImageData"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_ImageDataConstructor, 0 } },
    { "TextMetrics"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_TextMetricsConstructor, 0 } },
    { "CanvasGradient"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_CanvasGradientConstructor, 0 } },
    { "CanvasPattern"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_CanvasPatternConstructor, 0 } },
    { "ImageBitmapRenderingContext"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_ImageBitmapRenderingContextConstructor, 0 } },
    { "Path2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_Path2DConstructor, 0 } },
#if ENABLE(VIDEO)
    { "AudioTrackConfiguration"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_AudioTrackConfigurationConstructor, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(VIDEO)
    { "VideoTrackConfiguration"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_VideoTrackConfigurationConstructor, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "Crypto"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_CryptoConstructor, 0 } },
    { "EventSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_EventSourceConstructor, 0 } },
    { "WorkerNavigator"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_WorkerNavigatorConstructor, 0 } },
    { "WorkerGlobalScope"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_WorkerGlobalScopeConstructor, 0 } },
    { "WorkerLocation"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_WorkerLocationConstructor, 0 } },
    { "XMLHttpRequestEventTarget"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_XMLHttpRequestEventTargetConstructor, 0 } },
    { "XMLHttpRequestUpload"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_XMLHttpRequestUploadConstructor, 0 } },
};

static const HashTable JSWorkerGlobalScopeTable = { 39, 127, static_cast<uint8_t>(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)), JSWorkerGlobalScope::info(), JSWorkerGlobalScopeTableValues, JSWorkerGlobalScopeTableIndex };
template<> const ClassInfo JSWorkerGlobalScopeDOMConstructor::s_info = { "WorkerGlobalScope"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerGlobalScopeDOMConstructor) };

template<> JSValue JSWorkerGlobalScopeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWorkerGlobalScopeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WorkerGlobalScope"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWorkerGlobalScope::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const struct CompactHashIndex JSWorkerGlobalScopePrototypeTableIndex[71] = {
    { 12, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 10, 64 },
    { -1, -1 },
    { 26, -1 },
    { -1, -1 },
    { 5, -1 },
    { -1, -1 },
    { 22, -1 },
    { 7, 67 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 1, 66 },
    { 15, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, 69 },
    { -1, -1 },
    { 4, 68 },
    { 16, -1 },
    { 2, 65 },
    { -1, -1 },
    { 14, 70 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 6, -1 },
    { 17, -1 },
    { -1, -1 },
    { -1, -1 },
    { 23, -1 },
    { -1, -1 },
    { -1, -1 },
    { 24, -1 },
    { -1, -1 },
    { -1, -1 },
    { 13, -1 },
    { 18, -1 },
    { 19, -1 },
    { 20, -1 },
    { 25, -1 },
    { 27, -1 },
    { 28, -1 },
};


static const HashTableValue JSWorkerGlobalScopePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScopeConstructor, 0 } },
    { "self"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_self, 0 } },
    { "location"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_location, 0 } },
    { "navigator"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_navigator, 0 } },
    { "onerror"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_onerror, setJSWorkerGlobalScope_onerror } },
    { "onoffline"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_onoffline, setJSWorkerGlobalScope_onoffline } },
    { "ononline"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_ononline, setJSWorkerGlobalScope_ononline } },
    { "onrejectionhandled"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_onrejectionhandled, setJSWorkerGlobalScope_onrejectionhandled } },
    { "onunhandledrejection"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_onunhandledrejection, setJSWorkerGlobalScope_onunhandledrejection } },
    { "fonts"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_fonts, 0 } },
    { "origin"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_origin, setJSWorkerGlobalScope_origin } },
    { "isSecureContext"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_isSecureContext, 0 } },
    { "crossOriginIsolated"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_crossOriginIsolated, 0 } },
    { "caches"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_caches, 0 } },
    { "indexedDB"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_indexedDB, 0 } },
    { "crypto"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_crypto, 0 } },
    { "performance"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerGlobalScope_performance, setJSWorkerGlobalScope_performance } },
    { "importScripts"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_importScripts, 0 } },
    { "reportError"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_reportError, 1 } },
    { "atob"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_atob, 1 } },
    { "btoa"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_btoa, 1 } },
    { "setTimeout"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_setTimeout, 1 } },
    { "clearTimeout"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_clearTimeout, 0 } },
    { "setInterval"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_setInterval, 1 } },
    { "clearInterval"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_clearInterval, 0 } },
    { "queueMicrotask"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_queueMicrotask, 1 } },
    { "createImageBitmap"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_createImageBitmap, 1 } },
    { "structuredClone"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_structuredClone, 1 } },
    { "fetch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerGlobalScopePrototypeFunction_fetch, 1 } },
};

static const HashTable JSWorkerGlobalScopePrototypeTable = { 29, 63, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::Function | JSC::PropertyAttribute::ReadOnly | PropertyAttribute::DontEnum), JSWorkerGlobalScope::info(), JSWorkerGlobalScopePrototypeTableValues, JSWorkerGlobalScopePrototypeTableIndex };
const ClassInfo JSWorkerGlobalScopePrototype::s_info = { "WorkerGlobalScope"_s, &Base::s_info, &JSWorkerGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSWorkerGlobalScopePrototype) };

void JSWorkerGlobalScopePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWorkerGlobalScope::info(), JSWorkerGlobalScopePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fetchAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fetch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().crossOriginOpenerPolicyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "crossOriginIsolated"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cacheAPIEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "caches"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "indexedDB"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWorkerGlobalScope::s_info = { "WorkerGlobalScope"_s, &Base::s_info, &JSWorkerGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSWorkerGlobalScope) };

JSWorkerGlobalScope::JSWorkerGlobalScope(VM& vm, Structure* structure, Ref<WorkerGlobalScope>&& impl)
    : JSWorkerGlobalScopeBase(vm, structure, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WorkerGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSWorkerGlobalScope::finishCreation(VM& vm, JSGlobalProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().shapeDetection))
        putDirectCustomAccessor(vm, builtinNames(vm).BarcodeDetectorPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_BarcodeDetectorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().shapeDetection))
        putDirectCustomAccessor(vm, builtinNames(vm).FaceDetectorPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_FaceDetectorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().shapeDetection))
        putDirectCustomAccessor(vm, builtinNames(vm).TextDetectorPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_TextDetectorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cacheAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CachePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CacheConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cacheAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CacheStoragePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CacheStorageConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fetchAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RequestPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_RequestConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fetchAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ResponsePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ResponseConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileSystemAccessEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).FileSystemDirectoryHandlePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_FileSystemDirectoryHandleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileSystemAccessEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).FileSystemFileHandlePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_FileSystemFileHandleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileSystemAccessEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).FileSystemHandlePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_FileSystemHandleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBCursorPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBCursorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBCursorWithValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBCursorWithValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBDatabasePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBDatabaseConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBFactoryPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBFactoryConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBIndexPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBIndexConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBKeyRangePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBKeyRangeConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBObjectStorePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBObjectStoreConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBOpenDBRequestPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBOpenDBRequestConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBRequestPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBRequestConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBTransactionPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBTransactionConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().indexedDBAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).IDBVersionChangeEventPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_IDBVersionChangeEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().peerConnectionEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCDataChannelPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_RTCDataChannelConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCTransformEventPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_RTCTransformEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().permissionsAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PermissionsPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_PermissionsConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().pushAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).PushManagerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_PushManagerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().pushAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).PushSubscriptionPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_PushSubscriptionConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().pushAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).PushSubscriptionOptionsPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_PushSubscriptionOptionsConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().deprecationReportingEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DeprecationReportBodyPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_DeprecationReportBodyConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().reportingEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ReportPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ReportConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().reportingEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ReportBodyPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ReportBodyConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().reportingEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ReportingObserverPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ReportingObserverConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().storageAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).StorageManagerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_StorageManagerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webLocksAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).LockPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_LockConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webLocksAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).LockManagerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_LockManagerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webSocketEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebSocketPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebSocketConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_CRYPTO)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).CryptoKeyPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CryptoKeyConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CRYPTO)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).SubtleCryptoPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_SubtleCryptoConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSKeywordValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSKeywordValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSNumericValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSNumericValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSVariableReferenceValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSVariableReferenceValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSImageValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSImageValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSStyleValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSStyleValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSUnitValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSUnitValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSUnparsedValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSUnparsedValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).StylePropertyMapReadOnlyPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_StylePropertyMapReadOnlyConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSColorPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSColorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSColorValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSColorValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSHSLPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSHSLConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSHWBPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSHWBConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSLCHPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSLCHConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSLabPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSLabConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSOKLCHPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSOKLCHConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSOKLabPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSOKLabConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CSSRGBPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSRGBConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathClampPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathClampConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathInvertPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathInvertConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathMaxPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathMaxConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathMinPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathMinConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathNegatePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathNegateConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathProductPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathProductConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathSumPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathSumConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMathValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMathValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSNumericArrayPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSNumericArrayConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSMatrixComponentPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSMatrixComponentConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSPerspectivePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSPerspectiveConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSRotatePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSRotateConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSScalePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSScaleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSSkewPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSSkewConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSSkewXPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSSkewXConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSSkewYPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSSkewYConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSTransformComponentPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSTransformComponentConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSTransformValuePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSTransformValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSTranslatePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_CSSTranslateConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().broadcastChannelEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).BroadcastChannelPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_BroadcastChannelConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().transformStreamAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextDecoderStreamDecoderPrivateName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_TextDecoderStreamDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().transformStreamAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextEncoderStreamEncoderPrivateName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_TextEncoderStreamEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileReaderAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).FileReaderPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_FileReaderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().offscreenCanvasEnabled && OffscreenCanvas::enabledForContext(*jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())))
        putDirectCustomAccessor(vm, builtinNames(vm).OffscreenCanvasPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_OffscreenCanvasConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().offscreenCanvasEnabled && OffscreenCanvasRenderingContext2D::enabledForContext(*jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())))
        putDirectCustomAccessor(vm, builtinNames(vm).OffscreenCanvasRenderingContext2DPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_OffscreenCanvasRenderingContext2DConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGL2RenderingContextPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGL2RenderingContextConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLActiveInfoPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLActiveInfoConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLBufferPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLBufferConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLContextEventPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLContextEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLFramebufferPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLFramebufferConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLProgramPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLProgramConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLQueryPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLQueryConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLRenderbufferPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLRenderbufferConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLRenderingContextPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLRenderingContextConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLSamplerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLSamplerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLShaderPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLShaderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLShaderPrecisionFormatPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLShaderPrecisionFormatConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLSyncPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLSyncConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLTexturePublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLTextureConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLTransformFeedbackPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLTransformFeedbackConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLUniformLocationPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLUniformLocationConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGLEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).WebGLVertexArrayObjectPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_WebGLVertexArrayObjectConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkerNavigationPreloadEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).NavigationPreloadManagerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_NavigationPreloadManagerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).ServiceWorkerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ServiceWorkerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).ServiceWorkerContainerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ServiceWorkerContainerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).ServiceWorkerRegistrationPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_ServiceWorkerRegistrationConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().backgroundFetchAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).BackgroundFetchManagerPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_BackgroundFetchManagerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().backgroundFetchAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).BackgroundFetchRecordPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_BackgroundFetchRecordConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().backgroundFetchAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).BackgroundFetchRegistrationPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_BackgroundFetchRegistrationConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().backgroundFetchAPIEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).BackgroundFetchUpdateUIEventPublicName(), CustomGetterSetter::create(vm, jsWorkerGlobalScope_BackgroundFetchUpdateUIEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
}

JSObject* JSWorkerGlobalScope::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWorkerGlobalScopePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWorkerGlobalScopePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWorkerGlobalScope::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWorkerGlobalScope>(vm, globalObject);
}

JSValue JSWorkerGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerGlobalScopeDOMConstructor, DOMConstructorID::WorkerGlobalScope>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWorkerGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWorkerGlobalScope::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWorkerGlobalScope_selfGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WorkerGlobalScope>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.self())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_selfGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_locationGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WorkerLocation>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.location())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_location, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_locationGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_navigatorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WorkerNavigator>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.navigator())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_navigator, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_navigatorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_onerrorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSErrorHandler>(thisObject.wrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::set<setJSWorkerGlobalScope_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_onofflineGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().offlineEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_onoffline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_onofflineGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_onofflineSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().offlineEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_onoffline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::set<setJSWorkerGlobalScope_onofflineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ononlineGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().onlineEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ononline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ononlineGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_ononlineSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().onlineEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_ononline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::set<setJSWorkerGlobalScope_ononlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_onrejectionhandledGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().rejectionhandledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_onrejectionhandled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_onrejectionhandledGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_onrejectionhandledSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().rejectionhandledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_onrejectionhandled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::set<setJSWorkerGlobalScope_onrejectionhandledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_onunhandledrejectionGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().unhandledrejectionEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_onunhandledrejection, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_onunhandledrejectionGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_onunhandledrejectionSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().unhandledrejectionEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_onunhandledrejection, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::set<setJSWorkerGlobalScope_onunhandledrejectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_BarcodeDetectorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBarcodeDetector::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BarcodeDetectorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BarcodeDetectorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FaceDetectorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFaceDetector::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FaceDetectorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FaceDetectorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_TextDetectorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDetector::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_TextDetectorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_TextDetectorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CacheConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMCache::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CacheConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CacheConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CacheStorageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMCacheStorage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CacheStorageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CacheStorageConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_HeadersConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFetchHeaders::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_HeadersConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_HeadersConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_RequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFetchRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_RequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_RequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ResponseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFetchResponse::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ResponseConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ResponseConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FileSystemDirectoryHandleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileSystemDirectoryHandle::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FileSystemDirectoryHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FileSystemDirectoryHandleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FileSystemFileHandleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileSystemFileHandle::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FileSystemFileHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FileSystemFileHandleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FileSystemHandleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileSystemHandle::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FileSystemHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FileSystemHandleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBCursorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBCursor::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBCursorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBCursorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBCursorWithValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBCursorWithValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBCursorWithValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBCursorWithValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBDatabaseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBDatabase::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBDatabaseConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBDatabaseConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBFactoryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBFactory::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBFactoryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBFactoryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBIndexConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBIndex::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBIndexConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBIndexConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBKeyRangeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBKeyRange::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBKeyRangeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBKeyRangeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBObjectStoreConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBObjectStore::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBObjectStoreConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBObjectStoreConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBOpenDBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBOpenDBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBOpenDBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBOpenDBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBTransactionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBTransaction::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBTransactionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBTransactionConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_IDBVersionChangeEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSIDBVersionChangeEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_IDBVersionChangeEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_IDBVersionChangeEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_RTC)
static inline JSValue jsWorkerGlobalScope_RTCDataChannelConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCDataChannel::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_RTCDataChannelConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_RTCDataChannelConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsWorkerGlobalScope_RTCTransformEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCTransformEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_RTCTransformEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_RTCTransformEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_PermissionsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPermissions::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_PermissionsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_PermissionsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_PushManagerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPushManager::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_PushManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_PushManagerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_PushSubscriptionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPushSubscription::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_PushSubscriptionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_PushSubscriptionConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_PushSubscriptionOptionsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPushSubscriptionOptions::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_PushSubscriptionOptionsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_PushSubscriptionOptionsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_DeprecationReportBodyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDeprecationReportBody::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DeprecationReportBodyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DeprecationReportBodyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ReportConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReport::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ReportConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ReportConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ReportBodyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReportBody::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ReportBodyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ReportBodyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ReportingObserverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReportingObserver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ReportingObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ReportingObserverConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_StorageManagerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSStorageManager::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_StorageManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_StorageManagerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_LockConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebLock::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_LockConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_LockConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_LockManagerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebLockManager::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_LockManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_LockManagerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(VIDEO)
static inline JSValue jsWorkerGlobalScope_VideoColorSpaceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSVideoColorSpace::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_VideoColorSpaceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_VideoColorSpaceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_CloseEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCloseEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CloseEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CloseEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_WebSocketConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebSocket::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebSocketConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebSocketConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_CRYPTO)
static inline JSValue jsWorkerGlobalScope_CryptoKeyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCryptoKey::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CryptoKeyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CryptoKeyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CRYPTO)
static inline JSValue jsWorkerGlobalScope_SubtleCryptoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSSubtleCrypto::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_SubtleCryptoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_SubtleCryptoConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_DOMMatrixConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMMatrix::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMMatrixConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMMatrixConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMMatrixReadOnlyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMMatrixReadOnly::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMMatrixReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMMatrixReadOnlyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FontFaceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFontFace::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FontFaceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FontFaceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FontFaceSetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFontFaceSet::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FontFaceSetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FontFaceSetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSKeywordValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSKeywordValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSKeywordValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSKeywordValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSNumericValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSNumericValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSNumericValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSNumericValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSVariableReferenceValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSOMVariableReferenceValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSVariableReferenceValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSVariableReferenceValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSImageValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSStyleImageValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSImageValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSImageValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSStyleValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSStyleValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSStyleValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSStyleValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSUnitValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSUnitValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSUnitValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSUnitValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSUnparsedValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSUnparsedValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSUnparsedValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSUnparsedValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_StylePropertyMapReadOnlyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSStylePropertyMapReadOnly::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_StylePropertyMapReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_StylePropertyMapReadOnlyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSColorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSColor::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSColorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSColorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSColorValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSColorValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSColorValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSColorValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSHSLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSHSL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSHSLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSHSLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSHWBConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSHWB::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSHWBConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSHWBConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSLCHConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSLCH::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSLCHConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSLCHConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSLabConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSLab::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSLabConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSLabConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSOKLCHConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSOKLCH::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSOKLCHConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSOKLCHConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSOKLabConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSOKLab::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSOKLabConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSOKLabConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSRGBConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSRGB::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSRGBConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSRGBConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathClampConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathClamp::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathClampConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathClampConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathInvertConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathInvert::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathInvertConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathInvertConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathMaxConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathMax::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathMaxConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathMaxConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathMinConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathMin::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathMinConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathMinConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathNegateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathNegate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathNegateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathNegateConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathProductConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathProduct::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathProductConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathProductConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathSumConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathSum::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathSumConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathSumConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMathValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMathValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMathValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSNumericArrayConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSNumericArray::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSNumericArrayConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSNumericArrayConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSMatrixComponentConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMatrixComponent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSMatrixComponentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSMatrixComponentConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSPerspectiveConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSPerspective::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSPerspectiveConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSPerspectiveConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSRotateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSRotate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSRotateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSRotateConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSScaleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSScale::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSScaleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSScaleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSSkewConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSSkew::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSSkewConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSSkewConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSSkewXConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSSkewX::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSSkewXConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSSkewXConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSSkewYConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSSkewY::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSSkewYConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSSkewYConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSTransformComponentConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSTransformComponent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSTransformComponentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSTransformComponentConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSTransformValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSTransformValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSTransformValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSTransformValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CSSTranslateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSTranslate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CSSTranslateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CSSTranslateConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_BroadcastChannelConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBroadcastChannel::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BroadcastChannelConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BroadcastChannelConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMExceptionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMException::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMExceptionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMExceptionConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMPointConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMPoint::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMPointConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMPointConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMPointReadOnlyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMPointReadOnly::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMPointReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMPointReadOnlyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMQuadConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMQuad::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMQuadConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMQuadConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMRectConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMRect::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMRectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMRectConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMRectReadOnlyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMRectReadOnly::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMRectReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMRectReadOnlyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_DOMStringListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMStringList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_DOMStringListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_DOMStringListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(CHANNEL_MESSAGING)
static inline JSValue jsWorkerGlobalScope_MessageChannelConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMessageChannel::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_MessageChannelConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_MessageChannelConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_MessageEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMessageEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_MessageEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_MessageEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_MessagePortConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMessagePort::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_MessagePortConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_MessagePortConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ProgressEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSProgressEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ProgressEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ProgressEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_SecurityPolicyViolationEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSSecurityPolicyViolationEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_SecurityPolicyViolationEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_SecurityPolicyViolationEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_TextDecoderStreamDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoderStreamDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_TextDecoderStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_TextDecoderStreamDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_TextEncoderStreamEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoderStreamEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_TextEncoderStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_TextEncoderStreamEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_BlobConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBlob::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BlobConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BlobConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FileConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFile::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FileConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FileConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FileListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FileListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FileListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FileReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FileReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FileReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_FormDataConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMFormData::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_FormDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_FormDataConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ImageBitmapConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSImageBitmap::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ImageBitmapConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ImageBitmapConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ImageDataConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSImageData::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ImageDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ImageDataConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static inline JSValue jsWorkerGlobalScope_OffscreenCanvasConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSOffscreenCanvas::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_OffscreenCanvasConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_OffscreenCanvasConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_TextMetricsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextMetrics::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_TextMetricsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_TextMetricsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CanvasGradientConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCanvasGradient::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CanvasGradientConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CanvasGradientConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_CanvasPatternConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCanvasPattern::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CanvasPatternConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CanvasPatternConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_ImageBitmapRenderingContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSImageBitmapRenderingContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ImageBitmapRenderingContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ImageBitmapRenderingContextConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(OFFSCREEN_CANVAS) && ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static inline JSValue jsWorkerGlobalScope_OffscreenCanvasRenderingContext2DConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSOffscreenCanvasRenderingContext2D::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_OffscreenCanvasRenderingContext2DConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_OffscreenCanvasRenderingContext2DConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_Path2DConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPath2D::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_Path2DConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_Path2DConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGL2RenderingContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGL2RenderingContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGL2RenderingContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGL2RenderingContextConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLActiveInfoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLActiveInfo::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLActiveInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLActiveInfoConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLBufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLBufferConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLContextEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLContextEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLContextEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLContextEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLFramebufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLFramebuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLFramebufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLFramebufferConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLProgramConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLProgram::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLProgramConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLProgramConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLQueryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLQuery::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLQueryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLQueryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLRenderbufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLRenderbuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLRenderbufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLRenderbufferConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLRenderingContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLRenderingContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLRenderingContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLRenderingContextConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLSamplerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLSampler::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLSamplerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLSamplerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLShaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLShader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLShaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLShaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLShaderPrecisionFormatConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLShaderPrecisionFormat::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLShaderPrecisionFormatConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLShaderPrecisionFormatConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLSyncConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLSync::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLSyncConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLSyncConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLTextureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLTexture::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLTextureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLTextureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLTransformFeedbackConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLTransformFeedback::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLTransformFeedbackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLTransformFeedbackConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLUniformLocationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLUniformLocation::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLUniformLocationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLUniformLocationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWorkerGlobalScope_WebGLVertexArrayObjectConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebGLVertexArrayObject::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WebGLVertexArrayObjectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WebGLVertexArrayObjectConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(VIDEO)
static inline JSValue jsWorkerGlobalScope_AudioTrackConfigurationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAudioTrackConfiguration::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_AudioTrackConfigurationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_AudioTrackConfigurationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(VIDEO)
static inline JSValue jsWorkerGlobalScope_VideoTrackConfigurationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSVideoTrackConfiguration::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_VideoTrackConfigurationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_VideoTrackConfigurationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_CryptoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCrypto::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_CryptoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_CryptoConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_EventSourceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEventSource::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_EventSourceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_EventSourceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_WorkerNavigatorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWorkerNavigator::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WorkerNavigatorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WorkerNavigatorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_WorkerGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWorkerGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WorkerGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_WorkerLocationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWorkerLocation::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_WorkerLocationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_WorkerLocationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_NavigationPreloadManagerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSNavigationPreloadManager::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_NavigationPreloadManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_NavigationPreloadManagerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_ServiceWorkerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorker::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ServiceWorkerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ServiceWorkerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_ServiceWorkerContainerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerContainer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ServiceWorkerContainerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ServiceWorkerContainerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_ServiceWorkerRegistrationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerRegistration::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_ServiceWorkerRegistrationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_ServiceWorkerRegistrationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_BackgroundFetchManagerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBackgroundFetchManager::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BackgroundFetchManagerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_BackgroundFetchRecordConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBackgroundFetchRecord::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchRecordConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BackgroundFetchRecordConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_BackgroundFetchRegistrationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBackgroundFetchRegistration::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchRegistrationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BackgroundFetchRegistrationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerGlobalScope_BackgroundFetchUpdateUIEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSBackgroundFetchUpdateUIEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_BackgroundFetchUpdateUIEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_BackgroundFetchUpdateUIEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsWorkerGlobalScope_XMLHttpRequestEventTargetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSXMLHttpRequestEventTarget::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_XMLHttpRequestEventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_XMLHttpRequestEventTargetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_XMLHttpRequestUploadConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSXMLHttpRequestUpload::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_XMLHttpRequestUploadConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_XMLHttpRequestUploadConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_fontsGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<FontFaceSet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fonts())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_fonts, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_fontsGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_originGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.origin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_origin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_originGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_originSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_origin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::setPassingPropertyName<setJSWorkerGlobalScope_originSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_isSecureContextGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isSecureContext())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_isSecureContext, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_isSecureContextGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_crossOriginIsolatedGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.crossOriginIsolated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_crossOriginIsolated, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_crossOriginIsolatedGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_cachesGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMCacheStorage>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::WindowOrWorkerGlobalScopeCaches::caches(*context, impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_caches, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_cachesGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_indexedDBGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<IDBFactory>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::WindowOrWorkerGlobalScopeIndexedDatabase::indexedDB(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_indexedDB, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_indexedDBGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_cryptoGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Crypto>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.crypto())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_crypto, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_cryptoGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerGlobalScope_performanceGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Performance>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.performance())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerGlobalScope_performance, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::get<jsWorkerGlobalScope_performanceGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWorkerGlobalScope_performanceSetter(JSGlobalObject& lexicalGlobalObject, JSWorkerGlobalScope& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWorkerGlobalScope_performance, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerGlobalScope>::setPassingPropertyName<setJSWorkerGlobalScope_performanceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_importScriptsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto urls = convertVariadicArguments<IDLUSVString>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.importScripts(WTFMove(urls)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_importScripts, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_importScriptsBody>(*lexicalGlobalObject, *callFrame, "importScripts");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_reportErrorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto error = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reportError(*(*castedThis).globalObject(), WTFMove(error)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_reportError, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_reportErrorBody>(*lexicalGlobalObject, *callFrame, "reportError");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_atobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto string = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.atob(WTFMove(string)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_atob, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_atobBody>(*lexicalGlobalObject, *callFrame, "atob");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_btoaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto string = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.btoa(WTFMove(string)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_btoa, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_btoaBody>(*lexicalGlobalObject, *callFrame, "btoa");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_setTimeoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto handler = convert<IDLScheduledAction>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto timeout = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 2);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.setTimeout(WTFMove(handler), WTFMove(timeout), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_setTimeout, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_setTimeoutBody>(*lexicalGlobalObject, *callFrame, "setTimeout");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_clearTimeoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto handle = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearTimeout(WTFMove(handle)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_clearTimeout, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_clearTimeoutBody>(*lexicalGlobalObject, *callFrame, "clearTimeout");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_setIntervalBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto handler = convert<IDLScheduledAction>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto timeout = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 2);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.setInterval(WTFMove(handler), WTFMove(timeout), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_setInterval, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_setIntervalBody>(*lexicalGlobalObject, *callFrame, "setInterval");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_clearIntervalBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto handle = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearInterval(WTFMove(handle)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_clearInterval, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_clearIntervalBody>(*lexicalGlobalObject, *callFrame, "clearInterval");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_queueMicrotaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, (JSValue::encode(castedThis->queueMicrotask(*lexicalGlobalObject, *callFrame))));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_queueMicrotask, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_queueMicrotaskBody>(*lexicalGlobalObject, *callFrame, "queueMicrotask");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_createImageBitmap1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWorkerGlobalScope>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLVideoElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<Blob>, IDLInterface<ImageData>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<ImageBitmapOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<ImageBitmap>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createImageBitmap(WTFMove(image), WTFMove(options), WTFMove(promise)); })));
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_createImageBitmap2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWorkerGlobalScope>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLVideoElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<Blob>, IDLInterface<ImageData>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto sx = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto sy = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto sw = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto sh = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto options = convert<IDLDictionary<ImageBitmapOptions>>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<ImageBitmap>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createImageBitmap(WTFMove(image), WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh), WTFMove(options), WTFMove(promise)); })));
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_createImageBitmapOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWorkerGlobalScope>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(6, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsWorkerGlobalScopePrototypeFunction_createImageBitmap1Body(lexicalGlobalObject, callFrame, castedThis, WTFMove(promise))));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsWorkerGlobalScopePrototypeFunction_createImageBitmap1Body(lexicalGlobalObject, callFrame, castedThis, WTFMove(promise))));
    }
    if (argsCount == 5) {
        RELEASE_AND_RETURN(throwScope, (jsWorkerGlobalScopePrototypeFunction_createImageBitmap2Body(lexicalGlobalObject, callFrame, castedThis, WTFMove(promise))));
    }
    if (argsCount == 6) {
        RELEASE_AND_RETURN(throwScope, (jsWorkerGlobalScopePrototypeFunction_createImageBitmap2Body(lexicalGlobalObject, callFrame, castedThis, WTFMove(promise))));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_createImageBitmap, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_createImageBitmapOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "createImageBitmap");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_structuredCloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<StructuredSerializeOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.structuredClone(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *(*castedThis).globalObject(), WTFMove(value), WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_structuredClone, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_structuredCloneBody>(*lexicalGlobalObject, *callFrame, "structuredClone");
}

static inline JSC::EncodedJSValue jsWorkerGlobalScopePrototypeFunction_fetchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWorkerGlobalScope>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto input = convert<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto init = convert<IDLDictionary<FetchRequestInit>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<FetchResponse>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::WindowOrWorkerGlobalScopeFetch::fetch(impl, WTFMove(input), WTFMove(init), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerGlobalScopePrototypeFunction_fetch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWorkerGlobalScope>::call<jsWorkerGlobalScopePrototypeFunction_fetchBody>(*lexicalGlobalObject, *callFrame, "fetch");
}

JSC::GCClient::IsoSubspace* JSWorkerGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWorkerGlobalScope, UseCustomHeapCellType::Yes>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSWorkerGlobalScope; }
    );
}

template<typename Visitor>
void JSWorkerGlobalScope::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSWorkerGlobalScope);

template<typename Visitor>
void JSWorkerGlobalScope::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSWorkerGlobalScope::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSWorkerGlobalScope::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSWorkerGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

WorkerGlobalScope* JSWorkerGlobalScope::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWorkerGlobalScope*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
