/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(VIDEO)

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSTextTrackCue.h"
#include "VTTCue.h"

namespace WebCore {

class WEBCORE_EXPORT JSVTTCue : public JSTextTrackCue {
public:
    using Base = JSTextTrackCue;
    using DOMWrapped = VTTCue;
    static JSVTTCue* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<VTTCue>&& impl)
    {
        JSVTTCue* ptr = new (NotNull, JSC::allocateCell<JSVTTCue>(globalObject->vm())) JSVTTCue(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static VTTCue* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    VTTCue& wrapped() const
    {
        return static_cast<VTTCue&>(Base::wrapped());
    }
protected:
    JSVTTCue(JSC::Structure*, JSDOMGlobalObject&, Ref<VTTCue>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, VTTCue&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VTTCue* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<VTTCue>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<VTTCue>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<VTTCue> {
    using WrapperClass = JSVTTCue;
    using ToWrappedReturnType = VTTCue*;
};
String convertEnumerationToString(VTTCue::AutoKeyword);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, VTTCue::AutoKeyword);

template<> std::optional<VTTCue::AutoKeyword> parseEnumerationFromString<VTTCue::AutoKeyword>(const String&);
template<> std::optional<VTTCue::AutoKeyword> parseEnumeration<VTTCue::AutoKeyword>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<VTTCue::AutoKeyword>();

String convertEnumerationToString(VTTCue::DirectionSetting);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, VTTCue::DirectionSetting);

template<> std::optional<VTTCue::DirectionSetting> parseEnumerationFromString<VTTCue::DirectionSetting>(const String&);
template<> std::optional<VTTCue::DirectionSetting> parseEnumeration<VTTCue::DirectionSetting>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<VTTCue::DirectionSetting>();

String convertEnumerationToString(VTTCue::LineAlignSetting);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, VTTCue::LineAlignSetting);

template<> std::optional<VTTCue::LineAlignSetting> parseEnumerationFromString<VTTCue::LineAlignSetting>(const String&);
template<> std::optional<VTTCue::LineAlignSetting> parseEnumeration<VTTCue::LineAlignSetting>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<VTTCue::LineAlignSetting>();

String convertEnumerationToString(VTTCue::PositionAlignSetting);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, VTTCue::PositionAlignSetting);

template<> std::optional<VTTCue::PositionAlignSetting> parseEnumerationFromString<VTTCue::PositionAlignSetting>(const String&);
template<> std::optional<VTTCue::PositionAlignSetting> parseEnumeration<VTTCue::PositionAlignSetting>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<VTTCue::PositionAlignSetting>();

String convertEnumerationToString(VTTCue::AlignSetting);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, VTTCue::AlignSetting);

template<> std::optional<VTTCue::AlignSetting> parseEnumerationFromString<VTTCue::AlignSetting>(const String&);
template<> std::optional<VTTCue::AlignSetting> parseEnumeration<VTTCue::AlignSetting>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<VTTCue::AlignSetting>();


} // namespace WebCore

#endif // ENABLE(VIDEO)
