/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextDecoderStreamDecoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTextDecoderStreamDecoderPrototypeFunction_encoding);
static JSC_DECLARE_HOST_FUNCTION(jsTextDecoderStreamDecoderPrototypeFunction_decode);
static JSC_DECLARE_HOST_FUNCTION(jsTextDecoderStreamDecoderPrototypeFunction_flush);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTextDecoderStreamDecoderConstructor);

class JSTextDecoderStreamDecoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextDecoderStreamDecoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextDecoderStreamDecoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextDecoderStreamDecoderPrototype>(vm)) JSTextDecoderStreamDecoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextDecoderStreamDecoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextDecoderStreamDecoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextDecoderStreamDecoderPrototype, JSTextDecoderStreamDecoderPrototype::Base);

using JSTextDecoderStreamDecoderDOMConstructor = JSDOMConstructor<JSTextDecoderStreamDecoder>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSTextDecoderStreamDecoderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSTextDecoderStreamDecoderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto label = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto fatal = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto ignoreBOM = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TextDecoderStreamDecoder::create(WTFMove(label), WTFMove(fatal), WTFMove(ignoreBOM));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<TextDecoderStreamDecoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<TextDecoderStreamDecoder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSTextDecoderStreamDecoderDOMConstructorConstruct, JSTextDecoderStreamDecoderDOMConstructor::construct);

template<> const ClassInfo JSTextDecoderStreamDecoderDOMConstructor::s_info = { "TextDecoderStreamDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextDecoderStreamDecoderDOMConstructor) };

template<> JSValue JSTextDecoderStreamDecoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextDecoderStreamDecoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TextDecoderStreamDecoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTextDecoderStreamDecoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTextDecoderStreamDecoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTextDecoderStreamDecoderConstructor, 0 } },
};

const ClassInfo JSTextDecoderStreamDecoderPrototype::s_info = { "TextDecoderStreamDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextDecoderStreamDecoderPrototype) };

void JSTextDecoderStreamDecoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextDecoderStreamDecoder::info(), JSTextDecoderStreamDecoderPrototypeTableValues, *this);
    putDirect(vm, builtinNames(vm).encodingPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsTextDecoderStreamDecoderPrototypeFunction_encoding, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, builtinNames(vm).decodePrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsTextDecoderStreamDecoderPrototypeFunction_decode, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, builtinNames(vm).flushPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsTextDecoderStreamDecoderPrototypeFunction_flush, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTextDecoderStreamDecoder::s_info = { "TextDecoderStreamDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextDecoderStreamDecoder) };

JSTextDecoderStreamDecoder::JSTextDecoderStreamDecoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextDecoderStreamDecoder>&& impl)
    : JSDOMWrapper<TextDecoderStreamDecoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TextDecoderStreamDecoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTextDecoderStreamDecoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTextDecoderStreamDecoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTextDecoderStreamDecoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTextDecoderStreamDecoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextDecoderStreamDecoder>(vm, globalObject);
}

JSValue JSTextDecoderStreamDecoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextDecoderStreamDecoderDOMConstructor, DOMConstructorID::TextDecoderStreamDecoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTextDecoderStreamDecoder::destroy(JSC::JSCell* cell)
{
    JSTextDecoderStreamDecoder* thisObject = static_cast<JSTextDecoderStreamDecoder*>(cell);
    thisObject->JSTextDecoderStreamDecoder::~JSTextDecoderStreamDecoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsTextDecoderStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextDecoderStreamDecoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextDecoderStreamDecoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsTextDecoderStreamDecoderPrototypeFunction_encodingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextDecoderStreamDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.encoding())));
}

JSC_DEFINE_HOST_FUNCTION(jsTextDecoderStreamDecoderPrototypeFunction_encoding, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextDecoderStreamDecoder>::call<jsTextDecoderStreamDecoderPrototypeFunction_encodingBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "encoding");
}

static inline JSC::EncodedJSValue jsTextDecoderStreamDecoderPrototypeFunction_decodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextDecoderStreamDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto source = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.decode(WTFMove(source)))));
}

JSC_DEFINE_HOST_FUNCTION(jsTextDecoderStreamDecoderPrototypeFunction_decode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextDecoderStreamDecoder>::call<jsTextDecoderStreamDecoderPrototypeFunction_decodeBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "decode");
}

static inline JSC::EncodedJSValue jsTextDecoderStreamDecoderPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextDecoderStreamDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.flush())));
}

JSC_DEFINE_HOST_FUNCTION(jsTextDecoderStreamDecoderPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextDecoderStreamDecoder>::call<jsTextDecoderStreamDecoderPrototypeFunction_flushBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "flush");
}

JSC::GCClient::IsoSubspace* JSTextDecoderStreamDecoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTextDecoderStreamDecoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTextDecoderStreamDecoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTextDecoderStreamDecoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTextDecoderStreamDecoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTextDecoderStreamDecoder = std::forward<decltype(space)>(space); }
    );
}

void JSTextDecoderStreamDecoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextDecoderStreamDecoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTextDecoderStreamDecoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTextDecoderStreamDecoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextDecoderStreamDecoder = static_cast<JSTextDecoderStreamDecoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextDecoderStreamDecoder->wrapped(), jsTextDecoderStreamDecoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TextDecoderStreamDecoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24TextDecoderStreamDecoderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextDecoderStreamDecoder>&& impl)
{

    if constexpr (std::is_polymorphic_v<TextDecoderStreamDecoder>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TextDecoderStreamDecoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore24TextDecoderStreamDecoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TextDecoderStreamDecoder has subclasses. If TextDecoderStreamDecoder has subclasses that get passed
        // to toJS() we currently require TextDecoderStreamDecoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<TextDecoderStreamDecoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextDecoderStreamDecoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextDecoderStreamDecoder* JSTextDecoderStreamDecoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextDecoderStreamDecoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
