/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSpeechRecognitionAlternative.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionAlternativeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionAlternative_transcript);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionAlternative_confidence);

class JSSpeechRecognitionAlternativePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechRecognitionAlternativePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechRecognitionAlternativePrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechRecognitionAlternativePrototype>(vm)) JSSpeechRecognitionAlternativePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechRecognitionAlternativePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechRecognitionAlternativePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechRecognitionAlternativePrototype, JSSpeechRecognitionAlternativePrototype::Base);

using JSSpeechRecognitionAlternativeDOMConstructor = JSDOMConstructorNotConstructable<JSSpeechRecognitionAlternative>;

template<> const ClassInfo JSSpeechRecognitionAlternativeDOMConstructor::s_info = { "SpeechRecognitionAlternative"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionAlternativeDOMConstructor) };

template<> JSValue JSSpeechRecognitionAlternativeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSpeechRecognitionAlternativeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SpeechRecognitionAlternative"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSpeechRecognitionAlternative::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSpeechRecognitionAlternativePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionAlternativeConstructor, 0 } },
    { "transcript"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionAlternative_transcript, 0 } },
    { "confidence"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionAlternative_confidence, 0 } },
};

const ClassInfo JSSpeechRecognitionAlternativePrototype::s_info = { "SpeechRecognitionAlternative"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionAlternativePrototype) };

void JSSpeechRecognitionAlternativePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechRecognitionAlternative::info(), JSSpeechRecognitionAlternativePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSpeechRecognitionAlternative::s_info = { "SpeechRecognitionAlternative"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionAlternative) };

JSSpeechRecognitionAlternative::JSSpeechRecognitionAlternative(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechRecognitionAlternative>&& impl)
    : JSDOMWrapper<SpeechRecognitionAlternative>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SpeechRecognitionAlternative>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSpeechRecognitionAlternative::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSpeechRecognitionAlternativePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSpeechRecognitionAlternativePrototype::create(vm, &globalObject, structure);
}

JSObject* JSSpeechRecognitionAlternative::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechRecognitionAlternative>(vm, globalObject);
}

JSValue JSSpeechRecognitionAlternative::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechRecognitionAlternativeDOMConstructor, DOMConstructorID::SpeechRecognitionAlternative>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSpeechRecognitionAlternative::destroy(JSC::JSCell* cell)
{
    JSSpeechRecognitionAlternative* thisObject = static_cast<JSSpeechRecognitionAlternative*>(cell);
    thisObject->JSSpeechRecognitionAlternative::~JSSpeechRecognitionAlternative();
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionAlternativeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSpeechRecognitionAlternativePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSpeechRecognitionAlternative::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSpeechRecognitionAlternative_transcriptGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognitionAlternative& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.transcript())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionAlternative_transcript, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognitionAlternative>::get<jsSpeechRecognitionAlternative_transcriptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSpeechRecognitionAlternative_confidenceGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognitionAlternative& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.confidence())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionAlternative_confidence, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognitionAlternative>::get<jsSpeechRecognitionAlternative_confidenceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSpeechRecognitionAlternative::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSpeechRecognitionAlternative, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSpeechRecognitionAlternative.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSpeechRecognitionAlternative = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSpeechRecognitionAlternative.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSpeechRecognitionAlternative = std::forward<decltype(space)>(space); }
    );
}

void JSSpeechRecognitionAlternative::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechRecognitionAlternative*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSpeechRecognitionAlternativeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSpeechRecognitionAlternativeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSpeechRecognitionAlternative = static_cast<JSSpeechRecognitionAlternative*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSpeechRecognitionAlternative->wrapped(), jsSpeechRecognitionAlternative);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechRecognitionAlternative@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore28SpeechRecognitionAlternativeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechRecognitionAlternative>&& impl)
{

    if constexpr (std::is_polymorphic_v<SpeechRecognitionAlternative>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SpeechRecognitionAlternative@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore28SpeechRecognitionAlternativeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SpeechRecognitionAlternative has subclasses. If SpeechRecognitionAlternative has subclasses that get passed
        // to toJS() we currently require SpeechRecognitionAlternative you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<SpeechRecognitionAlternative>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechRecognitionAlternative& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SpeechRecognitionAlternative* JSSpeechRecognitionAlternative::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSpeechRecognitionAlternative*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
