/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedLength.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGLength.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedLengthConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedLength_baseVal);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedLength_animVal);

class JSSVGAnimatedLengthPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGAnimatedLengthPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedLengthPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedLengthPrototype>(vm)) JSSVGAnimatedLengthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedLengthPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedLengthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedLengthPrototype, JSSVGAnimatedLengthPrototype::Base);

using JSSVGAnimatedLengthDOMConstructor = JSDOMConstructorNotConstructable<JSSVGAnimatedLength>;

template<> const ClassInfo JSSVGAnimatedLengthDOMConstructor::s_info = { "SVGAnimatedLength"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedLengthDOMConstructor) };

template<> JSValue JSSVGAnimatedLengthDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedLengthDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGAnimatedLength"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedLength::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedLengthPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedLengthConstructor, 0 } },
    { "baseVal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedLength_baseVal, 0 } },
    { "animVal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedLength_animVal, 0 } },
};

const ClassInfo JSSVGAnimatedLengthPrototype::s_info = { "SVGAnimatedLength"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedLengthPrototype) };

void JSSVGAnimatedLengthPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedLength::info(), JSSVGAnimatedLengthPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGAnimatedLength::s_info = { "SVGAnimatedLength"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedLength) };

JSSVGAnimatedLength::JSSVGAnimatedLength(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedLength>&& impl)
    : JSDOMWrapper<SVGAnimatedLength>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGAnimatedLength>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGAnimatedLength::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGAnimatedLengthPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGAnimatedLengthPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGAnimatedLength::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGAnimatedLength>(vm, globalObject);
}

JSValue JSSVGAnimatedLength::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedLengthDOMConstructor, DOMConstructorID::SVGAnimatedLength>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGAnimatedLength::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedLength* thisObject = static_cast<JSSVGAnimatedLength*>(cell);
    thisObject->JSSVGAnimatedLength::~JSSVGAnimatedLength();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedLengthConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnimatedLengthPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGAnimatedLength::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGAnimatedLength_baseValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedLength& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.baseVal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedLength_baseVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedLength>::get<jsSVGAnimatedLength_baseValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGAnimatedLength_animValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedLength& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.animVal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedLength_animVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedLength>::get<jsSVGAnimatedLength_animValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGAnimatedLength::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGAnimatedLength, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGAnimatedLength.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGAnimatedLength = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGAnimatedLength.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGAnimatedLength = std::forward<decltype(space)>(space); }
    );
}

void JSSVGAnimatedLength::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGAnimatedLength*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGAnimatedLengthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGAnimatedLengthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedLength = static_cast<JSSVGAnimatedLength*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedLength->wrapped(), jsSVGAnimatedLength);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGAnimatedLength>&& impl)
{
    return createWrapper<SVGAnimatedLength>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGAnimatedLength& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGAnimatedLength* JSSVGAnimatedLength::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedLength*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
