/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRTCIceCandidateType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCIceCandidateType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("host"),
        MAKE_STATIC_STRING_IMPL("srflx"),
        MAKE_STATIC_STRING_IMPL("prflx"),
        MAKE_STATIC_STRING_IMPL("relay"),
    };
    static_assert(static_cast<size_t>(RTCIceCandidateType::Host) == 0, "RTCIceCandidateType::Host is not 0 as expected");
    static_assert(static_cast<size_t>(RTCIceCandidateType::Srflx) == 1, "RTCIceCandidateType::Srflx is not 1 as expected");
    static_assert(static_cast<size_t>(RTCIceCandidateType::Prflx) == 2, "RTCIceCandidateType::Prflx is not 2 as expected");
    static_assert(static_cast<size_t>(RTCIceCandidateType::Relay) == 3, "RTCIceCandidateType::Relay is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, RTCIceCandidateType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<RTCIceCandidateType> parseEnumerationFromString<RTCIceCandidateType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, RTCIceCandidateType> mappings[] = {
        { "host", RTCIceCandidateType::Host },
        { "prflx", RTCIceCandidateType::Prflx },
        { "relay", RTCIceCandidateType::Relay },
        { "srflx", RTCIceCandidateType::Srflx },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<RTCIceCandidateType> parseEnumeration<RTCIceCandidateType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<RTCIceCandidateType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<RTCIceCandidateType>()
{
    return "\"host\", \"srflx\", \"prflx\", \"relay\"";
}

} // namespace WebCore
