/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSPushSubscriptionJSON.h"

#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(SERVICE_WORKER)

template<> PushSubscriptionJSON convertDictionary<PushSubscriptionJSON>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PushSubscriptionJSON result;
    JSValue endpointValue;
    if (isNullOrUndefined)
        endpointValue = jsUndefined();
    else {
        endpointValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endpoint"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endpointValue.isUndefined()) {
        result.endpoint = convert<IDLUSVString>(lexicalGlobalObject, endpointValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue expirationTimeValue;
    if (isNullOrUndefined)
        expirationTimeValue = jsUndefined();
    else {
        expirationTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expirationTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!expirationTimeValue.isUndefined()) {
        result.expirationTime = convert<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, expirationTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue keysValue;
    if (isNullOrUndefined)
        keysValue = jsUndefined();
    else {
        keysValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keys"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keysValue.isUndefined()) {
        result.keys = convert<IDLRecord<IDLDOMString, IDLUSVString>>(lexicalGlobalObject, keysValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PushSubscriptionJSON& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUSVString::isNullValue(dictionary.endpoint)) {
        auto endpointValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.endpoint));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "endpoint"_s), endpointValue);
    }
    if (!IDLNullable<IDLUnsignedLongLong>::isNullValue(dictionary.expirationTime)) {
        auto expirationTimeValue = toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLNullable<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.expirationTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "expirationTime"_s), expirationTimeValue);
    }
    if (!IDLRecord<IDLDOMString, IDLUSVString>::isNullValue(dictionary.keys)) {
        auto keysValue = toJS<IDLRecord<IDLDOMString, IDLUSVString>>(lexicalGlobalObject, globalObject, throwScope, IDLRecord<IDLDOMString, IDLUSVString>::extractValueFromNullable(dictionary.keys));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "keys"_s), keysValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(SERVICE_WORKER)
