/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPermissionName.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(PermissionName enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("accelerometer"),
        MAKE_STATIC_STRING_IMPL("background-fetch"),
        MAKE_STATIC_STRING_IMPL("bluetooth"),
        MAKE_STATIC_STRING_IMPL("camera"),
        MAKE_STATIC_STRING_IMPL("display-capture"),
        MAKE_STATIC_STRING_IMPL("geolocation"),
        MAKE_STATIC_STRING_IMPL("gyroscope"),
        MAKE_STATIC_STRING_IMPL("magnetometer"),
        MAKE_STATIC_STRING_IMPL("microphone"),
        MAKE_STATIC_STRING_IMPL("midi"),
        MAKE_STATIC_STRING_IMPL("nfc"),
        MAKE_STATIC_STRING_IMPL("notifications"),
        MAKE_STATIC_STRING_IMPL("push"),
        MAKE_STATIC_STRING_IMPL("screen-wake-lock"),
        MAKE_STATIC_STRING_IMPL("speaker-selection"),
    };
    static_assert(static_cast<size_t>(PermissionName::Accelerometer) == 0, "PermissionName::Accelerometer is not 0 as expected");
    static_assert(static_cast<size_t>(PermissionName::BackgroundFetch) == 1, "PermissionName::BackgroundFetch is not 1 as expected");
    static_assert(static_cast<size_t>(PermissionName::Bluetooth) == 2, "PermissionName::Bluetooth is not 2 as expected");
    static_assert(static_cast<size_t>(PermissionName::Camera) == 3, "PermissionName::Camera is not 3 as expected");
    static_assert(static_cast<size_t>(PermissionName::DisplayCapture) == 4, "PermissionName::DisplayCapture is not 4 as expected");
    static_assert(static_cast<size_t>(PermissionName::Geolocation) == 5, "PermissionName::Geolocation is not 5 as expected");
    static_assert(static_cast<size_t>(PermissionName::Gyroscope) == 6, "PermissionName::Gyroscope is not 6 as expected");
    static_assert(static_cast<size_t>(PermissionName::Magnetometer) == 7, "PermissionName::Magnetometer is not 7 as expected");
    static_assert(static_cast<size_t>(PermissionName::Microphone) == 8, "PermissionName::Microphone is not 8 as expected");
    static_assert(static_cast<size_t>(PermissionName::Midi) == 9, "PermissionName::Midi is not 9 as expected");
    static_assert(static_cast<size_t>(PermissionName::Nfc) == 10, "PermissionName::Nfc is not 10 as expected");
    static_assert(static_cast<size_t>(PermissionName::Notifications) == 11, "PermissionName::Notifications is not 11 as expected");
    static_assert(static_cast<size_t>(PermissionName::Push) == 12, "PermissionName::Push is not 12 as expected");
    static_assert(static_cast<size_t>(PermissionName::ScreenWakeLock) == 13, "PermissionName::ScreenWakeLock is not 13 as expected");
    static_assert(static_cast<size_t>(PermissionName::SpeakerSelection) == 14, "PermissionName::SpeakerSelection is not 14 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, PermissionName enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<PermissionName> parseEnumerationFromString<PermissionName>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, PermissionName> mappings[] = {
        { "accelerometer", PermissionName::Accelerometer },
        { "background-fetch", PermissionName::BackgroundFetch },
        { "bluetooth", PermissionName::Bluetooth },
        { "camera", PermissionName::Camera },
        { "display-capture", PermissionName::DisplayCapture },
        { "geolocation", PermissionName::Geolocation },
        { "gyroscope", PermissionName::Gyroscope },
        { "magnetometer", PermissionName::Magnetometer },
        { "microphone", PermissionName::Microphone },
        { "midi", PermissionName::Midi },
        { "nfc", PermissionName::Nfc },
        { "notifications", PermissionName::Notifications },
        { "push", PermissionName::Push },
        { "screen-wake-lock", PermissionName::ScreenWakeLock },
        { "speaker-selection", PermissionName::SpeakerSelection },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<PermissionName> parseEnumeration<PermissionName>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<PermissionName>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<PermissionName>()
{
    return "\"accelerometer\", \"background-fetch\", \"bluetooth\", \"camera\", \"display-capture\", \"geolocation\", \"gyroscope\", \"magnetometer\", \"microphone\", \"midi\", \"nfc\", \"notifications\", \"push\", \"screen-wake-lock\", \"speaker-selection\"";
}

} // namespace WebCore
