/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSNavigationPreloadState.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(SERVICE_WORKER)

template<> NavigationPreloadState convertDictionary<NavigationPreloadState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    NavigationPreloadState result;
    JSValue enabledValue;
    if (isNullOrUndefined)
        enabledValue = jsUndefined();
    else {
        enabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "enabled"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!enabledValue.isUndefined()) {
        result.enabled = convert<IDLBoolean>(lexicalGlobalObject, enabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.enabled = false;
    JSValue headerValueValue;
    if (isNullOrUndefined)
        headerValueValue = jsUndefined();
    else {
        headerValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headerValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headerValueValue.isUndefined()) {
        result.headerValue = convert<IDLByteString>(lexicalGlobalObject, headerValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const NavigationPreloadState& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto enabledValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.enabled);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "enabled"_s), enabledValue);
    if (!IDLByteString::isNullValue(dictionary.headerValue)) {
        auto headerValueValue = toJS<IDLByteString>(lexicalGlobalObject, throwScope, IDLByteString::extractValueFromNullable(dictionary.headerValue));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "headerValue"_s), headerValueValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(SERVICE_WORKER)
