/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIdleDeadline.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIdleDeadlinePrototypeFunction_timeRemaining);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIdleDeadlineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIdleDeadline_didTimeout);

class JSIdleDeadlinePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIdleDeadlinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIdleDeadlinePrototype* ptr = new (NotNull, JSC::allocateCell<JSIdleDeadlinePrototype>(vm)) JSIdleDeadlinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIdleDeadlinePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIdleDeadlinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIdleDeadlinePrototype, JSIdleDeadlinePrototype::Base);

using JSIdleDeadlineDOMConstructor = JSDOMConstructorNotConstructable<JSIdleDeadline>;

template<> const ClassInfo JSIdleDeadlineDOMConstructor::s_info = { "IdleDeadline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIdleDeadlineDOMConstructor) };

template<> JSValue JSIdleDeadlineDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIdleDeadlineDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IdleDeadline"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIdleDeadline::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIdleDeadlinePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIdleDeadlineConstructor, 0 } },
    { "didTimeout"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIdleDeadline_didTimeout, 0 } },
    { "timeRemaining"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIdleDeadlinePrototypeFunction_timeRemaining, 0 } },
};

const ClassInfo JSIdleDeadlinePrototype::s_info = { "IdleDeadline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIdleDeadlinePrototype) };

void JSIdleDeadlinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIdleDeadline::info(), JSIdleDeadlinePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIdleDeadline::s_info = { "IdleDeadline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIdleDeadline) };

JSIdleDeadline::JSIdleDeadline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IdleDeadline>&& impl)
    : JSDOMWrapper<IdleDeadline>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, IdleDeadline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIdleDeadline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIdleDeadlinePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIdleDeadlinePrototype::create(vm, &globalObject, structure);
}

JSObject* JSIdleDeadline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIdleDeadline>(vm, globalObject);
}

JSValue JSIdleDeadline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIdleDeadlineDOMConstructor, DOMConstructorID::IdleDeadline>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIdleDeadline::destroy(JSC::JSCell* cell)
{
    JSIdleDeadline* thisObject = static_cast<JSIdleDeadline*>(cell);
    thisObject->JSIdleDeadline::~JSIdleDeadline();
}

JSC_DEFINE_CUSTOM_GETTER(jsIdleDeadlineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIdleDeadlinePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIdleDeadline::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIdleDeadline_didTimeoutGetter(JSGlobalObject& lexicalGlobalObject, JSIdleDeadline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = (thisObject).globalObject()->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.didTimeout(document))));
}

JSC_DEFINE_CUSTOM_GETTER(jsIdleDeadline_didTimeout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIdleDeadline>::get<jsIdleDeadline_didTimeoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsIdleDeadlinePrototypeFunction_timeRemainingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIdleDeadline>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = (*castedThis).globalObject()->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.timeRemaining(document))));
}

JSC_DEFINE_HOST_FUNCTION(jsIdleDeadlinePrototypeFunction_timeRemaining, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIdleDeadline>::call<jsIdleDeadlinePrototypeFunction_timeRemainingBody>(*lexicalGlobalObject, *callFrame, "timeRemaining");
}

JSC::GCClient::IsoSubspace* JSIdleDeadline::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIdleDeadline, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIdleDeadline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIdleDeadline = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIdleDeadline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIdleDeadline = std::forward<decltype(space)>(space); }
    );
}

void JSIdleDeadline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIdleDeadline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIdleDeadlineOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIdleDeadlineOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIdleDeadline = static_cast<JSIdleDeadline*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIdleDeadline->wrapped(), jsIdleDeadline);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IdleDeadline@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12IdleDeadlineE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IdleDeadline>&& impl)
{

    if constexpr (std::is_polymorphic_v<IdleDeadline>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7IdleDeadline@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12IdleDeadlineE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // IdleDeadline has subclasses. If IdleDeadline has subclasses that get passed
        // to toJS() we currently require IdleDeadline you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<IdleDeadline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IdleDeadline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IdleDeadline* JSIdleDeadline::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIdleDeadline*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
