/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStorageTextureAccess.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUStorageTextureAccess enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("write-only"),
    };
    static_assert(static_cast<size_t>(GPUStorageTextureAccess::WriteOnly) == 0, "GPUStorageTextureAccess::WriteOnly is not 0 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUStorageTextureAccess enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUStorageTextureAccess> parseEnumerationFromString<GPUStorageTextureAccess>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUStorageTextureAccess> mappings[] = {
        { "write-only", GPUStorageTextureAccess::WriteOnly },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUStorageTextureAccess> parseEnumeration<GPUStorageTextureAccess>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUStorageTextureAccess>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<GPUStorageTextureAccess>()
{
    return "\"write-only\"";
}

} // namespace WebCore
