/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUPipelineLayout.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUPipelineLayoutConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUPipelineLayout_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUPipelineLayout_label);

class JSGPUPipelineLayoutPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUPipelineLayoutPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUPipelineLayoutPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUPipelineLayoutPrototype>(vm)) JSGPUPipelineLayoutPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUPipelineLayoutPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUPipelineLayoutPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUPipelineLayoutPrototype, JSGPUPipelineLayoutPrototype::Base);

using JSGPUPipelineLayoutDOMConstructor = JSDOMConstructorNotConstructable<JSGPUPipelineLayout>;

template<> const ClassInfo JSGPUPipelineLayoutDOMConstructor::s_info = { "GPUPipelineLayout"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUPipelineLayoutDOMConstructor) };

template<> JSValue JSGPUPipelineLayoutDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUPipelineLayoutDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUPipelineLayout"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUPipelineLayout::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUPipelineLayoutPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUPipelineLayoutConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUPipelineLayout_label, setJSGPUPipelineLayout_label } },
};

const ClassInfo JSGPUPipelineLayoutPrototype::s_info = { "GPUPipelineLayout"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUPipelineLayoutPrototype) };

void JSGPUPipelineLayoutPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUPipelineLayout::info(), JSGPUPipelineLayoutPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUPipelineLayout::s_info = { "GPUPipelineLayout"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUPipelineLayout) };

JSGPUPipelineLayout::JSGPUPipelineLayout(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUPipelineLayout>&& impl)
    : JSDOMWrapper<GPUPipelineLayout>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUPipelineLayout>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUPipelineLayout::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUPipelineLayoutPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUPipelineLayoutPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUPipelineLayout::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUPipelineLayout>(vm, globalObject);
}

JSValue JSGPUPipelineLayout::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUPipelineLayoutDOMConstructor, DOMConstructorID::GPUPipelineLayout>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUPipelineLayout::destroy(JSC::JSCell* cell)
{
    JSGPUPipelineLayout* thisObject = static_cast<JSGPUPipelineLayout*>(cell);
    thisObject->JSGPUPipelineLayout::~JSGPUPipelineLayout();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUPipelineLayoutConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUPipelineLayoutPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUPipelineLayout::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUPipelineLayout_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUPipelineLayout& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUPipelineLayout_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUPipelineLayout>::get<jsGPUPipelineLayout_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUPipelineLayout_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUPipelineLayout& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUPipelineLayout_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUPipelineLayout>::set<setJSGPUPipelineLayout_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUPipelineLayout::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUPipelineLayout, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUPipelineLayout.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUPipelineLayout = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUPipelineLayout.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUPipelineLayout = std::forward<decltype(space)>(space); }
    );
}

void JSGPUPipelineLayout::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUPipelineLayout*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUPipelineLayoutOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUPipelineLayoutOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUPipelineLayout = static_cast<JSGPUPipelineLayout*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUPipelineLayout->wrapped(), jsGPUPipelineLayout);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUPipelineLayout@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17GPUPipelineLayoutE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUPipelineLayout>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUPipelineLayout>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUPipelineLayout@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17GPUPipelineLayoutE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUPipelineLayout has subclasses. If GPUPipelineLayout has subclasses that get passed
        // to toJS() we currently require GPUPipelineLayout you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUPipelineLayout>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUPipelineLayout& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUPipelineLayout* JSGPUPipelineLayout::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUPipelineLayout*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
