/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUErrorFilter.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUErrorFilter enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("out-of-memory"),
        MAKE_STATIC_STRING_IMPL("validation"),
        MAKE_STATIC_STRING_IMPL("internal"),
    };
    static_assert(static_cast<size_t>(GPUErrorFilter::OutOfMemory) == 0, "GPUErrorFilter::OutOfMemory is not 0 as expected");
    static_assert(static_cast<size_t>(GPUErrorFilter::Validation) == 1, "GPUErrorFilter::Validation is not 1 as expected");
    static_assert(static_cast<size_t>(GPUErrorFilter::Internal) == 2, "GPUErrorFilter::Internal is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUErrorFilter enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUErrorFilter> parseEnumerationFromString<GPUErrorFilter>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUErrorFilter> mappings[] = {
        { "internal", GPUErrorFilter::Internal },
        { "out-of-memory", GPUErrorFilter::OutOfMemory },
        { "validation", GPUErrorFilter::Validation },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUErrorFilter> parseEnumeration<GPUErrorFilter>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUErrorFilter>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<GPUErrorFilter>()
{
    return "\"out-of-memory\", \"validation\", \"internal\"";
}

} // namespace WebCore
