/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBindGroupLayoutEntry.h"

#include "JSDOMConvertNumbers.h"
#include "JSGPUBufferBindingLayout.h"
#include "JSGPUExternalTextureBindingLayout.h"
#include "JSGPUSamplerBindingLayout.h"
#include "JSGPUStorageTextureBindingLayout.h"
#include "JSGPUTextureBindingLayout.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUBindGroupLayoutEntry convertDictionary<GPUBindGroupLayoutEntry>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUBindGroupLayoutEntry result;
    JSValue bindingValue;
    if (isNullOrUndefined)
        bindingValue = jsUndefined();
    else {
        bindingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "binding"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bindingValue.isUndefined()) {
        result.binding = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, bindingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "binding", "GPUBindGroupLayoutEntry", "unsigned long");
        return { };
    }
    JSValue bufferValue;
    if (isNullOrUndefined)
        bufferValue = jsUndefined();
    else {
        bufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bufferValue.isUndefined()) {
        result.buffer = convert<IDLDictionary<GPUBufferBindingLayout>>(lexicalGlobalObject, bufferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue externalTextureValue;
    if (isNullOrUndefined)
        externalTextureValue = jsUndefined();
    else {
        externalTextureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "externalTexture"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!externalTextureValue.isUndefined()) {
        result.externalTexture = convert<IDLDictionary<GPUExternalTextureBindingLayout>>(lexicalGlobalObject, externalTextureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue samplerValue;
    if (isNullOrUndefined)
        samplerValue = jsUndefined();
    else {
        samplerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampler"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!samplerValue.isUndefined()) {
        result.sampler = convert<IDLDictionary<GPUSamplerBindingLayout>>(lexicalGlobalObject, samplerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue storageTextureValue;
    if (isNullOrUndefined)
        storageTextureValue = jsUndefined();
    else {
        storageTextureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storageTexture"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!storageTextureValue.isUndefined()) {
        result.storageTexture = convert<IDLDictionary<GPUStorageTextureBindingLayout>>(lexicalGlobalObject, storageTextureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue textureValue;
    if (isNullOrUndefined)
        textureValue = jsUndefined();
    else {
        textureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "texture"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!textureValue.isUndefined()) {
        result.texture = convert<IDLDictionary<GPUTextureBindingLayout>>(lexicalGlobalObject, textureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue visibilityValue;
    if (isNullOrUndefined)
        visibilityValue = jsUndefined();
    else {
        visibilityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibility"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!visibilityValue.isUndefined()) {
        result.visibility = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, visibilityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "visibility", "GPUBindGroupLayoutEntry", "unsigned long");
        return { };
    }
    return result;
}

} // namespace WebCore
