/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasTextAlign.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CanvasTextAlign enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("start"),
        MAKE_STATIC_STRING_IMPL("end"),
        MAKE_STATIC_STRING_IMPL("left"),
        MAKE_STATIC_STRING_IMPL("right"),
        MAKE_STATIC_STRING_IMPL("center"),
    };
    static_assert(static_cast<size_t>(CanvasTextAlign::Start) == 0, "CanvasTextAlign::Start is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasTextAlign::End) == 1, "CanvasTextAlign::End is not 1 as expected");
    static_assert(static_cast<size_t>(CanvasTextAlign::Left) == 2, "CanvasTextAlign::Left is not 2 as expected");
    static_assert(static_cast<size_t>(CanvasTextAlign::Right) == 3, "CanvasTextAlign::Right is not 3 as expected");
    static_assert(static_cast<size_t>(CanvasTextAlign::Center) == 4, "CanvasTextAlign::Center is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasTextAlign enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasTextAlign> parseEnumerationFromString<CanvasTextAlign>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, CanvasTextAlign> mappings[] = {
        { "center", CanvasTextAlign::Center },
        { "end", CanvasTextAlign::End },
        { "left", CanvasTextAlign::Left },
        { "right", CanvasTextAlign::Right },
        { "start", CanvasTextAlign::Start },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasTextAlign> parseEnumeration<CanvasTextAlign>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasTextAlign>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<CanvasTextAlign>()
{
    return "\"start\", \"end\", \"left\", \"right\", \"center\"";
}

} // namespace WebCore
