/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasPattern.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCanvasPatternPrototypeFunction_setTransform);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCanvasPatternConstructor);

class JSCanvasPatternPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCanvasPatternPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasPatternPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasPatternPrototype>(vm)) JSCanvasPatternPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasPatternPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasPatternPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasPatternPrototype, JSCanvasPatternPrototype::Base);

using JSCanvasPatternDOMConstructor = JSDOMConstructorNotConstructable<JSCanvasPattern>;

template<> const ClassInfo JSCanvasPatternDOMConstructor::s_info = { "CanvasPattern"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasPatternDOMConstructor) };

template<> JSValue JSCanvasPatternDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCanvasPatternDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CanvasPattern"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCanvasPattern::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasPatternPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCanvasPatternConstructor, 0 } },
    { "setTransform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCanvasPatternPrototypeFunction_setTransform, 0 } },
};

const ClassInfo JSCanvasPatternPrototype::s_info = { "CanvasPattern"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasPatternPrototype) };

void JSCanvasPatternPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasPattern::info(), JSCanvasPatternPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCanvasPattern::s_info = { "CanvasPattern"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasPattern) };

JSCanvasPattern::JSCanvasPattern(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasPattern>&& impl)
    : JSDOMWrapper<CanvasPattern>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CanvasPattern>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCanvasPattern::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCanvasPatternPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCanvasPatternPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCanvasPattern::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCanvasPattern>(vm, globalObject);
}

JSValue JSCanvasPattern::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasPatternDOMConstructor, DOMConstructorID::CanvasPattern>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCanvasPattern::destroy(JSC::JSCell* cell)
{
    JSCanvasPattern* thisObject = static_cast<JSCanvasPattern*>(cell);
    thisObject->JSCanvasPattern::~JSCanvasPattern();
}

JSC_DEFINE_CUSTOM_GETTER(jsCanvasPatternConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasPatternPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCanvasPattern::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCanvasPatternPrototypeFunction_setTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasPattern>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto transform = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setTransform(WTFMove(transform)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCanvasPatternPrototypeFunction_setTransform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCanvasPattern>::call<jsCanvasPatternPrototypeFunction_setTransformBody>(*lexicalGlobalObject, *callFrame, "setTransform");
}

JSC::GCClient::IsoSubspace* JSCanvasPattern::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCanvasPattern, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCanvasPattern.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCanvasPattern = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCanvasPattern.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCanvasPattern = std::forward<decltype(space)>(space); }
    );
}

void JSCanvasPattern::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCanvasPattern*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCanvasPatternOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCanvasPatternOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasPattern = static_cast<JSCanvasPattern*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasPattern->wrapped(), jsCanvasPattern);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CanvasPattern@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13CanvasPatternE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CanvasPattern>&& impl)
{

    if constexpr (std::is_polymorphic_v<CanvasPattern>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CanvasPattern@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13CanvasPatternE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CanvasPattern has subclasses. If CanvasPattern has subclasses that get passed
        // to toJS() we currently require CanvasPattern you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CanvasPattern>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CanvasPattern& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CanvasPattern* JSCanvasPattern::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCanvasPattern*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
