/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBiquadFilterOptions.h"

#include "JSBiquadFilterType.h"
#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> BiquadFilterOptions convertDictionary<BiquadFilterOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    BiquadFilterOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue QValue;
    if (isNullOrUndefined)
        QValue = jsUndefined();
    else {
        QValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "Q"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!QValue.isUndefined()) {
        result.Q = convert<IDLFloat>(lexicalGlobalObject, QValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.Q = 1;
    JSValue detuneValue;
    if (isNullOrUndefined)
        detuneValue = jsUndefined();
    else {
        detuneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detune"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detuneValue.isUndefined()) {
        result.detune = convert<IDLFloat>(lexicalGlobalObject, detuneValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detune = 0;
    JSValue frequencyValue;
    if (isNullOrUndefined)
        frequencyValue = jsUndefined();
    else {
        frequencyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frequency"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frequencyValue.isUndefined()) {
        result.frequency = convert<IDLFloat>(lexicalGlobalObject, frequencyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.frequency = 350;
    JSValue gainValue;
    if (isNullOrUndefined)
        gainValue = jsUndefined();
    else {
        gainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "gain"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!gainValue.isUndefined()) {
        result.gain = convert<IDLFloat>(lexicalGlobalObject, gainValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.gain = 0;
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<BiquadFilterType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.type = BiquadFilterType::Lowpass;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
