/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSBackgroundFetchFailureReason.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(BackgroundFetchFailureReason enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("aborted"),
        MAKE_STATIC_STRING_IMPL("bad-status"),
        MAKE_STATIC_STRING_IMPL("fetch-error"),
        MAKE_STATIC_STRING_IMPL("quota-exceeded"),
        MAKE_STATIC_STRING_IMPL("download-total-exceeded"),
    };
    static_assert(static_cast<size_t>(BackgroundFetchFailureReason::EmptyString) == 0, "BackgroundFetchFailureReason::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchFailureReason::Aborted) == 1, "BackgroundFetchFailureReason::Aborted is not 1 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchFailureReason::BadStatus) == 2, "BackgroundFetchFailureReason::BadStatus is not 2 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchFailureReason::FetchError) == 3, "BackgroundFetchFailureReason::FetchError is not 3 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchFailureReason::QuotaExceeded) == 4, "BackgroundFetchFailureReason::QuotaExceeded is not 4 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchFailureReason::DownloadTotalExceeded) == 5, "BackgroundFetchFailureReason::DownloadTotalExceeded is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, BackgroundFetchFailureReason enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<BackgroundFetchFailureReason> parseEnumerationFromString<BackgroundFetchFailureReason>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return BackgroundFetchFailureReason::EmptyString;
    static constexpr std::pair<ComparableASCIILiteral, BackgroundFetchFailureReason> mappings[] = {
        { "aborted", BackgroundFetchFailureReason::Aborted },
        { "bad-status", BackgroundFetchFailureReason::BadStatus },
        { "download-total-exceeded", BackgroundFetchFailureReason::DownloadTotalExceeded },
        { "fetch-error", BackgroundFetchFailureReason::FetchError },
        { "quota-exceeded", BackgroundFetchFailureReason::QuotaExceeded },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<BackgroundFetchFailureReason> parseEnumeration<BackgroundFetchFailureReason>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<BackgroundFetchFailureReason>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<BackgroundFetchFailureReason>()
{
    return "\"\", \"aborted\", \"bad-status\", \"fetch-error\", \"quota-exceeded\", \"download-total-exceeded\"";
}

} // namespace WebCore

#endif // ENABLE(SERVICE_WORKER)
