/*
 * Copyright (C) 2023 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

#include "config.h"
#include "BytecodeDumper.h"

#include "BytecodeStructs.h"

namespace JSC {

void dumpBytecode(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, const JSInstruction* __instruction)
{
    switch (__instruction->opcodeID()) {
    case op_tail_call_varargs:
        __instruction->as<OpTailCallVarargs>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_call_varargs:
        __instruction->as<OpCallVarargs>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_iterator_next:
        __instruction->as<OpIteratorNext>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_construct_varargs:
        __instruction->as<OpConstructVarargs>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_iterator_open:
        __instruction->as<OpIteratorOpen>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_set_private_brand:
        __instruction->as<OpSetPrivateBrand>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_check_private_brand:
        __instruction->as<OpCheckPrivateBrand>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_by_id:
        __instruction->as<OpPutById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_construct:
        __instruction->as<OpConstruct>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_object:
        __instruction->as<OpToObject>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_tail_call:
        __instruction->as<OpTailCall>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_call_direct_eval:
        __instruction->as<OpCallDirectEval>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_tail_call_forward_arguments:
        __instruction->as<OpTailCallForwardArguments>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_generator:
        __instruction->as<OpCreateGenerator>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_async_generator:
        __instruction->as<OpCreateAsyncGenerator>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_by_val:
        __instruction->as<OpGetByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_private_name:
        __instruction->as<OpGetPrivateName>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_promise:
        __instruction->as<OpCreatePromise>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_catch:
        __instruction->as<OpCatch>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_array_with_size:
        __instruction->as<OpNewArrayWithSize>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_array_buffer:
        __instruction->as<OpNewArrayBuffer>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_by_id:
        __instruction->as<OpGetById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_by_id_with_this:
        __instruction->as<OpGetByIdWithThis>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_profile_type:
        __instruction->as<OpProfileType>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_profile_control_flow:
        __instruction->as<OpProfileControlFlow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_by_val_with_this:
        __instruction->as<OpGetByValWithThis>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_enumerator_get_by_val:
        __instruction->as<OpEnumeratorGetByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_by_id_direct:
        __instruction->as<OpGetByIdDirect>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_prototype_of:
        __instruction->as<OpGetPrototypeOf>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_internal_field:
        __instruction->as<OpGetInternalField>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_try_get_by_id:
        __instruction->as<OpTryGetById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_array_with_species:
        __instruction->as<OpNewArrayWithSpecies>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_call:
        __instruction->as<OpCall>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_call_ignore_result:
        __instruction->as<OpCallIgnoreResult>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_argument:
        __instruction->as<OpGetArgument>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_private_name:
        __instruction->as<OpPutPrivateName>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_resolve_scope:
        __instruction->as<OpResolveScope>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_from_scope:
        __instruction->as<OpGetFromScope>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_to_scope:
        __instruction->as<OpPutToScope>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_from_arguments:
        __instruction->as<OpGetFromArguments>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_this:
        __instruction->as<OpCreateThis>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_object:
        __instruction->as<OpNewObject>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_this:
        __instruction->as<OpToThis>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_array:
        __instruction->as<OpNewArray>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_by_val:
        __instruction->as<OpPutByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_by_val_direct:
        __instruction->as<OpPutByValDirect>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_in_by_val:
        __instruction->as<OpInByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_enumerator_next:
        __instruction->as<OpEnumeratorNext>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_enumerator_in_by_val:
        __instruction->as<OpEnumeratorInByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_enumerator_has_own_property:
        __instruction->as<OpEnumeratorHasOwnProperty>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_enumerator_put_by_val:
        __instruction->as<OpEnumeratorPutByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jneq_ptr:
        __instruction->as<OpJneqPtr>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_in_by_id:
        __instruction->as<OpInById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_has_private_name:
        __instruction->as<OpHasPrivateName>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_has_private_brand:
        __instruction->as<OpHasPrivateBrand>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_by_id_with_this:
        __instruction->as<OpPutByIdWithThis>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_del_by_id:
        __instruction->as<OpDelById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_by_val_with_this:
        __instruction->as<OpPutByValWithThis>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_del_by_val:
        __instruction->as<OpDelByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_getter_by_id:
        __instruction->as<OpPutGetterById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_setter_by_id:
        __instruction->as<OpPutSetterById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_getter_setter_by_id:
        __instruction->as<OpPutGetterSetterById>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_getter_by_val:
        __instruction->as<OpPutGetterByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_setter_by_val:
        __instruction->as<OpPutSetterByVal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_define_data_property:
        __instruction->as<OpDefineDataProperty>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_define_accessor_property:
        __instruction->as<OpDefineAccessorProperty>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jmp:
        __instruction->as<OpJmp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jtrue:
        __instruction->as<OpJtrue>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jfalse:
        __instruction->as<OpJfalse>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jeq_null:
        __instruction->as<OpJeqNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jneq_null:
        __instruction->as<OpJneqNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jundefined_or_null:
        __instruction->as<OpJundefinedOrNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jnundefined_or_null:
        __instruction->as<OpJnundefinedOrNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jeq_ptr:
        __instruction->as<OpJeqPtr>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jeq:
        __instruction->as<OpJeq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jstricteq:
        __instruction->as<OpJstricteq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jneq:
        __instruction->as<OpJneq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jnstricteq:
        __instruction->as<OpJnstricteq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jless:
        __instruction->as<OpJless>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jlesseq:
        __instruction->as<OpJlesseq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jgreater:
        __instruction->as<OpJgreater>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jgreatereq:
        __instruction->as<OpJgreatereq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jnless:
        __instruction->as<OpJnless>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jnlesseq:
        __instruction->as<OpJnlesseq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jngreater:
        __instruction->as<OpJngreater>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jngreatereq:
        __instruction->as<OpJngreatereq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jbelow:
        __instruction->as<OpJbelow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_jbeloweq:
        __instruction->as<OpJbeloweq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_loop_hint:
        __instruction->as<OpLoopHint>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_switch_imm:
        __instruction->as<OpSwitchImm>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_switch_char:
        __instruction->as<OpSwitchChar>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_switch_string:
        __instruction->as<OpSwitchString>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_func:
        __instruction->as<OpNewFunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_func_exp:
        __instruction->as<OpNewFuncExp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_generator_func:
        __instruction->as<OpNewGeneratorFunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_generator_func_exp:
        __instruction->as<OpNewGeneratorFuncExp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_async_func:
        __instruction->as<OpNewAsyncFunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_async_func_exp:
        __instruction->as<OpNewAsyncFuncExp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_async_generator_func:
        __instruction->as<OpNewAsyncGeneratorFunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_async_generator_func_exp:
        __instruction->as<OpNewAsyncGeneratorFuncExp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_set_function_name:
        __instruction->as<OpSetFunctionName>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_ret:
        __instruction->as<OpRet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_strcat:
        __instruction->as<OpStrcat>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_primitive:
        __instruction->as<OpToPrimitive>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_property_key:
        __instruction->as<OpToPropertyKey>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_to_arguments:
        __instruction->as<OpPutToArguments>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_push_with_scope:
        __instruction->as<OpPushWithScope>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_lexical_environment:
        __instruction->as<OpCreateLexicalEnvironment>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_generator_frame_environment:
        __instruction->as<OpCreateGeneratorFrameEnvironment>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_parent_scope:
        __instruction->as<OpGetParentScope>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_throw:
        __instruction->as<OpThrow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_throw_static_error:
        __instruction->as<OpThrowStaticError>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_debug:
        __instruction->as<OpDebug>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_end:
        __instruction->as<OpEnd>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_property_enumerator:
        __instruction->as<OpGetPropertyEnumerator>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_unreachable:
        __instruction->as<OpUnreachable>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_rest:
        __instruction->as<OpCreateRest>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_rest_length:
        __instruction->as<OpGetRestLength>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_yield:
        __instruction->as<OpYield>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_check_traps:
        __instruction->as<OpCheckTraps>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_log_shadow_chicken_prologue:
        __instruction->as<OpLogShadowChickenPrologue>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_log_shadow_chicken_tail:
        __instruction->as<OpLogShadowChickenTail>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_resolve_scope_for_hoisting_func_decl_in_eval:
        __instruction->as<OpResolveScopeForHoistingFuncDeclInEval>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_put_internal_field:
        __instruction->as<OpPutInternalField>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_nop:
        __instruction->as<OpNop>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_super_sampler_begin:
        __instruction->as<OpSuperSamplerBegin>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_wide16:
        __instruction->as<OpWide16>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_super_sampler_end:
        __instruction->as<OpSuperSamplerEnd>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_wide32:
        __instruction->as<OpWide32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_enter:
        __instruction->as<OpEnter>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_get_scope:
        __instruction->as<OpGetScope>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_direct_arguments:
        __instruction->as<OpCreateDirectArguments>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_scoped_arguments:
        __instruction->as<OpCreateScopedArguments>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_create_cloned_arguments:
        __instruction->as<OpCreateClonedArguments>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_promise:
        __instruction->as<OpNewPromise>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_generator:
        __instruction->as<OpNewGenerator>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_argument_count:
        __instruction->as<OpArgumentCount>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_check_tdz:
        __instruction->as<OpCheckTdz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_array_with_spread:
        __instruction->as<OpNewArrayWithSpread>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_spread:
        __instruction->as<OpSpread>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_new_regexp:
        __instruction->as<OpNewRegexp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_mov:
        __instruction->as<OpMov>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_eq:
        __instruction->as<OpEq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_neq:
        __instruction->as<OpNeq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_stricteq:
        __instruction->as<OpStricteq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_nstricteq:
        __instruction->as<OpNstricteq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_less:
        __instruction->as<OpLess>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_lesseq:
        __instruction->as<OpLesseq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_greater:
        __instruction->as<OpGreater>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_greatereq:
        __instruction->as<OpGreatereq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_below:
        __instruction->as<OpBelow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_beloweq:
        __instruction->as<OpBeloweq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_mod:
        __instruction->as<OpMod>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_pow:
        __instruction->as<OpPow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_urshift:
        __instruction->as<OpUrshift>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_add:
        __instruction->as<OpAdd>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_mul:
        __instruction->as<OpMul>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_div:
        __instruction->as<OpDiv>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_sub:
        __instruction->as<OpSub>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_bitand:
        __instruction->as<OpBitand>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_bitor:
        __instruction->as<OpBitor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_bitxor:
        __instruction->as<OpBitxor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_lshift:
        __instruction->as<OpLshift>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_rshift:
        __instruction->as<OpRshift>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_eq_null:
        __instruction->as<OpEqNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_neq_null:
        __instruction->as<OpNeqNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_string:
        __instruction->as<OpToString>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_unsigned:
        __instruction->as<OpUnsigned>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_empty:
        __instruction->as<OpIsEmpty>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_typeof_is_undefined:
        __instruction->as<OpTypeofIsUndefined>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_typeof_is_object:
        __instruction->as<OpTypeofIsObject>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_typeof_is_function:
        __instruction->as<OpTypeofIsFunction>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_undefined_or_null:
        __instruction->as<OpIsUndefinedOrNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_boolean:
        __instruction->as<OpIsBoolean>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_number:
        __instruction->as<OpIsNumber>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_big_int:
        __instruction->as<OpIsBigInt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_object:
        __instruction->as<OpIsObject>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_callable:
        __instruction->as<OpIsCallable>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_constructor:
        __instruction->as<OpIsConstructor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_inc:
        __instruction->as<OpInc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_dec:
        __instruction->as<OpDec>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_negate:
        __instruction->as<OpNegate>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_not:
        __instruction->as<OpNot>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_identity_with_profile:
        __instruction->as<OpIdentityWithProfile>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_overrides_has_instance:
        __instruction->as<OpOverridesHasInstance>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_instanceof:
        __instruction->as<OpInstanceof>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_instanceof_custom:
        __instruction->as<OpInstanceofCustom>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_typeof:
        __instruction->as<OpTypeof>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_is_cell_with_type:
        __instruction->as<OpIsCellWithType>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_has_structure_with_flags:
        __instruction->as<OpHasStructureWithFlags>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_number:
        __instruction->as<OpToNumber>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_to_numeric:
        __instruction->as<OpToNumeric>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case op_bitnot:
        __instruction->as<OpBitnot>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    default:
        ASSERT_NOT_REACHED();
    }
}

#if ENABLE(WEBASSEMBLY)
void dumpWasm(BytecodeDumperBase<WasmInstructionStream>* dumper, WasmInstructionStream::Offset __location, const WasmInstruction* __instruction)
{
    switch (__instruction->opcodeID()) {
    case wasm_i32_add:
        __instruction->as<WasmI32Add>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_sub:
        __instruction->as<WasmI32Sub>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_mul:
        __instruction->as<WasmI32Mul>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_div_s:
        __instruction->as<WasmI32DivS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_div_u:
        __instruction->as<WasmI32DivU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_rem_s:
        __instruction->as<WasmI32RemS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_rem_u:
        __instruction->as<WasmI32RemU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_and:
        __instruction->as<WasmI32And>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_or:
        __instruction->as<WasmI32Or>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_xor:
        __instruction->as<WasmI32Xor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_shl:
        __instruction->as<WasmI32Shl>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_shr_u:
        __instruction->as<WasmI32ShrU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_shr_s:
        __instruction->as<WasmI32ShrS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_rotr:
        __instruction->as<WasmI32Rotr>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_rotl:
        __instruction->as<WasmI32Rotl>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_eq:
        __instruction->as<WasmI32Eq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_ne:
        __instruction->as<WasmI32Ne>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_lt_s:
        __instruction->as<WasmI32LtS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_le_s:
        __instruction->as<WasmI32LeS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_lt_u:
        __instruction->as<WasmI32LtU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_le_u:
        __instruction->as<WasmI32LeU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_gt_s:
        __instruction->as<WasmI32GtS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_ge_s:
        __instruction->as<WasmI32GeS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_gt_u:
        __instruction->as<WasmI32GtU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_ge_u:
        __instruction->as<WasmI32GeU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_clz:
        __instruction->as<WasmI32Clz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_ctz:
        __instruction->as<WasmI32Ctz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_popcnt:
        __instruction->as<WasmI32Popcnt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_eqz:
        __instruction->as<WasmI32Eqz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_add:
        __instruction->as<WasmI64Add>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_sub:
        __instruction->as<WasmI64Sub>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_mul:
        __instruction->as<WasmI64Mul>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_div_s:
        __instruction->as<WasmI64DivS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_div_u:
        __instruction->as<WasmI64DivU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_rem_s:
        __instruction->as<WasmI64RemS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_rem_u:
        __instruction->as<WasmI64RemU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_and:
        __instruction->as<WasmI64And>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_or:
        __instruction->as<WasmI64Or>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_xor:
        __instruction->as<WasmI64Xor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_shl:
        __instruction->as<WasmI64Shl>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_shr_u:
        __instruction->as<WasmI64ShrU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_shr_s:
        __instruction->as<WasmI64ShrS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_rotr:
        __instruction->as<WasmI64Rotr>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_rotl:
        __instruction->as<WasmI64Rotl>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_eq:
        __instruction->as<WasmI64Eq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_ne:
        __instruction->as<WasmI64Ne>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_lt_s:
        __instruction->as<WasmI64LtS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_le_s:
        __instruction->as<WasmI64LeS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_lt_u:
        __instruction->as<WasmI64LtU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_le_u:
        __instruction->as<WasmI64LeU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_gt_s:
        __instruction->as<WasmI64GtS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_ge_s:
        __instruction->as<WasmI64GeS>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_gt_u:
        __instruction->as<WasmI64GtU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_ge_u:
        __instruction->as<WasmI64GeU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_clz:
        __instruction->as<WasmI64Clz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_ctz:
        __instruction->as<WasmI64Ctz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_popcnt:
        __instruction->as<WasmI64Popcnt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_eqz:
        __instruction->as<WasmI64Eqz>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_add:
        __instruction->as<WasmF32Add>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_sub:
        __instruction->as<WasmF32Sub>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_mul:
        __instruction->as<WasmF32Mul>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_div:
        __instruction->as<WasmF32Div>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_min:
        __instruction->as<WasmF32Min>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_max:
        __instruction->as<WasmF32Max>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_abs:
        __instruction->as<WasmF32Abs>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_neg:
        __instruction->as<WasmF32Neg>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_copysign:
        __instruction->as<WasmF32Copysign>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_ceil:
        __instruction->as<WasmF32Ceil>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_floor:
        __instruction->as<WasmF32Floor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_trunc:
        __instruction->as<WasmF32Trunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_nearest:
        __instruction->as<WasmF32Nearest>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_sqrt:
        __instruction->as<WasmF32Sqrt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_eq:
        __instruction->as<WasmF32Eq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_ne:
        __instruction->as<WasmF32Ne>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_lt:
        __instruction->as<WasmF32Lt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_le:
        __instruction->as<WasmF32Le>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_gt:
        __instruction->as<WasmF32Gt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_ge:
        __instruction->as<WasmF32Ge>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_add:
        __instruction->as<WasmF64Add>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_sub:
        __instruction->as<WasmF64Sub>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_mul:
        __instruction->as<WasmF64Mul>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_div:
        __instruction->as<WasmF64Div>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_min:
        __instruction->as<WasmF64Min>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_max:
        __instruction->as<WasmF64Max>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_abs:
        __instruction->as<WasmF64Abs>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_neg:
        __instruction->as<WasmF64Neg>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_copysign:
        __instruction->as<WasmF64Copysign>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_ceil:
        __instruction->as<WasmF64Ceil>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_floor:
        __instruction->as<WasmF64Floor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_trunc:
        __instruction->as<WasmF64Trunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_nearest:
        __instruction->as<WasmF64Nearest>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_sqrt:
        __instruction->as<WasmF64Sqrt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_eq:
        __instruction->as<WasmF64Eq>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_ne:
        __instruction->as<WasmF64Ne>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_lt:
        __instruction->as<WasmF64Lt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_le:
        __instruction->as<WasmF64Le>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_gt:
        __instruction->as<WasmF64Gt>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_ge:
        __instruction->as<WasmF64Ge>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_s_f32:
        __instruction->as<WasmI32TruncSF32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_s_f64:
        __instruction->as<WasmI32TruncSF64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_u_f32:
        __instruction->as<WasmI32TruncUF32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_u_f64:
        __instruction->as<WasmI32TruncUF64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_wrap_i64:
        __instruction->as<WasmI32WrapI64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_s_f32:
        __instruction->as<WasmI64TruncSF32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_s_f64:
        __instruction->as<WasmI64TruncSF64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_u_f32:
        __instruction->as<WasmI64TruncUF32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_u_f64:
        __instruction->as<WasmI64TruncUF64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_extend_s_i32:
        __instruction->as<WasmI64ExtendSI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_extend_u_i32:
        __instruction->as<WasmI64ExtendUI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_convert_s_i32:
        __instruction->as<WasmF32ConvertSI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_convert_u_i32:
        __instruction->as<WasmF32ConvertUI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_convert_s_i64:
        __instruction->as<WasmF32ConvertSI64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_convert_u_i64:
        __instruction->as<WasmF32ConvertUI64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_demote_f64:
        __instruction->as<WasmF32DemoteF64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f32_reinterpret_i32:
        __instruction->as<WasmF32ReinterpretI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_convert_s_i32:
        __instruction->as<WasmF64ConvertSI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_convert_u_i32:
        __instruction->as<WasmF64ConvertUI32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_convert_s_i64:
        __instruction->as<WasmF64ConvertSI64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_convert_u_i64:
        __instruction->as<WasmF64ConvertUI64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_promote_f32:
        __instruction->as<WasmF64PromoteF32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_f64_reinterpret_i64:
        __instruction->as<WasmF64ReinterpretI64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_reinterpret_f32:
        __instruction->as<WasmI32ReinterpretF32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_reinterpret_f64:
        __instruction->as<WasmI64ReinterpretF64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_extend8_s:
        __instruction->as<WasmI32Extend8S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_extend16_s:
        __instruction->as<WasmI32Extend16S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_extend8_s:
        __instruction->as<WasmI64Extend8S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_extend16_s:
        __instruction->as<WasmI64Extend16S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_extend32_s:
        __instruction->as<WasmI64Extend32S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_sat_f32_s:
        __instruction->as<WasmI32TruncSatF32S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_sat_f32_u:
        __instruction->as<WasmI32TruncSatF32U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_sat_f64_s:
        __instruction->as<WasmI32TruncSatF64S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_trunc_sat_f64_u:
        __instruction->as<WasmI32TruncSatF64U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_sat_f32_s:
        __instruction->as<WasmI64TruncSatF32S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_sat_f32_u:
        __instruction->as<WasmI64TruncSatF32U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_sat_f64_s:
        __instruction->as<WasmI64TruncSatF64S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_trunc_sat_f64_u:
        __instruction->as<WasmI64TruncSatF64U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_throw_from_slow_path_trampoline:
        __instruction->as<WasmThrowFromSlowPathTrampoline>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_throw_from_fault_handler_trampoline_reg_instance:
        __instruction->as<WasmThrowFromFaultHandlerTrampolineRegInstance>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call_return_location:
        __instruction->as<WasmCallReturnLocation>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call_indirect_return_location:
        __instruction->as<WasmCallIndirectReturnLocation>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call_ref_return_location:
        __instruction->as<WasmCallRefReturnLocation>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_wide16:
        __instruction->as<WasmWide16>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_wide32:
        __instruction->as<WasmWide32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_enter:
        __instruction->as<WasmEnter>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_nop:
        __instruction->as<WasmNop>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_loop_hint:
        __instruction->as<WasmLoopHint>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_mov:
        __instruction->as<WasmMov>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_jtrue:
        __instruction->as<WasmJtrue>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_jfalse:
        __instruction->as<WasmJfalse>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_jmp:
        __instruction->as<WasmJmp>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_ret:
        __instruction->as<WasmRet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_switch:
        __instruction->as<WasmSwitch>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_unreachable:
        __instruction->as<WasmUnreachable>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_ret_void:
        __instruction->as<WasmRetVoid>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_drop_keep:
        __instruction->as<WasmDropKeep>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_ref_is_null:
        __instruction->as<WasmRefIsNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_ref_func:
        __instruction->as<WasmRefFunc>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_ref_as_non_null:
        __instruction->as<WasmRefAsNonNull>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_get_global:
        __instruction->as<WasmGetGlobal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_set_global:
        __instruction->as<WasmSetGlobal>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_set_global_ref:
        __instruction->as<WasmSetGlobalRef>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_get_global_portable_binding:
        __instruction->as<WasmGetGlobalPortableBinding>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_set_global_portable_binding:
        __instruction->as<WasmSetGlobalPortableBinding>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_set_global_ref_portable_binding:
        __instruction->as<WasmSetGlobalRefPortableBinding>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_table_get:
        __instruction->as<WasmTableGet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_table_set:
        __instruction->as<WasmTableSet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_table_init:
        __instruction->as<WasmTableInit>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_table_grow:
        __instruction->as<WasmTableGrow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_table_fill:
        __instruction->as<WasmTableFill>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call:
        __instruction->as<WasmCall>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_tail_call:
        __instruction->as<WasmTailCall>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call_indirect:
        __instruction->as<WasmCallIndirect>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_tail_call_indirect:
        __instruction->as<WasmTailCallIndirect>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call_ref:
        __instruction->as<WasmCallRef>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_call_builtin:
        __instruction->as<WasmCallBuiltin>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_grow_memory:
        __instruction->as<WasmGrowMemory>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_select:
        __instruction->as<WasmSelect>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_load8_u:
        __instruction->as<WasmLoad8U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_load16_u:
        __instruction->as<WasmLoad16U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_load32_u:
        __instruction->as<WasmLoad32U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_load64_u:
        __instruction->as<WasmLoad64U>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_load8_s:
        __instruction->as<WasmI32Load8S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_load8_s:
        __instruction->as<WasmI64Load8S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i32_load16_s:
        __instruction->as<WasmI32Load16S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_load16_s:
        __instruction->as<WasmI64Load16S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_load32_s:
        __instruction->as<WasmI64Load32S>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_store8:
        __instruction->as<WasmStore8>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_store16:
        __instruction->as<WasmStore16>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_store32:
        __instruction->as<WasmStore32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_store64:
        __instruction->as<WasmStore64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_add:
        __instruction->as<WasmI64AtomicRmwAdd>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_add_u:
        __instruction->as<WasmI64AtomicRmw8AddU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_add_u:
        __instruction->as<WasmI64AtomicRmw16AddU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_add_u:
        __instruction->as<WasmI64AtomicRmw32AddU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_sub:
        __instruction->as<WasmI64AtomicRmwSub>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_sub_u:
        __instruction->as<WasmI64AtomicRmw8SubU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_sub_u:
        __instruction->as<WasmI64AtomicRmw16SubU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_sub_u:
        __instruction->as<WasmI64AtomicRmw32SubU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_and:
        __instruction->as<WasmI64AtomicRmwAnd>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_and_u:
        __instruction->as<WasmI64AtomicRmw8AndU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_and_u:
        __instruction->as<WasmI64AtomicRmw16AndU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_and_u:
        __instruction->as<WasmI64AtomicRmw32AndU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_or:
        __instruction->as<WasmI64AtomicRmwOr>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_or_u:
        __instruction->as<WasmI64AtomicRmw8OrU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_or_u:
        __instruction->as<WasmI64AtomicRmw16OrU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_or_u:
        __instruction->as<WasmI64AtomicRmw32OrU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_xor:
        __instruction->as<WasmI64AtomicRmwXor>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_xor_u:
        __instruction->as<WasmI64AtomicRmw8XorU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_xor_u:
        __instruction->as<WasmI64AtomicRmw16XorU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_xor_u:
        __instruction->as<WasmI64AtomicRmw32XorU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_xchg:
        __instruction->as<WasmI64AtomicRmwXchg>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_xchg_u:
        __instruction->as<WasmI64AtomicRmw8XchgU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_xchg_u:
        __instruction->as<WasmI64AtomicRmw16XchgU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_xchg_u:
        __instruction->as<WasmI64AtomicRmw32XchgU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw_cmpxchg:
        __instruction->as<WasmI64AtomicRmwCmpxchg>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw8_cmpxchg_u:
        __instruction->as<WasmI64AtomicRmw8CmpxchgU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw16_cmpxchg_u:
        __instruction->as<WasmI64AtomicRmw16CmpxchgU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i64_atomic_rmw32_cmpxchg_u:
        __instruction->as<WasmI64AtomicRmw32CmpxchgU>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_memory_atomic_wait32:
        __instruction->as<WasmMemoryAtomicWait32>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_memory_atomic_wait64:
        __instruction->as<WasmMemoryAtomicWait64>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_memory_atomic_notify:
        __instruction->as<WasmMemoryAtomicNotify>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_atomic_fence:
        __instruction->as<WasmAtomicFence>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_throw:
        __instruction->as<WasmThrow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_rethrow:
        __instruction->as<WasmRethrow>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_catch:
        __instruction->as<WasmCatch>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_catch_all:
        __instruction->as<WasmCatchAll>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i31_new:
        __instruction->as<WasmI31New>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_i31_get:
        __instruction->as<WasmI31Get>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_array_new:
        __instruction->as<WasmArrayNew>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_array_get:
        __instruction->as<WasmArrayGet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_array_set:
        __instruction->as<WasmArraySet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_array_len:
        __instruction->as<WasmArrayLen>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_struct_new:
        __instruction->as<WasmStructNew>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_struct_get:
        __instruction->as<WasmStructGet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_struct_set:
        __instruction->as<WasmStructSet>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    case wasm_extern_externalize:
        __instruction->as<WasmExternExternalize>().dump(dumper, __location, __instruction->sizeShiftAmount());
        break;
    default:
        ASSERT_NOT_REACHED();
    }
}
#endif // ENABLE(WEBASSEMBLY)

} // namespace JSC
//  SHA1Hash: c59e212737dd6b7ca9a98ac319e4b68947d0ef3a
