/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_SOCKETS)

#include "JSWebSocket.h"

#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionClose(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsWebSocketURL(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebSocketUrl(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebSocketReadyState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebSocketBufferedAmount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebSocketOnopen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebSocketOnopen(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebSocketOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebSocketOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebSocketOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebSocketOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebSocketOnclose(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebSocketOnclose(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebSocketProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebSocketExtensions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebSocketBinaryType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebSocketBinaryType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebSocketConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebSocketConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebSocketPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebSocketPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebSocketPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebSocketPrototype>(vm.heap)) JSWebSocketPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebSocketPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSWebSocket> JSWebSocketConstructor;

/* Hash table for constructor */

static const HashTableValue JSWebSocketConstructorTableValues[] =
{
    { "CONNECTING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPEN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CLOSING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CLOSED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(0 == WebSocket::CONNECTING, WebSocketEnumCONNECTINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == WebSocket::OPEN, WebSocketEnumOPENIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == WebSocket::CLOSING, WebSocketEnumCLOSINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == WebSocket::CLOSED, WebSocketEnumCLOSEDIsWrongUseDoNotCheckConstants);

static inline EncodedJSValue constructJSWebSocket1(ExecState* state)
{
    auto* castedThis = jsCast<JSWebSocketConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Vector<String> protocols = toNativeArray<String>(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "WebSocket");
    RefPtr<WebSocket> object = WebSocket::create(*context, url, protocols, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSWebSocket2(ExecState* state)
{
    auto* castedThis = jsCast<JSWebSocketConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String protocol = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "WebSocket");
    RefPtr<WebSocket> object = WebSocket::create(*context, url, protocol, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> EncodedJSValue JSC_HOST_CALL JSWebSocketConstructor::construct(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg1(state->argument(1));
    if (argsCount == 1 || (argsCount == 2 && (arg1.isUndefined() || arg1.isNull() || (arg1.isObject() && isJSArray(arg1)))))
        return constructJSWebSocket1(state);
    if (argsCount == 2)
        return constructJSWebSocket2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

template<> JSValue JSWebSocketConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebSocketConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebSocket::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebSocket"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSWebSocketConstructorTableValues, *this);
}

template<> const ClassInfo JSWebSocketConstructor::s_info = { "WebSocket", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebSocketConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebSocketPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebSocketConstructor) } },
    { "URL", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bufferedAmount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketBufferedAmount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onopen", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketOnopen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebSocketOnopen) } },
    { "onmessage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebSocketOnmessage) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebSocketOnerror) } },
    { "onclose", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketOnclose), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebSocketOnclose) } },
    { "protocol", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "extensions", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketExtensions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "binaryType", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebSocketBinaryType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebSocketBinaryType) } },
    { "send", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebSocketPrototypeFunctionSend), (intptr_t) (1) } },
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebSocketPrototypeFunctionClose), (intptr_t) (0) } },
    { "CONNECTING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPEN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CLOSING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CLOSED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSWebSocketPrototype::s_info = { "WebSocketPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebSocketPrototype) };

void JSWebSocketPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebSocketPrototypeTableValues, *this);
}

const ClassInfo JSWebSocket::s_info = { "WebSocket", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebSocket) };

JSWebSocket::JSWebSocket(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebSocket>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebSocket::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebSocketPrototype::create(vm, globalObject, JSWebSocketPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSWebSocket::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebSocket>(vm, globalObject);
}

EncodedJSValue jsWebSocketURL(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "URL");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.url());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketUrl(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "url");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.url());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketReadyState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "readyState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.readyState());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketBufferedAmount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "bufferedAmount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.bufferedAmount());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketOnopen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "onopen");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().openEvent));
}


EncodedJSValue jsWebSocketOnmessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "onmessage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().messageEvent));
}


EncodedJSValue jsWebSocketOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsWebSocketOnclose(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "onclose");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().closeEvent));
}


EncodedJSValue jsWebSocketProtocol(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "protocol");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrUndefined(state, impl.protocol());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketExtensions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "extensions");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrUndefined(state, impl.extensions());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketBinaryType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebSocket*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebSocket", "binaryType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.binaryType());
    return JSValue::encode(result);
}


EncodedJSValue jsWebSocketConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebSocketPrototype* domObject = jsDynamicCast<JSWebSocketPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebSocket::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebSocketConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebSocketPrototype* domObject = jsDynamicCast<JSWebSocketPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSWebSocketOnopen(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebSocket* castedThis = jsDynamicCast<JSWebSocket*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebSocket", "onopen");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().openEvent, value);
}


void setJSWebSocketOnmessage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebSocket* castedThis = jsDynamicCast<JSWebSocket*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebSocket", "onmessage");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().messageEvent, value);
}


void setJSWebSocketOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebSocket* castedThis = jsDynamicCast<JSWebSocket*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebSocket", "onerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSWebSocketOnclose(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebSocket* castedThis = jsDynamicCast<JSWebSocket*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebSocket", "onclose");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().closeEvent, value);
}


void setJSWebSocketBinaryType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebSocket* castedThis = jsDynamicCast<JSWebSocket*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebSocket", "binaryType");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBinaryType(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSWebSocket::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebSocketConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

static EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebSocket*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebSocket", "send");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebSocket::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ArrayBuffer* data = toArrayBuffer(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.send(data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebSocket*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebSocket", "send");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebSocket::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    RefPtr<ArrayBufferView> data = toArrayBufferView(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.send(data.get(), ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend3(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebSocket*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebSocket", "send");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebSocket::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Blob* data = JSBlob::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.send(data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend4(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebSocket*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebSocket", "send");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebSocket::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String data = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.send(data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSArrayBuffer::info())))))
        return jsWebSocketPrototypeFunctionSend1(state);
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSArrayBufferView::info())))))
        return jsWebSocketPrototypeFunctionSend2(state);
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSBlob::info())))))
        return jsWebSocketPrototypeFunctionSend3(state);
    if (argsCount == 1)
        return jsWebSocketPrototypeFunctionSend4(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionClose(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebSocket*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebSocket", "close");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebSocket::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.close(ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    unsigned short code = 0;
    double codeNativeValue = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    if (!std::isnan(codeNativeValue))
        code = clampTo<unsigned short>(codeNativeValue);

    if (argsCount <= 1) {
        impl.close(code, ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    String reason = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.close(code, reason, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSWebSocket::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWebSocket*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSWebSocketOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebSocket = jsCast<JSWebSocket*>(handle.slot()->asCell());
    if (jsWebSocket->wrapped().hasPendingActivity())
        return true;
    if (jsWebSocket->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebSocketOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebSocket = jsCast<JSWebSocket*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebSocket->wrapped(), jsWebSocket);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebSocket@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9WebSocketE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebSocket* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebSocket>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebSocket* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebSocket>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebSocket@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9WebSocketE[2];
#if COMPILER(CLANG)
    // If this fails WebSocket does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebSocket), WebSocket_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebSocket has subclasses. If WebSocket has subclasses that get passed
    // to toJS() we currently require WebSocket you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebSocket>(globalObject, impl);
}

WebSocket* JSWebSocket::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebSocket*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_SOCKETS)
