/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextAttributes.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLContextAttributesAlpha(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextAttributesAlpha(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGLContextAttributesDepth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextAttributesDepth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGLContextAttributesStencil(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextAttributesStencil(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGLContextAttributesAntialias(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextAttributesAntialias(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGLContextAttributesPremultipliedAlpha(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextAttributesPremultipliedAlpha(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGLContextAttributesPreserveDrawingBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextAttributesPreserveDrawingBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
void setJSWebGLContextAttributesConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLContextAttributesPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLContextAttributesPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLContextAttributesPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLContextAttributesPrototype>(vm.heap)) JSWebGLContextAttributesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLContextAttributesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLContextAttributesPrototypeTableValues[] =
{
    { "alpha", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextAttributesAlpha) } },
    { "depth", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesDepth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextAttributesDepth) } },
    { "stencil", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesStencil), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextAttributesStencil) } },
    { "antialias", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAntialias), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextAttributesAntialias) } },
    { "premultipliedAlpha", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPremultipliedAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextAttributesPremultipliedAlpha) } },
    { "preserveDrawingBuffer", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPreserveDrawingBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextAttributesPreserveDrawingBuffer) } },
};

const ClassInfo JSWebGLContextAttributesPrototype::s_info = { "WebGLContextAttributesPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLContextAttributesPrototype) };

void JSWebGLContextAttributesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLContextAttributesPrototypeTableValues, *this);
}

const ClassInfo JSWebGLContextAttributes::s_info = { "WebGLContextAttributes", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLContextAttributes) };

JSWebGLContextAttributes::JSWebGLContextAttributes(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLContextAttributes>&& impl)
    : JSDOMWrapper<WebGLContextAttributes>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLContextAttributes::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLContextAttributesPrototype::create(vm, globalObject, JSWebGLContextAttributesPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLContextAttributes::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextAttributes>(vm, globalObject);
}

void JSWebGLContextAttributes::destroy(JSC::JSCell* cell)
{
    JSWebGLContextAttributes* thisObject = static_cast<JSWebGLContextAttributes*>(cell);
    thisObject->JSWebGLContextAttributes::~JSWebGLContextAttributes();
}

EncodedJSValue jsWebGLContextAttributesAlpha(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextAttributes", "alpha");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.alpha());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLContextAttributesDepth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextAttributes", "depth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.depth());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLContextAttributesStencil(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextAttributes", "stencil");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.stencil());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLContextAttributesAntialias(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextAttributes", "antialias");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.antialias());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLContextAttributesPremultipliedAlpha(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextAttributes", "premultipliedAlpha");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.premultipliedAlpha());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLContextAttributesPreserveDrawingBuffer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextAttributes", "preserveDrawingBuffer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.preserveDrawingBuffer());
    return JSValue::encode(result);
}


void setJSWebGLContextAttributesConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLContextAttributesPrototype* domObject = jsDynamicCast<JSWebGLContextAttributesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSWebGLContextAttributesAlpha(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebGLContextAttributes* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebGLContextAttributes", "alpha");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAlpha(nativeValue);
}


void setJSWebGLContextAttributesDepth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebGLContextAttributes* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebGLContextAttributes", "depth");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDepth(nativeValue);
}


void setJSWebGLContextAttributesStencil(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebGLContextAttributes* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebGLContextAttributes", "stencil");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setStencil(nativeValue);
}


void setJSWebGLContextAttributesAntialias(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebGLContextAttributes* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebGLContextAttributes", "antialias");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAntialias(nativeValue);
}


void setJSWebGLContextAttributesPremultipliedAlpha(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebGLContextAttributes* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebGLContextAttributes", "premultipliedAlpha");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPremultipliedAlpha(nativeValue);
}


void setJSWebGLContextAttributesPreserveDrawingBuffer(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebGLContextAttributes* castedThis = jsDynamicCast<JSWebGLContextAttributes*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebGLContextAttributes", "preserveDrawingBuffer");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPreserveDrawingBuffer(nativeValue);
}


bool JSWebGLContextAttributesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLContextAttributesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLContextAttributes = jsCast<JSWebGLContextAttributes*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLContextAttributes->wrapped(), jsWebGLContextAttributes);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLContextAttributes@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLContextAttributesE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLContextAttributes* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLContextAttributes>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLContextAttributes* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLContextAttributes>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLContextAttributes@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22WebGLContextAttributesE[2];
#if COMPILER(CLANG)
    // If this fails WebGLContextAttributes does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLContextAttributes), WebGLContextAttributes_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLContextAttributes has subclasses. If WebGLContextAttributes has subclasses that get passed
    // to toJS() we currently require WebGLContextAttributes you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLContextAttributes>(globalObject, impl);
}

WebGLContextAttributes* JSWebGLContextAttributes::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLContextAttributes*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
