/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVTTCue.h"

#include "DocumentFragment.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocumentFragment.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsVTTCuePrototypeFunctionGetCueAsHTML(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsVTTCueVertical(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueVertical(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueSnapToLines(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueSnapToLines(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueLine(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueLine(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCuePosition(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCuePosition(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueRegionId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueRegionId(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTCueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVTTCuePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSVTTCuePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVTTCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSVTTCuePrototype>(vm.heap)) JSVTTCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVTTCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSVTTCue> JSVTTCueConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSVTTCueConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSVTTCueConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    double startTime = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double endTime = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String text = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "VTTCue");
    RefPtr<VTTCue> object = VTTCue::create(*context, startTime, endTime, text);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSVTTCueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTextTrackCue::getConstructor(vm, &globalObject);
}

template<> void JSVTTCueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVTTCue::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("VTTCue"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(3), ReadOnly | DontEnum);
}

template<> const ClassInfo JSVTTCueConstructor::s_info = { "VTTCue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVTTCueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVTTCuePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueConstructor) } },
    { "vertical", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueVertical), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueVertical) } },
    { "snapToLines", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueSnapToLines), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueSnapToLines) } },
    { "line", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueLine), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueLine) } },
    { "position", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCuePosition), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCuePosition) } },
    { "size", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueSize) } },
    { "align", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueAlign) } },
    { "text", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueText) } },
    { "regionId", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueRegionId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueRegionId) } },
    { "getCueAsHTML", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsVTTCuePrototypeFunctionGetCueAsHTML), (intptr_t) (0) } },
};

const ClassInfo JSVTTCuePrototype::s_info = { "VTTCuePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVTTCuePrototype) };

void JSVTTCuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVTTCuePrototypeTableValues, *this);
}

const ClassInfo JSVTTCue::s_info = { "VTTCue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVTTCue) };

JSVTTCue::JSVTTCue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VTTCue>&& impl)
    : JSTextTrackCue(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSVTTCue::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSVTTCuePrototype::create(vm, globalObject, JSVTTCuePrototype::createStructure(vm, globalObject, JSTextTrackCue::getPrototype(vm, globalObject)));
}

JSObject* JSVTTCue::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSVTTCue>(vm, globalObject);
}

EncodedJSValue jsVTTCueVertical(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "vertical");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.vertical());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueSnapToLines(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "snapToLines");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.snapToLines());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueLine(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "line");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.line());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCuePosition(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "position");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.position());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "size");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.size());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueAlign(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "align");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.align());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "text");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.text());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueRegionId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTCue", "regionId");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.regionId());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTCueConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSVTTCuePrototype* domObject = jsDynamicCast<JSVTTCuePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSVTTCue::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSVTTCueConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSVTTCuePrototype* domObject = jsDynamicCast<JSVTTCuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSVTTCueVertical(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "vertical");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setVertical(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTCueSnapToLines(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "snapToLines");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSnapToLines(nativeValue);
}


void setJSVTTCueLine(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "line");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLine(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTCuePosition(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "position");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPosition(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTCueSize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "size");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSize(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTCueAlign(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "align");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAlign(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTCueText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "text");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setText(nativeValue);
}


void setJSVTTCueRegionId(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTCue* castedThis = jsDynamicCast<JSVTTCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTCue", "regionId");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setRegionId(nativeValue);
}


JSValue JSVTTCue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVTTCueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsVTTCuePrototypeFunctionGetCueAsHTML(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSVTTCue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "VTTCue", "getCueAsHTML");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSVTTCue::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getCueAsHTML()));
    return JSValue::encode(result);
}

void JSVTTCue::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSVTTCue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VTTCue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6VTTCueE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, VTTCue* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSVTTCue>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, VTTCue* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSVTTCue>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7VTTCue@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore6VTTCueE[2];
#if COMPILER(CLANG)
    // If this fails VTTCue does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(VTTCue), VTTCue_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // VTTCue has subclasses. If VTTCue has subclasses that get passed
    // to toJS() we currently require VTTCue you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSVTTCue>(globalObject, impl);
}

VTTCue* JSVTTCue::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVTTCue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
