/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGTSpanElement.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGTSpanElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGTSpanElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGTSpanElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGTSpanElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGTSpanElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGTSpanElementPrototype>(vm.heap)) JSSVGTSpanElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGTSpanElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGTSpanElement> JSSVGTSpanElementConstructor;

template<> JSValue JSSVGTSpanElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGTextPositioningElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGTSpanElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGTSpanElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGTSpanElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGTSpanElementConstructor::s_info = { "SVGTSpanElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGTSpanElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGTSpanElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTSpanElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGTSpanElementConstructor) } },
};

const ClassInfo JSSVGTSpanElementPrototype::s_info = { "SVGTSpanElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGTSpanElementPrototype) };

void JSSVGTSpanElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGTSpanElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGTSpanElement::s_info = { "SVGTSpanElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGTSpanElement) };

JSSVGTSpanElement::JSSVGTSpanElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGTSpanElement>&& impl)
    : JSSVGTextPositioningElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGTSpanElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGTSpanElementPrototype::create(vm, globalObject, JSSVGTSpanElementPrototype::createStructure(vm, globalObject, JSSVGTextPositioningElement::getPrototype(vm, globalObject)));
}

JSObject* JSSVGTSpanElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTSpanElement>(vm, globalObject);
}

EncodedJSValue jsSVGTSpanElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGTSpanElementPrototype* domObject = jsDynamicCast<JSSVGTSpanElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGTSpanElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGTSpanElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGTSpanElementPrototype* domObject = jsDynamicCast<JSSVGTSpanElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGTSpanElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTSpanElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGTSpanElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGTSpanElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
