/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRect.h"

#include "CSSPrimitiveValue.h"
#include "JSCSSPrimitiveValue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsRectTop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRectRight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRectBottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRectLeft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSRectPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSRectPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRectPrototype* ptr = new (NotNull, JSC::allocateCell<JSRectPrototype>(vm.heap)) JSRectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSRect> JSRectConstructor;

template<> JSValue JSRectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRect::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Rect"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSRectConstructor::s_info = { "Rect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRectPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRectConstructor) } },
    { "top", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRectTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "right", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRectRight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bottom", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRectBottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "left", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRectLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSRectPrototype::s_info = { "RectPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRectPrototype) };

void JSRectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRectPrototypeTableValues, *this);
}

const ClassInfo JSRect::s_info = { "Rect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRect) };

JSRect::JSRect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Rect>&& impl)
    : JSDOMWrapper<Rect>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSRect::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSRectPrototype::create(vm, globalObject, JSRectPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSRect::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRect>(vm, globalObject);
}

void JSRect::destroy(JSC::JSCell* cell)
{
    JSRect* thisObject = static_cast<JSRect*>(cell);
    thisObject->JSRect::~JSRect();
}

EncodedJSValue jsRectTop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Rect", "top");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.top()));
    return JSValue::encode(result);
}


EncodedJSValue jsRectRight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Rect", "right");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.right()));
    return JSValue::encode(result);
}


EncodedJSValue jsRectBottom(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Rect", "bottom");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.bottom()));
    return JSValue::encode(result);
}


EncodedJSValue jsRectLeft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Rect", "left");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.left()));
    return JSValue::encode(result);
}


EncodedJSValue jsRectConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSRectPrototype* domObject = jsDynamicCast<JSRectPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSRect::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSRectConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSRectPrototype* domObject = jsDynamicCast<JSRectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSRect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRect = jsCast<JSRect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRect->wrapped(), jsRect);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Rect* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSRect>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Rect* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSRect>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Rect.
    COMPILE_ASSERT(!__is_polymorphic(Rect), Rect_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSRect>(globalObject, impl);
}

Rect* JSRect::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
