/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(STREAMS_API)

#include "JSReadableStreamController.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "ReadableStreamControllerBuiltins.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions


// Attributes

JSC::EncodedJSValue jsReadableStreamControllerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSReadableStreamControllerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSReadableStreamControllerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSReadableStreamControllerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSReadableStreamControllerPrototype* ptr = new (NotNull, JSC::allocateCell<JSReadableStreamControllerPrototype>(vm.heap)) JSReadableStreamControllerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSReadableStreamControllerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSReadableStreamController> JSReadableStreamControllerConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSReadableStreamControllerConstructor::construct(JSC::ExecState* state)
{
    return constructJSReadableStreamController(state);
}

template<> JSValue JSReadableStreamControllerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSReadableStreamControllerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSReadableStreamController::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ReadableStreamController"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSReadableStreamControllerConstructor::s_info = { "ReadableStreamController", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamControllerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSReadableStreamControllerPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsReadableStreamControllerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSReadableStreamControllerConstructor) } },
    { "desiredSize", ReadOnly | Accessor | Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamControllerDesiredSizeCodeGenerator), (intptr_t) (0) } },
    { "enqueue", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamControllerEnqueueCodeGenerator), (intptr_t) (0) } },
    { "close", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamControllerCloseCodeGenerator), (intptr_t) (0) } },
    { "error", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamControllerErrorCodeGenerator), (intptr_t) (0) } },
};

const ClassInfo JSReadableStreamControllerPrototype::s_info = { "ReadableStreamControllerPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamControllerPrototype) };

void JSReadableStreamControllerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSReadableStreamControllerPrototypeTableValues, *this);
}

const ClassInfo JSReadableStreamController::s_info = { "ReadableStreamController", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamController) };

JSReadableStreamController::JSReadableStreamController(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

JSObject* JSReadableStreamController::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSReadableStreamControllerPrototype::create(vm, globalObject, JSReadableStreamControllerPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSReadableStreamController::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSReadableStreamController>(vm, globalObject);
}

void JSReadableStreamController::destroy(JSC::JSCell* cell)
{
    JSReadableStreamController* thisObject = static_cast<JSReadableStreamController*>(cell);
    thisObject->JSReadableStreamController::~JSReadableStreamController();
}

EncodedJSValue jsReadableStreamControllerConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSReadableStreamControllerPrototype* domObject = jsDynamicCast<JSReadableStreamControllerPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    JSValue constructor = JSReadableStreamControllerConstructor::create(state->vm(), JSReadableStreamControllerConstructor::createStructure(state->vm(), *domObject->globalObject(), domObject->globalObject()->objectPrototype()), *jsCast<JSDOMGlobalObject*>(domObject->globalObject()));
    // Shadowing constructor property to ensure reusing the same constructor object
    domObject->putDirect(state->vm(), state->propertyNames().constructor, constructor, DontEnum | ReadOnly);
    return JSValue::encode(constructor);
}

void setJSReadableStreamControllerConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSReadableStreamControllerPrototype* domObject = jsDynamicCast<JSReadableStreamControllerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}


}

#endif // ENABLE(STREAMS_API)
