/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeFilter.h"

#include "JSDOMConstructor.h"
#include "ScriptExecutionContext.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSLock.h>

using namespace JSC;

namespace WebCore {

JSNodeFilter::JSNodeFilter(JSObject* callback, JSDOMGlobalObject* globalObject)
    : NodeFilter()
    , ActiveDOMCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackDataWeak(callback, this))
{
}

JSNodeFilter::~JSNodeFilter()
{
    ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

typedef JSDOMConstructorNotConstructable<JSNodeFilter> JSNodeFilterConstructor;

/* Hash table for constructor */

static const HashTableValue JSNodeFilterConstructorTableValues[] =
{
    { "FILTER_ACCEPT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "FILTER_REJECT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FILTER_SKIP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SHOW_ALL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0xFFFFFFFF) } },
    { "SHOW_ELEMENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000001) } },
    { "SHOW_ATTRIBUTE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000002) } },
    { "SHOW_TEXT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000004) } },
    { "SHOW_CDATA_SECTION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000008) } },
    { "SHOW_ENTITY_REFERENCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000010) } },
    { "SHOW_ENTITY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000020) } },
    { "SHOW_PROCESSING_INSTRUCTION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000040) } },
    { "SHOW_COMMENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000080) } },
    { "SHOW_DOCUMENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000100) } },
    { "SHOW_DOCUMENT_TYPE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000200) } },
    { "SHOW_DOCUMENT_FRAGMENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000400) } },
    { "SHOW_NOTATION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00000800) } },
};


COMPILE_ASSERT(1 == NodeFilter::FILTER_ACCEPT, NodeFilterEnumFILTER_ACCEPTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == NodeFilter::FILTER_REJECT, NodeFilterEnumFILTER_REJECTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == NodeFilter::FILTER_SKIP, NodeFilterEnumFILTER_SKIPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0xFFFFFFFF == NodeFilter::SHOW_ALL, NodeFilterEnumSHOW_ALLIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000001 == NodeFilter::SHOW_ELEMENT, NodeFilterEnumSHOW_ELEMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000002 == NodeFilter::SHOW_ATTRIBUTE, NodeFilterEnumSHOW_ATTRIBUTEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000004 == NodeFilter::SHOW_TEXT, NodeFilterEnumSHOW_TEXTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000008 == NodeFilter::SHOW_CDATA_SECTION, NodeFilterEnumSHOW_CDATA_SECTIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000010 == NodeFilter::SHOW_ENTITY_REFERENCE, NodeFilterEnumSHOW_ENTITY_REFERENCEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000020 == NodeFilter::SHOW_ENTITY, NodeFilterEnumSHOW_ENTITYIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000040 == NodeFilter::SHOW_PROCESSING_INSTRUCTION, NodeFilterEnumSHOW_PROCESSING_INSTRUCTIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000080 == NodeFilter::SHOW_COMMENT, NodeFilterEnumSHOW_COMMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000100 == NodeFilter::SHOW_DOCUMENT, NodeFilterEnumSHOW_DOCUMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000200 == NodeFilter::SHOW_DOCUMENT_TYPE, NodeFilterEnumSHOW_DOCUMENT_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000400 == NodeFilter::SHOW_DOCUMENT_FRAGMENT, NodeFilterEnumSHOW_DOCUMENT_FRAGMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000800 == NodeFilter::SHOW_NOTATION, NodeFilterEnumSHOW_NOTATIONIsWrongUseDoNotCheckConstants);

template<> JSValue JSNodeFilterConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNodeFilterConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(globalObject);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("NodeFilter"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSNodeFilterConstructorTableValues, *this);
}

template<> const ClassInfo JSNodeFilterConstructor::s_info = { "NodeFilter", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNodeFilterConstructor) };

JSValue JSNodeFilter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeFilterConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


// Functions

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, NodeFilter* impl)
{
    if (!impl || !static_cast<JSNodeFilter&>(*impl).callbackData())
        return jsNull();

    return static_cast<JSNodeFilter&>(*impl).callbackData()->callback();

}

}
