/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationObserver.h"

#include "Dictionary.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSMutationRecord.h"
#include "JSNode.h"
#include "MutationRecord.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionObserve(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionTakeRecords(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionDisconnect(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMutationObserverConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMutationObserverConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMutationObserverPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMutationObserverPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMutationObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSMutationObserverPrototype>(vm.heap)) JSMutationObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMutationObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSMutationObserver> JSMutationObserverConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSMutationObserverConstructor::construct(JSC::ExecState* state)
{
    return constructJSMutationObserver(state);
}

template<> JSValue JSMutationObserverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMutationObserverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMutationObserver::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MutationObserver"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMutationObserverConstructor::s_info = { "MutationObserver", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationObserverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMutationObserverPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMutationObserverConstructor) } },
    { "observe", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMutationObserverPrototypeFunctionObserve), (intptr_t) (2) } },
    { "takeRecords", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMutationObserverPrototypeFunctionTakeRecords), (intptr_t) (0) } },
    { "disconnect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMutationObserverPrototypeFunctionDisconnect), (intptr_t) (0) } },
};

const ClassInfo JSMutationObserverPrototype::s_info = { "MutationObserverPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationObserverPrototype) };

void JSMutationObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMutationObserverPrototypeTableValues, *this);
}

const ClassInfo JSMutationObserver::s_info = { "MutationObserver", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationObserver) };

JSMutationObserver::JSMutationObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MutationObserver>&& impl)
    : JSDOMWrapper<MutationObserver>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMutationObserver::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMutationObserverPrototype::create(vm, globalObject, JSMutationObserverPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSMutationObserver::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMutationObserver>(vm, globalObject);
}

void JSMutationObserver::destroy(JSC::JSCell* cell)
{
    JSMutationObserver* thisObject = static_cast<JSMutationObserver*>(cell);
    thisObject->JSMutationObserver::~JSMutationObserver();
}

EncodedJSValue jsMutationObserverConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMutationObserverPrototype* domObject = jsDynamicCast<JSMutationObserverPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMutationObserver::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMutationObserverConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMutationObserverPrototype* domObject = jsDynamicCast<JSMutationObserverPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSMutationObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationObserverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionObserve(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMutationObserver*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MutationObserver", "observe");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMutationObserver::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* target = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Dictionary options = { state, state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.observe(target, options, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionTakeRecords(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMutationObserver*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MutationObserver", "takeRecords");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMutationObserver::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsArray(state, castedThis->globalObject(), impl.takeRecords());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionDisconnect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMutationObserver*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MutationObserver", "disconnect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMutationObserver::info());
    auto& impl = castedThis->wrapped();
    impl.disconnect();
    return JSValue::encode(jsUndefined());
}

void JSMutationObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMutationObserver = jsCast<JSMutationObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMutationObserver->wrapped(), jsMutationObserver);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MutationObserver* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMutationObserver>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MutationObserver* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMutationObserver>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MutationObserver.
    COMPILE_ASSERT(!__is_polymorphic(MutationObserver), MutationObserver_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSMutationObserver>(globalObject, impl);
}

MutationObserver* JSMutationObserver::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMutationObserver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
