/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "Node.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMutationEventPrototypeFunctionInitMutationEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMutationEventRelatedNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationEventPrevValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationEventNewValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationEventAttrName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationEventAttrChange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMutationEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMutationEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMutationEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMutationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSMutationEventPrototype>(vm.heap)) JSMutationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMutationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSMutationEvent> JSMutationEventConstructor;

/* Hash table for constructor */

static const HashTableValue JSMutationEventConstructorTableValues[] =
{
    { "MODIFICATION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "ADDITION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "REMOVAL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(1 == MutationEvent::MODIFICATION, MutationEventEnumMODIFICATIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == MutationEvent::ADDITION, MutationEventEnumADDITIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == MutationEvent::REMOVAL, MutationEventEnumREMOVALIsWrongUseDoNotCheckConstants);

template<> JSValue JSMutationEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSMutationEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMutationEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MutationEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSMutationEventConstructorTableValues, *this);
}

template<> const ClassInfo JSMutationEventConstructor::s_info = { "MutationEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMutationEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMutationEventConstructor) } },
    { "relatedNode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventRelatedNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "prevValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventPrevValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "newValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventNewValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attrName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventAttrName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attrChange", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventAttrChange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initMutationEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMutationEventPrototypeFunctionInitMutationEvent), (intptr_t) (0) } },
    { "MODIFICATION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "ADDITION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "REMOVAL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSMutationEventPrototype::s_info = { "MutationEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationEventPrototype) };

void JSMutationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMutationEventPrototypeTableValues, *this);
}

const ClassInfo JSMutationEvent::s_info = { "MutationEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationEvent) };

JSMutationEvent::JSMutationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MutationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMutationEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMutationEventPrototype::create(vm, globalObject, JSMutationEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSMutationEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMutationEvent>(vm, globalObject);
}

EncodedJSValue jsMutationEventRelatedNode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationEvent", "relatedNode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.relatedNode()));
    return JSValue::encode(result);
}


EncodedJSValue jsMutationEventPrevValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationEvent", "prevValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.prevValue());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationEventNewValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationEvent", "newValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.newValue());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationEventAttrName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationEvent", "attrName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.attrName());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationEventAttrChange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationEvent", "attrChange");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.attrChange());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMutationEventPrototype* domObject = jsDynamicCast<JSMutationEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMutationEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMutationEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMutationEventPrototype* domObject = jsDynamicCast<JSMutationEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSMutationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMutationEventPrototypeFunctionInitMutationEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMutationEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MutationEvent", "initMutationEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMutationEvent::info());
    auto& impl = castedThis->wrapped();
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool canBubble = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool cancelable = state->argument(2).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Node* relatedNode = JSNode::toWrapped(state->argument(3));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String prevValue = state->argument(4).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String newValue = state->argument(5).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String attrName = state->argument(6).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    uint16_t attrChange = toUInt16(state, state->argument(7), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initMutationEvent(type, canBubble, cancelable, relatedNode, prevValue, newValue, attrName, attrChange);
    return JSValue::encode(jsUndefined());
}


}
