/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPath.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMPath.h"
#include "JSSVGMatrix.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionAddPath(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionClosePath(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionMoveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionLineTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionQuadraticCurveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionBezierCurveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionArcTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionArc(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionEllipse(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMPathConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMPathConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMPathPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMPathPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMPathPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMPathPrototype>(vm.heap)) JSDOMPathPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMPathPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDOMPath> JSDOMPathConstructor;

static inline EncodedJSValue constructJSDOMPath1(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMPathConstructor*>(state->callee());
    RefPtr<DOMPath> object = DOMPath::create();
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSDOMPath2(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMPathConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<DOMPath> object = DOMPath::create(path);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSDOMPath3(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMPathConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String text = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<DOMPath> object = DOMPath::create(text);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> EncodedJSValue JSC_HOST_CALL JSDOMPathConstructor::construct(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    if (argsCount == 0)
        return constructJSDOMPath1(state);
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))))
        return constructJSDOMPath2(state);
    if (argsCount == 1)
        return constructJSDOMPath3(state);
    return throwVMTypeError(state);
}

template<> JSValue JSDOMPathConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMPathConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMPath::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Path2D"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMPathConstructor::s_info = { "Path2D", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMPathConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMPathPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPathConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPathConstructor) } },
    { "addPath", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionAddPath), (intptr_t) (1) } },
    { "closePath", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionClosePath), (intptr_t) (0) } },
    { "moveTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionMoveTo), (intptr_t) (0) } },
    { "lineTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionLineTo), (intptr_t) (0) } },
    { "quadraticCurveTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionQuadraticCurveTo), (intptr_t) (0) } },
    { "bezierCurveTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionBezierCurveTo), (intptr_t) (0) } },
    { "arcTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionArcTo), (intptr_t) (0) } },
    { "rect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionRect), (intptr_t) (0) } },
    { "arc", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionArc), (intptr_t) (0) } },
    { "ellipse", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionEllipse), (intptr_t) (7) } },
};

const ClassInfo JSDOMPathPrototype::s_info = { "Path2DPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMPathPrototype) };

void JSDOMPathPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMPathPrototypeTableValues, *this);
}

const ClassInfo JSDOMPath::s_info = { "Path2D", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMPath) };

JSDOMPath::JSDOMPath(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMPath>&& impl)
    : JSDOMWrapper<DOMPath>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMPath::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMPathPrototype::create(vm, globalObject, JSDOMPathPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMPath::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMPath>(vm, globalObject);
}

void JSDOMPath::destroy(JSC::JSCell* cell)
{
    JSDOMPath* thisObject = static_cast<JSDOMPath*>(cell);
    thisObject->JSDOMPath::~JSDOMPath();
}

EncodedJSValue jsDOMPathConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMPathPrototype* domObject = jsDynamicCast<JSDOMPathPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMPath::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMPathConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMPathPrototype* domObject = jsDynamicCast<JSDOMPathPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDOMPath::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPathConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionAddPath(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "addPath");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.addPath(path);
        return JSValue::encode(jsUndefined());
    }

    SVGPropertyTearOff<SVGMatrix>* transform = JSSVGMatrix::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!transform) {
        setDOMException(state, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    impl.addPath(path, transform->propertyReference());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionClosePath(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "closePath");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    impl.closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionMoveTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "moveTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.moveTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionLineTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "lineTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.lineTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionQuadraticCurveTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "quadraticCurveTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    float cpx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(cpx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float cpy = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(cpy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float x = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.quadraticCurveTo(cpx, cpy, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionBezierCurveTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "bezierCurveTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    float cp1x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(cp1x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float cp1y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(cp1y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float cp2x = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(cp2x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float cp2y = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(cp2y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float x = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionArcTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "arcTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    float x1 = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y1 = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float x2 = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x2)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y2 = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y2)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float radius = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(radius)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "rect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float width = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(width)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float height = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(height)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.rect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionArc(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "arc");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float radius = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(radius)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float startAngle = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(startAngle)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float endAngle = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(endAngle)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    bool anticlockwise = state->argument(5).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionEllipse(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMPath*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMPath", "ellipse");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMPath::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 7))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float radiusX = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float radiusY = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float rotation = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float startAngle = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float endAngle = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool anticlockwise = state->argument(7).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

bool JSDOMPathOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMPathOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMPath = jsCast<JSDOMPath*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMPath->wrapped(), jsDOMPath);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMPath@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7DOMPathE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMPath* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMPath>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMPath* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMPath>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMPath@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7DOMPathE[2];
#if COMPILER(CLANG)
    // If this fails DOMPath does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMPath), DOMPath_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMPath has subclasses. If DOMPath has subclasses that get passed
    // to toJS() we currently require DOMPath you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSDOMPath>(globalObject, impl);
}

DOMPath* JSDOMPath::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMPath*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
