/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSComment.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCommentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCommentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCommentPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCommentPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCommentPrototype* ptr = new (NotNull, JSC::allocateCell<JSCommentPrototype>(vm.heap)) JSCommentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCommentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSComment> JSCommentConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSCommentConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSCommentConstructor*>(state->callee());
    String data = state->argument(0).isUndefined() ? String() : state->uncheckedArgument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "Comment");
    auto& document = downcast<Document>(*context);
    RefPtr<Comment> object = Comment::create(document, data);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSCommentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCharacterData::getConstructor(vm, &globalObject);
}

template<> void JSCommentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSComment::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Comment"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCommentConstructor::s_info = { "Comment", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCommentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCommentPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCommentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCommentConstructor) } },
};

const ClassInfo JSCommentPrototype::s_info = { "CommentPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCommentPrototype) };

void JSCommentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCommentPrototypeTableValues, *this);
}

const ClassInfo JSComment::s_info = { "Comment", &Base::s_info, 0, CREATE_METHOD_TABLE(JSComment) };

JSComment::JSComment(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Comment>&& impl)
    : JSCharacterData(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSComment::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCommentPrototype::create(vm, globalObject, JSCommentPrototype::createStructure(vm, globalObject, JSCharacterData::getPrototype(vm, globalObject)));
}

JSObject* JSComment::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSComment>(vm, globalObject);
}

EncodedJSValue jsCommentConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCommentPrototype* domObject = jsDynamicCast<JSCommentPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSComment::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCommentConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCommentPrototype* domObject = jsDynamicCast<JSCommentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSComment::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCommentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSComment::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSComment*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Comment@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7CommentE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Comment* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSComment>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Comment* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSComment>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Comment@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7CommentE[2];
#if COMPILER(CLANG)
    // If this fails Comment does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Comment), Comment_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Comment has subclasses. If Comment has subclasses that get passed
    // to toJS() we currently require Comment you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSComment>(globalObject, impl);
}


}
