/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBiquadFilterNode.h"

#include "AudioParam.h"
#include "ExceptionCode.h"
#include "JSAudioParam.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsBiquadFilterNodePrototypeFunctionGetFrequencyResponse(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsBiquadFilterNodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSBiquadFilterNodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsBiquadFilterNodeFrequency(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeDetune(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeQ(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeGain(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSBiquadFilterNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSBiquadFilterNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSBiquadFilterNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBiquadFilterNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSBiquadFilterNodePrototype>(vm.heap)) JSBiquadFilterNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBiquadFilterNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSBiquadFilterNode> JSBiquadFilterNodeConstructor;

/* Hash table for constructor */

static const HashTableValue JSBiquadFilterNodeConstructorTableValues[] =
{
    { "LOWPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HIGHPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "BANDPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LOWSHELF", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HIGHSHELF", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "PEAKING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "NOTCH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "ALLPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
};


COMPILE_ASSERT(0 == BiquadFilterNode::LOWPASS, BiquadFilterNodeEnumLOWPASSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == BiquadFilterNode::HIGHPASS, BiquadFilterNodeEnumHIGHPASSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == BiquadFilterNode::BANDPASS, BiquadFilterNodeEnumBANDPASSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == BiquadFilterNode::LOWSHELF, BiquadFilterNodeEnumLOWSHELFIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == BiquadFilterNode::HIGHSHELF, BiquadFilterNodeEnumHIGHSHELFIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == BiquadFilterNode::PEAKING, BiquadFilterNodeEnumPEAKINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == BiquadFilterNode::NOTCH, BiquadFilterNodeEnumNOTCHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == BiquadFilterNode::ALLPASS, BiquadFilterNodeEnumALLPASSIsWrongUseDoNotCheckConstants);

template<> JSValue JSBiquadFilterNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSBiquadFilterNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSBiquadFilterNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("BiquadFilterNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSBiquadFilterNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSBiquadFilterNodeConstructor::s_info = { "BiquadFilterNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBiquadFilterNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSBiquadFilterNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBiquadFilterNodeConstructor) } },
    { "type", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBiquadFilterNodeType) } },
    { "frequency", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeFrequency), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "detune", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeDetune), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "Q", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeQ), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gain", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getFrequencyResponse", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsBiquadFilterNodePrototypeFunctionGetFrequencyResponse), (intptr_t) (3) } },
    { "LOWPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HIGHPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "BANDPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LOWSHELF", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HIGHSHELF", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "PEAKING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "NOTCH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "ALLPASS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
};

const ClassInfo JSBiquadFilterNodePrototype::s_info = { "BiquadFilterNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBiquadFilterNodePrototype) };

void JSBiquadFilterNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBiquadFilterNodePrototypeTableValues, *this);
}

const ClassInfo JSBiquadFilterNode::s_info = { "BiquadFilterNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBiquadFilterNode) };

JSBiquadFilterNode::JSBiquadFilterNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BiquadFilterNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSBiquadFilterNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSBiquadFilterNodePrototype::create(vm, globalObject, JSBiquadFilterNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSBiquadFilterNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBiquadFilterNode>(vm, globalObject);
}

EncodedJSValue jsBiquadFilterNodeType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBiquadFilterNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BiquadFilterNode", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsBiquadFilterNodeFrequency(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBiquadFilterNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BiquadFilterNode", "frequency");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.frequency()));
    return JSValue::encode(result);
}


EncodedJSValue jsBiquadFilterNodeDetune(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBiquadFilterNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BiquadFilterNode", "detune");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.detune()));
    return JSValue::encode(result);
}


EncodedJSValue jsBiquadFilterNodeQ(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBiquadFilterNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BiquadFilterNode", "Q");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.q()));
    return JSValue::encode(result);
}


EncodedJSValue jsBiquadFilterNodeGain(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBiquadFilterNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BiquadFilterNode", "gain");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.gain()));
    return JSValue::encode(result);
}


EncodedJSValue jsBiquadFilterNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSBiquadFilterNodePrototype* domObject = jsDynamicCast<JSBiquadFilterNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSBiquadFilterNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSBiquadFilterNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSBiquadFilterNodePrototype* domObject = jsDynamicCast<JSBiquadFilterNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSBiquadFilterNodeType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSBiquadFilterNode* castedThis = jsDynamicCast<JSBiquadFilterNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "BiquadFilterNode", "type");
        return;
    }
    castedThis->setType(*state, value);
}


JSValue JSBiquadFilterNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBiquadFilterNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsBiquadFilterNodePrototypeFunctionGetFrequencyResponse(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSBiquadFilterNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "BiquadFilterNode", "getFrequencyResponse");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSBiquadFilterNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    RefPtr<Float32Array> frequencyHz = toFloat32Array(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<Float32Array> magResponse = toFloat32Array(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<Float32Array> phaseResponse = toFloat32Array(state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.getFrequencyResponse(frequencyHz.get(), magResponse.get(), phaseResponse.get());
    return JSValue::encode(jsUndefined());
}

void JSBiquadFilterNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSBiquadFilterNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BiquadFilterNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16BiquadFilterNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, BiquadFilterNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSBiquadFilterNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, BiquadFilterNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSBiquadFilterNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7BiquadFilterNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16BiquadFilterNodeE[2];
#if COMPILER(CLANG)
    // If this fails BiquadFilterNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(BiquadFilterNode), BiquadFilterNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // BiquadFilterNode has subclasses. If BiquadFilterNode has subclasses that get passed
    // to toJS() we currently require BiquadFilterNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSBiquadFilterNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
